<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRequestOfWaybillInfo StructType
 * @subpackage Structs
 */
class ServiceRequestOfWaybillInfo extends AbstractStructBase
{
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageSize;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Token
     */
    public $Token;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var WaybillInfo
     */
    public $Value;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Attachment;

    /**
     * Constructor method for ServiceRequestOfWaybillInfo
     * @param int $pageIndex
     * @param int $pageSize
     * @param Token $token
     * @param WaybillInfo $value
     * @param string $attachment
     * @uses ServiceRequestOfWaybillInfo::setPageIndex()
     * @uses ServiceRequestOfWaybillInfo::setPageSize()
     * @uses ServiceRequestOfWaybillInfo::setToken()
     * @uses ServiceRequestOfWaybillInfo::setValue()
     * @uses ServiceRequestOfWaybillInfo::setAttachment()
     */
    public function __construct($pageIndex = null, $pageSize = null, Token $token = null, WaybillInfo $value = null, $attachment = null)
    {
        $this
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize)
            ->setToken($token)
            ->setValue($value)
            ->setAttachment($attachment);
    }

    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }

    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return ServiceRequestOfWaybillInfo
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }

    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }

    /**
     * Set PageSize value
     * @param int $pageSize
     * @return ServiceRequestOfWaybillInfo
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }

    /**
     * Get Token value
     * @return Token|null
     */
    public function getToken()
    {
        return $this->Token;
    }

    /**
     * Set Token value
     * @param Token $token
     * @return ServiceRequestOfWaybillInfo
     */
    public function setToken(Token $token = null)
    {
        $this->Token = $token;
        return $this;
    }

    /**
     * Get Value value
     * @return WaybillInfo|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param WaybillInfo $value
     * @return ServiceRequestOfWaybillInfo
     */
    public function setValue(WaybillInfo $value = null)
    {
        $this->Value = $value;
        return $this;
    }

    /**
     * Get Attachment value
     * @return string|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }

    /**
     * Set Attachment value
     * @param string $attachment
     * @return ServiceRequestOfWaybillInfo
     */
    public function setAttachment($attachment = null)
    {
        // validation for constraint: string
        if (!is_null($attachment) && !is_string($attachment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachment, true), gettype($attachment)), __LINE__);
        }
        $this->Attachment = $attachment;
        return $this;
    }
}
