<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRequestOfRequestDef StructType
 * @subpackage Structs
 */
class ServiceRequestOfRequestDef extends AbstractStructBase
{
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageSize;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Token
     */
    public $Token;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RequestDef
     */
    public $Value;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Attachment;

    /**
     * Constructor method for ServiceRequestOfRequestDef
     * @param int $pageIndex
     * @param int $pageSize
     * @param Token $token
     * @param RequestDef $value
     * @param string $attachment
     * @uses ServiceRequestOfRequestDef::setPageIndex()
     * @uses ServiceRequestOfRequestDef::setPageSize()
     * @uses ServiceRequestOfRequestDef::setToken()
     * @uses ServiceRequestOfRequestDef::setValue()
     * @uses ServiceRequestOfRequestDef::setAttachment()
     */
    public function __construct($pageIndex = null, $pageSize = null, Token $token = null, RequestDef $value = null, $attachment = null)
    {
        $this
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize)
            ->setToken($token)
            ->setValue($value)
            ->setAttachment($attachment);
    }

    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }

    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return ServiceRequestOfRequestDef
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }

    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }

    /**
     * Set PageSize value
     * @param int $pageSize
     * @return ServiceRequestOfRequestDef
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }

    /**
     * Get Token value
     * @return Token|null
     */
    public function getToken()
    {
        return $this->Token;
    }

    /**
     * Set Token value
     * @param Token $token
     * @return ServiceRequestOfRequestDef
     */
    public function setToken(Token $token = null)
    {
        $this->Token = $token;
        return $this;
    }

    /**
     * Get Value value
     * @return RequestDef|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param RequestDef $value
     * @return ServiceRequestOfRequestDef
     */
    public function setValue(RequestDef $value = null)
    {
        $this->Value = $value;
        return $this;
    }

    /**
     * Get Attachment value
     * @return string|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }

    /**
     * Set Attachment value
     * @param string $attachment
     * @return ServiceRequestOfRequestDef
     */
    public function setAttachment($attachment = null)
    {
        // validation for constraint: string
        if (!is_null($attachment) && !is_string($attachment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachment, true), gettype($attachment)), __LINE__);
        }
        $this->Attachment = $attachment;
        return $this;
    }
}
