<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\ArrayType\ArrayOfTransformType;
use InvalidArgumentException;

/**
 * This class stands for ReferenceType StructType
 * @subpackage Structs
 */
class ReferenceType extends TextType
{
    /**
     * The Transforms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfTransformType
     */
    public $Transforms;
    /**
     * The DigestMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DigestMethodType
     */
    public $DigestMethod;
    /**
     * The DigestValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DigestValue;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The URI
     * @var string
     */
    public $URI;
    /**
     * The Id
     * @var string
     */
    public $Id;

    /**
     * Constructor method for ReferenceType
     * @param ArrayOfTransformType $transforms
     * @param DigestMethodType $digestMethod
     * @param string $digestValue
     * @param string $type
     * @param string $uRI
     * @param string $id
     * @uses ReferenceType::setTransforms()
     * @uses ReferenceType::setDigestMethod()
     * @uses ReferenceType::setDigestValue()
     * @uses ReferenceType::setType()
     * @uses ReferenceType::setURI()
     * @uses ReferenceType::setId()
     */
    public function __construct(ArrayOfTransformType $transforms = null, DigestMethodType $digestMethod = null, $digestValue = null, $type = null, $uRI = null, $id = null)
    {
        parent::__construct();
        $this
            ->setTransforms($transforms)
            ->setDigestMethod($digestMethod)
            ->setDigestValue($digestValue)
            ->setType($type)
            ->setURI($uRI)
            ->setId($id);
    }

    /**
     * Get Transforms value
     * @return ArrayOfTransformType|null
     */
    public function getTransforms()
    {
        return $this->Transforms;
    }

    /**
     * Set Transforms value
     * @param ArrayOfTransformType $transforms
     * @return ReferenceType
     */
    public function setTransforms(ArrayOfTransformType $transforms = null)
    {
        $this->Transforms = $transforms;
        return $this;
    }

    /**
     * Get DigestMethod value
     * @return DigestMethodType|null
     */
    public function getDigestMethod()
    {
        return $this->DigestMethod;
    }

    /**
     * Set DigestMethod value
     * @param DigestMethodType $digestMethod
     * @return ReferenceType
     */
    public function setDigestMethod(DigestMethodType $digestMethod = null)
    {
        $this->DigestMethod = $digestMethod;
        return $this;
    }

    /**
     * Get DigestValue value
     * @return string|null
     */
    public function getDigestValue()
    {
        return $this->DigestValue;
    }

    /**
     * Set DigestValue value
     * @param string $digestValue
     * @return ReferenceType
     */
    public function setDigestValue($digestValue = null)
    {
        // validation for constraint: string
        if (!is_null($digestValue) && !is_string($digestValue)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestValue, true), gettype($digestValue)), __LINE__);
        }
        $this->DigestValue = $digestValue;
        return $this;
    }

    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }

    /**
     * Set Type value
     * @param string $type
     * @return ReferenceType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }

    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }

    /**
     * Set URI value
     * @param string $uRI
     * @return ReferenceType
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }

    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param string $id
     * @return ReferenceType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
