<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageType StructType
 * @subpackage Structs
 */
class PackageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Quantity
     * @var QuantityType
     */
    public $Quantity;
    /**
     * The ReturnableMaterialIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ReturnableMaterialIndicator
     * @var ReturnableMaterialIndicatorType
     */
    public $ReturnableMaterialIndicator;
    /**
     * The PackageLevelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PackageLevelCode
     * @var PackageLevelCodeType
     */
    public $PackageLevelCode;
    /**
     * The PackagingTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PackagingTypeCode
     * @var PackagingTypeCodeType
     */
    public $PackagingTypeCode;
    /**
     * The PackingMaterial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:PackingMaterial
     * @var PackingMaterialType[]
     */
    public $PackingMaterial;
    /**
     * The ContainedPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var PackageType[]
     */
    public $ContainedPackage;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DimensionType[]
     */
    public $MeasurementDimension;

    /**
     * Constructor method for PackageType
     * @param IDType $iD
     * @param QuantityType $quantity
     * @param ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @param PackageLevelCodeType $packageLevelCode
     * @param PackagingTypeCodeType $packagingTypeCode
     * @param PackingMaterialType[] $packingMaterial
     * @param PackageType[] $containedPackage
     * @param GoodsItemType[] $goodsItem
     * @param DimensionType[] $measurementDimension
     * @uses PackageType::setID()
     * @uses PackageType::setQuantity()
     * @uses PackageType::setReturnableMaterialIndicator()
     * @uses PackageType::setPackageLevelCode()
     * @uses PackageType::setPackagingTypeCode()
     * @uses PackageType::setPackingMaterial()
     * @uses PackageType::setContainedPackage()
     * @uses PackageType::setGoodsItem()
     * @uses PackageType::setMeasurementDimension()
     */
    public function __construct(IDType $iD = null, QuantityType $quantity = null, ReturnableMaterialIndicatorType $returnableMaterialIndicator = null, PackageLevelCodeType $packageLevelCode = null, PackagingTypeCodeType $packagingTypeCode = null, array $packingMaterial = array(), array $containedPackage = array(), array $goodsItem = array(), array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setReturnableMaterialIndicator($returnableMaterialIndicator)
            ->setPackageLevelCode($packageLevelCode)
            ->setPackagingTypeCode($packagingTypeCode)
            ->setPackingMaterial($packingMaterial)
            ->setContainedPackage($containedPackage)
            ->setGoodsItem($goodsItem)
            ->setMeasurementDimension($measurementDimension);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return PackageType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get Quantity value
     * @return QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }

    /**
     * Set Quantity value
     * @param QuantityType $quantity
     * @return PackageType
     */
    public function setQuantity(QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }

    /**
     * Get ReturnableMaterialIndicator value
     * @return ReturnableMaterialIndicatorType|null
     */
    public function getReturnableMaterialIndicator()
    {
        return $this->ReturnableMaterialIndicator;
    }

    /**
     * Set ReturnableMaterialIndicator value
     * @param ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @return PackageType
     */
    public function setReturnableMaterialIndicator(ReturnableMaterialIndicatorType $returnableMaterialIndicator = null)
    {
        $this->ReturnableMaterialIndicator = $returnableMaterialIndicator;
        return $this;
    }

    /**
     * Get PackageLevelCode value
     * @return PackageLevelCodeType|null
     */
    public function getPackageLevelCode()
    {
        return $this->PackageLevelCode;
    }

    /**
     * Set PackageLevelCode value
     * @param PackageLevelCodeType $packageLevelCode
     * @return PackageType
     */
    public function setPackageLevelCode(PackageLevelCodeType $packageLevelCode = null)
    {
        $this->PackageLevelCode = $packageLevelCode;
        return $this;
    }

    /**
     * Get PackagingTypeCode value
     * @return PackagingTypeCodeType|null
     */
    public function getPackagingTypeCode()
    {
        return $this->PackagingTypeCode;
    }

    /**
     * Set PackagingTypeCode value
     * @param PackagingTypeCodeType $packagingTypeCode
     * @return PackageType
     */
    public function setPackagingTypeCode(PackagingTypeCodeType $packagingTypeCode = null)
    {
        $this->PackagingTypeCode = $packagingTypeCode;
        return $this;
    }

    /**
     * Get PackingMaterial value
     * @return PackingMaterialType[]|null
     */
    public function getPackingMaterial()
    {
        return $this->PackingMaterial;
    }

    /**
     * This method is responsible for validating the values passed to the setPackingMaterial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackingMaterial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackingMaterialForArrayConstraintsFromSetPackingMaterial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypePackingMaterialItem) {
            // validation for constraint: itemType
            if (!$packageTypePackingMaterialItem instanceof PackingMaterialType) {
                $invalidValues[] = is_object($packageTypePackingMaterialItem) ? get_class($packageTypePackingMaterialItem) : sprintf('%s(%s)', gettype($packageTypePackingMaterialItem), var_export($packageTypePackingMaterialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackingMaterial property can only contain items of type \Gek\UyumBahce\StructType\PackingMaterialType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set PackingMaterial value
     * @param PackingMaterialType[] $packingMaterial
     * @return PackageType
     * @throws InvalidArgumentException
     */
    public function setPackingMaterial(array $packingMaterial = array())
    {
        // validation for constraint: array
        if ('' !== ($packingMaterialArrayErrorMessage = self::validatePackingMaterialForArrayConstraintsFromSetPackingMaterial($packingMaterial))) {
            throw new InvalidArgumentException($packingMaterialArrayErrorMessage, __LINE__);
        }
        $this->PackingMaterial = $packingMaterial;
        return $this;
    }

    /**
     * Add item to PackingMaterial value
     * @param PackingMaterialType $item
     * @return PackageType
     * @throws InvalidArgumentException
     */
    public function addToPackingMaterial(PackingMaterialType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PackingMaterialType) {
            throw new InvalidArgumentException(sprintf('The PackingMaterial property can only contain items of type \Gek\UyumBahce\StructType\PackingMaterialType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackingMaterial[] = $item;
        return $this;
    }

    /**
     * Get ContainedPackage value
     * @return PackageType[]|null
     */
    public function getContainedPackage()
    {
        return $this->ContainedPackage;
    }

    /**
     * This method is responsible for validating the values passed to the setContainedPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContainedPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContainedPackageForArrayConstraintsFromSetContainedPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeContainedPackageItem) {
            // validation for constraint: itemType
            if (!$packageTypeContainedPackageItem instanceof PackageType) {
                $invalidValues[] = is_object($packageTypeContainedPackageItem) ? get_class($packageTypeContainedPackageItem) : sprintf('%s(%s)', gettype($packageTypeContainedPackageItem), var_export($packageTypeContainedPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContainedPackage property can only contain items of type \Gek\UyumBahce\StructType\PackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ContainedPackage value
     * @param PackageType[] $containedPackage
     * @return PackageType
     * @throws InvalidArgumentException
     */
    public function setContainedPackage(array $containedPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($containedPackageArrayErrorMessage = self::validateContainedPackageForArrayConstraintsFromSetContainedPackage($containedPackage))) {
            throw new InvalidArgumentException($containedPackageArrayErrorMessage, __LINE__);
        }
        $this->ContainedPackage = $containedPackage;
        return $this;
    }

    /**
     * Add item to ContainedPackage value
     * @param PackageType $item
     * @return PackageType
     * @throws InvalidArgumentException
     */
    public function addToContainedPackage(PackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PackageType) {
            throw new InvalidArgumentException(sprintf('The ContainedPackage property can only contain items of type \Gek\UyumBahce\StructType\PackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContainedPackage[] = $item;
        return $this;
    }

    /**
     * Get GoodsItem value
     * @return GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }

    /**
     * This method is responsible for validating the values passed to the setGoodsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsItemForArrayConstraintsFromSetGoodsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeGoodsItemItem) {
            // validation for constraint: itemType
            if (!$packageTypeGoodsItemItem instanceof GoodsItemType) {
                $invalidValues[] = is_object($packageTypeGoodsItemItem) ? get_class($packageTypeGoodsItemItem) : sprintf('%s(%s)', gettype($packageTypeGoodsItemItem), var_export($packageTypeGoodsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsItem property can only contain items of type \Gek\UyumBahce\StructType\GoodsItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set GoodsItem value
     * @param GoodsItemType[] $goodsItem
     * @return PackageType
     * @throws InvalidArgumentException
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsItemArrayErrorMessage = self::validateGoodsItemForArrayConstraintsFromSetGoodsItem($goodsItem))) {
            throw new InvalidArgumentException($goodsItemArrayErrorMessage, __LINE__);
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }

    /**
     * Add item to GoodsItem value
     * @param GoodsItemType $item
     * @return PackageType
     * @throws InvalidArgumentException
     */
    public function addToGoodsItem(GoodsItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof GoodsItemType) {
            throw new InvalidArgumentException(sprintf('The GoodsItem property can only contain items of type \Gek\UyumBahce\StructType\GoodsItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }

    /**
     * Get MeasurementDimension value
     * @return DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }

    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$packageTypeMeasurementDimensionItem instanceof DimensionType) {
                $invalidValues[] = is_object($packageTypeMeasurementDimensionItem) ? get_class($packageTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($packageTypeMeasurementDimensionItem), var_export($packageTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set MeasurementDimension value
     * @param DimensionType[] $measurementDimension
     * @return PackageType
     * @throws InvalidArgumentException
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }

    /**
     * Add item to MeasurementDimension value
     * @param DimensionType $item
     * @return PackageType
     * @throws InvalidArgumentException
     */
    public function addToMeasurementDimension(DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DimensionType) {
            throw new InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
