<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemInstanceType StructType
 * @subpackage Structs
 */
class ItemInstanceType extends AbstractStructBase
{
    /**
     * The ProductTraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ProductTraceID
     * @var ProductTraceIDType
     */
    public $ProductTraceID;
    /**
     * The ManufactureDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ManufactureDate
     * @var ManufactureDateType
     */
    public $ManufactureDate;
    /**
     * The ManufactureTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ManufactureTime
     * @var ManufactureTimeType
     */
    public $ManufactureTime;
    /**
     * The BestBeforeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:BestBeforeDate
     * @var BestBeforeDateType
     */
    public $BestBeforeDate;
    /**
     * The RegistrationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:RegistrationID
     * @var RegistrationIDType
     */
    public $RegistrationID;
    /**
     * The SerialID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:SerialID
     * @var SerialIDType
     */
    public $SerialID;
    /**
     * The AdditionalItemProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ItemPropertyType[]
     */
    public $AdditionalItemProperty;
    /**
     * The LotIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LotIdentificationType
     */
    public $LotIdentification;

    /**
     * Constructor method for ItemInstanceType
     * @param ProductTraceIDType $productTraceID
     * @param ManufactureDateType $manufactureDate
     * @param ManufactureTimeType $manufactureTime
     * @param BestBeforeDateType $bestBeforeDate
     * @param RegistrationIDType $registrationID
     * @param SerialIDType $serialID
     * @param ItemPropertyType[] $additionalItemProperty
     * @param LotIdentificationType $lotIdentification
     * @uses ItemInstanceType::setProductTraceID()
     * @uses ItemInstanceType::setManufactureDate()
     * @uses ItemInstanceType::setManufactureTime()
     * @uses ItemInstanceType::setBestBeforeDate()
     * @uses ItemInstanceType::setRegistrationID()
     * @uses ItemInstanceType::setSerialID()
     * @uses ItemInstanceType::setAdditionalItemProperty()
     * @uses ItemInstanceType::setLotIdentification()
     */
    public function __construct(ProductTraceIDType $productTraceID = null, ManufactureDateType $manufactureDate = null, ManufactureTimeType $manufactureTime = null, BestBeforeDateType $bestBeforeDate = null, RegistrationIDType $registrationID = null, SerialIDType $serialID = null, array $additionalItemProperty = array(), LotIdentificationType $lotIdentification = null)
    {
        $this
            ->setProductTraceID($productTraceID)
            ->setManufactureDate($manufactureDate)
            ->setManufactureTime($manufactureTime)
            ->setBestBeforeDate($bestBeforeDate)
            ->setRegistrationID($registrationID)
            ->setSerialID($serialID)
            ->setAdditionalItemProperty($additionalItemProperty)
            ->setLotIdentification($lotIdentification);
    }

    /**
     * Get ProductTraceID value
     * @return ProductTraceIDType|null
     */
    public function getProductTraceID()
    {
        return $this->ProductTraceID;
    }

    /**
     * Set ProductTraceID value
     * @param ProductTraceIDType $productTraceID
     * @return ItemInstanceType
     */
    public function setProductTraceID(ProductTraceIDType $productTraceID = null)
    {
        $this->ProductTraceID = $productTraceID;
        return $this;
    }

    /**
     * Get ManufactureDate value
     * @return ManufactureDateType|null
     */
    public function getManufactureDate()
    {
        return $this->ManufactureDate;
    }

    /**
     * Set ManufactureDate value
     * @param ManufactureDateType $manufactureDate
     * @return ItemInstanceType
     */
    public function setManufactureDate(ManufactureDateType $manufactureDate = null)
    {
        $this->ManufactureDate = $manufactureDate;
        return $this;
    }

    /**
     * Get ManufactureTime value
     * @return ManufactureTimeType|null
     */
    public function getManufactureTime()
    {
        return $this->ManufactureTime;
    }

    /**
     * Set ManufactureTime value
     * @param ManufactureTimeType $manufactureTime
     * @return ItemInstanceType
     */
    public function setManufactureTime(ManufactureTimeType $manufactureTime = null)
    {
        $this->ManufactureTime = $manufactureTime;
        return $this;
    }

    /**
     * Get BestBeforeDate value
     * @return BestBeforeDateType|null
     */
    public function getBestBeforeDate()
    {
        return $this->BestBeforeDate;
    }

    /**
     * Set BestBeforeDate value
     * @param BestBeforeDateType $bestBeforeDate
     * @return ItemInstanceType
     */
    public function setBestBeforeDate(BestBeforeDateType $bestBeforeDate = null)
    {
        $this->BestBeforeDate = $bestBeforeDate;
        return $this;
    }

    /**
     * Get RegistrationID value
     * @return RegistrationIDType|null
     */
    public function getRegistrationID()
    {
        return $this->RegistrationID;
    }

    /**
     * Set RegistrationID value
     * @param RegistrationIDType $registrationID
     * @return ItemInstanceType
     */
    public function setRegistrationID(RegistrationIDType $registrationID = null)
    {
        $this->RegistrationID = $registrationID;
        return $this;
    }

    /**
     * Get SerialID value
     * @return SerialIDType|null
     */
    public function getSerialID()
    {
        return $this->SerialID;
    }

    /**
     * Set SerialID value
     * @param SerialIDType $serialID
     * @return ItemInstanceType
     */
    public function setSerialID(SerialIDType $serialID = null)
    {
        $this->SerialID = $serialID;
        return $this;
    }

    /**
     * Get AdditionalItemProperty value
     * @return ItemPropertyType[]|null
     */
    public function getAdditionalItemProperty()
    {
        return $this->AdditionalItemProperty;
    }

    /**
     * This method is responsible for validating the values passed to the setAdditionalItemProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalItemProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalItemPropertyForArrayConstraintsFromSetAdditionalItemProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemInstanceTypeAdditionalItemPropertyItem) {
            // validation for constraint: itemType
            if (!$itemInstanceTypeAdditionalItemPropertyItem instanceof ItemPropertyType) {
                $invalidValues[] = is_object($itemInstanceTypeAdditionalItemPropertyItem) ? get_class($itemInstanceTypeAdditionalItemPropertyItem) : sprintf('%s(%s)', gettype($itemInstanceTypeAdditionalItemPropertyItem), var_export($itemInstanceTypeAdditionalItemPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalItemProperty property can only contain items of type \Gek\UyumBahce\StructType\ItemPropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set AdditionalItemProperty value
     * @param ItemPropertyType[] $additionalItemProperty
     * @return ItemInstanceType
     * @throws InvalidArgumentException
     */
    public function setAdditionalItemProperty(array $additionalItemProperty = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalItemPropertyArrayErrorMessage = self::validateAdditionalItemPropertyForArrayConstraintsFromSetAdditionalItemProperty($additionalItemProperty))) {
            throw new InvalidArgumentException($additionalItemPropertyArrayErrorMessage, __LINE__);
        }
        $this->AdditionalItemProperty = $additionalItemProperty;
        return $this;
    }

    /**
     * Add item to AdditionalItemProperty value
     * @param ItemPropertyType $item
     * @return ItemInstanceType
     * @throws InvalidArgumentException
     */
    public function addToAdditionalItemProperty(ItemPropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ItemPropertyType) {
            throw new InvalidArgumentException(sprintf('The AdditionalItemProperty property can only contain items of type \Gek\UyumBahce\StructType\ItemPropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalItemProperty[] = $item;
        return $this;
    }

    /**
     * Get LotIdentification value
     * @return LotIdentificationType|null
     */
    public function getLotIdentification()
    {
        return $this->LotIdentification;
    }

    /**
     * Set LotIdentification value
     * @param LotIdentificationType $lotIdentification
     * @return ItemInstanceType
     */
    public function setLotIdentification(LotIdentificationType $lotIdentification = null)
    {
        $this->LotIdentification = $lotIdentification;
        return $this;
    }
}
