<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\EnumType\InvoiceScenarioChoosen;
use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceInfo StructType
 * @subpackage Structs
 */
class InvoiceInfo extends AbstractStructBase
{
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Scenario;
    /**
     * The CreateDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDateUtc;
    /**
     * The Invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var InvoiceType
     */
    public $Invoice;
    /**
     * The TargetCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CustomerInfo
     */
    public $TargetCustomer;
    /**
     * The EArchiveInvoiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EArchiveInvoiceInformation
     */
    public $EArchiveInvoiceInfo;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var NotificationInformation
     */
    public $Notification;
    /**
     * The ExtraInformation
     * @var string
     */
    public $ExtraInformation;
    /**
     * The LocalDocumentId
     * @var string
     */
    public $LocalDocumentId;

    /**
     * Constructor method for InvoiceInfo
     * @param string $scenario
     * @param string $createDateUtc
     * @param InvoiceType $invoice
     * @param CustomerInfo $targetCustomer
     * @param EArchiveInvoiceInformation $eArchiveInvoiceInfo
     * @param NotificationInformation $notification
     * @param string $extraInformation
     * @param string $localDocumentId
     * @uses InvoiceInfo::setScenario()
     * @uses InvoiceInfo::setCreateDateUtc()
     * @uses InvoiceInfo::setInvoice()
     * @uses InvoiceInfo::setTargetCustomer()
     * @uses InvoiceInfo::setEArchiveInvoiceInfo()
     * @uses InvoiceInfo::setNotification()
     * @uses InvoiceInfo::setExtraInformation()
     * @uses InvoiceInfo::setLocalDocumentId()
     */
    public function __construct($scenario = null, $createDateUtc = null, InvoiceType $invoice = null, CustomerInfo $targetCustomer = null, EArchiveInvoiceInformation $eArchiveInvoiceInfo = null, NotificationInformation $notification = null, $extraInformation = null, $localDocumentId = null)
    {
        $this
            ->setScenario($scenario)
            ->setCreateDateUtc($createDateUtc)
            ->setInvoice($invoice)
            ->setTargetCustomer($targetCustomer)
            ->setEArchiveInvoiceInfo($eArchiveInvoiceInfo)
            ->setNotification($notification)
            ->setExtraInformation($extraInformation)
            ->setLocalDocumentId($localDocumentId);
    }

    /**
     * Get Scenario value
     * @return string
     */
    public function getScenario()
    {
        return $this->Scenario;
    }

    /**
     * Set Scenario value
     * @param string $scenario
     * @return InvoiceInfo
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\InvoiceScenarioChoosen::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\InvoiceScenarioChoosen::valueIsValid()
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: enumeration
        if (!InvoiceScenarioChoosen::valueIsValid($scenario)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\InvoiceScenarioChoosen', is_array($scenario) ? implode(', ', $scenario) : var_export($scenario, true), implode(', ', InvoiceScenarioChoosen::getValidValues())), __LINE__);
        }
        $this->Scenario = $scenario;
        return $this;
    }

    /**
     * Get CreateDateUtc value
     * @return string
     */
    public function getCreateDateUtc()
    {
        return $this->CreateDateUtc;
    }

    /**
     * Set CreateDateUtc value
     * @param string|GekDateTime $createDateUtc
     * @return InvoiceInfo
     */
    public function setCreateDateUtc($createDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($createDateUtc) && !is_string($createDateUtc) && !($createDateUtc instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateUtc, true), gettype($createDateUtc)), __LINE__);
        }
        if ($createDateUtc instanceof GekDateTime) {
            $createDateUtc = $createDateUtc->toServiceString();
        }
        $this->CreateDateUtc = $createDateUtc;
        return $this;
    }

    /**
     * Get Invoice value
     * @return InvoiceType|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }

    /**
     * Set Invoice value
     * @param InvoiceType $invoice
     * @return InvoiceInfo
     */
    public function setInvoice(InvoiceType $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }

    /**
     * Get TargetCustomer value
     * @return CustomerInfo|null
     */
    public function getTargetCustomer()
    {
        return $this->TargetCustomer;
    }

    /**
     * Set TargetCustomer value
     * @param CustomerInfo $targetCustomer
     * @return InvoiceInfo
     */
    public function setTargetCustomer(CustomerInfo $targetCustomer = null)
    {
        $this->TargetCustomer = $targetCustomer;
        return $this;
    }

    /**
     * Get EArchiveInvoiceInfo value
     * @return EArchiveInvoiceInformation|null
     */
    public function getEArchiveInvoiceInfo()
    {
        return $this->EArchiveInvoiceInfo;
    }

    /**
     * Set EArchiveInvoiceInfo value
     * @param EArchiveInvoiceInformation $eArchiveInvoiceInfo
     * @return InvoiceInfo
     */
    public function setEArchiveInvoiceInfo(EArchiveInvoiceInformation $eArchiveInvoiceInfo = null)
    {
        $this->EArchiveInvoiceInfo = $eArchiveInvoiceInfo;
        return $this;
    }

    /**
     * Get Notification value
     * @return NotificationInformation|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }

    /**
     * Set Notification value
     * @param NotificationInformation $notification
     * @return InvoiceInfo
     */
    public function setNotification(NotificationInformation $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }

    /**
     * Get ExtraInformation value
     * @return string|null
     */
    public function getExtraInformation()
    {
        return $this->ExtraInformation;
    }

    /**
     * Set ExtraInformation value
     * @param string $extraInformation
     * @return InvoiceInfo
     */
    public function setExtraInformation($extraInformation = null)
    {
        // validation for constraint: string
        if (!is_null($extraInformation) && !is_string($extraInformation)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInformation, true), gettype($extraInformation)), __LINE__);
        }
        $this->ExtraInformation = $extraInformation;
        return $this;
    }

    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }

    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return InvoiceInfo
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($localDocumentId) && !is_string($localDocumentId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDocumentId, true), gettype($localDocumentId)), __LINE__);
        }
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }
}
