<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\EnumType\DeclarationTempType;
use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;

/**
 * This class stands for InvoiceDetailDef StructType
 * @subpackage Structs
 */
class InvoiceDetailDef extends TransactionalDetailFields
{
    /**
     * The UseExpBudget
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UseExpBudget;
    /**
     * The ReasonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ReasonId;
    /**
     * The OtherInvoiceDeclaration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OtherInvoiceDeclaration;
    /**
     * The PogStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PogStartDate;
    /**
     * The PogEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PogEndDate;
    /**
     * The ItemNameManuel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemNameManuel;

    /**
     * Constructor method for InvoiceDetailDef
     * @param bool $useExpBudget
     * @param int $reasonId
     * @param string $otherInvoiceDeclaration
     * @param string|GekDateTime $pogStartDate
     * @param string|GekDateTime $pogEndDate
     * @param string $itemNameManuel
     * @uses InvoiceDetailDef::setUseExpBudget()
     * @uses InvoiceDetailDef::setReasonId()
     * @uses InvoiceDetailDef::setOtherInvoiceDeclaration()
     * @uses InvoiceDetailDef::setPogStartDate()
     * @uses InvoiceDetailDef::setPogEndDate()
     * @uses InvoiceDetailDef::setItemNameManuel()
     */
    public function __construct($useExpBudget = null, $reasonId = null, $otherInvoiceDeclaration = null, $pogStartDate = null, $pogEndDate = null, $itemNameManuel = null)
    {
        parent::__construct();
        $this
            ->setUseExpBudget($useExpBudget)
            ->setReasonId($reasonId)
            ->setOtherInvoiceDeclaration($otherInvoiceDeclaration)
            ->setPogStartDate($pogStartDate)
            ->setPogEndDate($pogEndDate)
            ->setItemNameManuel($itemNameManuel);
    }

    /**
     * Get UseExpBudget value
     * @return bool
     */
    public function getUseExpBudget()
    {
        return $this->UseExpBudget;
    }

    /**
     * Set UseExpBudget value
     * @param bool $useExpBudget
     * @return InvoiceDetailDef
     */
    public function setUseExpBudget($useExpBudget = null)
    {
        // validation for constraint: boolean
        if (!is_null($useExpBudget) && !is_bool($useExpBudget)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useExpBudget, true), gettype($useExpBudget)), __LINE__);
        }
        $this->UseExpBudget = $useExpBudget;
        return $this;
    }

    /**
     * Get ReasonId value
     * @return int
     */
    public function getReasonId()
    {
        return $this->ReasonId;
    }

    /**
     * Set ReasonId value
     * @param int $reasonId
     * @return InvoiceDetailDef
     */
    public function setReasonId($reasonId = null)
    {
        // validation for constraint: int
        if (!is_null($reasonId) && !(is_int($reasonId) || ctype_digit($reasonId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reasonId, true), gettype($reasonId)), __LINE__);
        }
        $this->ReasonId = $reasonId;
        return $this;
    }

    /**
     * Get OtherInvoiceDeclaration value
     * @return string
     */
    public function getOtherInvoiceDeclaration()
    {
        return $this->OtherInvoiceDeclaration;
    }

    /**
     * Set OtherInvoiceDeclaration value
     * @param string $otherInvoiceDeclaration
     * @return InvoiceDetailDef
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\DeclarationTempType::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\DeclarationTempType::valueIsValid()
     */
    public function setOtherInvoiceDeclaration($otherInvoiceDeclaration = null)
    {
        // validation for constraint: enumeration
        if (!DeclarationTempType::valueIsValid($otherInvoiceDeclaration)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\DeclarationTempType', is_array($otherInvoiceDeclaration) ? implode(', ', $otherInvoiceDeclaration) : var_export($otherInvoiceDeclaration, true), implode(', ', DeclarationTempType::getValidValues())), __LINE__);
        }
        $this->OtherInvoiceDeclaration = $otherInvoiceDeclaration;
        return $this;
    }

    /**
     * Get PogStartDate value
     * @return string
     */
    public function getPogStartDate()
    {
        return $this->PogStartDate;
    }

    /**
     * Set PogStartDate value
     * @param string|GekDateTime $pogStartDate
     * @return InvoiceDetailDef
     */
    public function setPogStartDate($pogStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($pogStartDate) && !is_string($pogStartDate) && !($pogStartDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pogStartDate, true), gettype($pogStartDate)), __LINE__);
        }
        if ($pogStartDate instanceof GekDateTime) {
            $pogStartDate = $pogStartDate->toServiceString();
        }
        $this->PogStartDate = $pogStartDate;
        return $this;
    }

    /**
     * Get PogEndDate value
     * @return string
     */
    public function getPogEndDate()
    {
        return $this->PogEndDate;
    }

    /**
     * Set PogEndDate value
     * @param string|GekDateTime $pogEndDate
     * @return InvoiceDetailDef
     */
    public function setPogEndDate($pogEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($pogEndDate) && !is_string($pogEndDate) && !($pogEndDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pogEndDate, true), gettype($pogEndDate)), __LINE__);
        }
        if ($pogEndDate instanceof GekDateTime) {
            $pogEndDate = $pogEndDate->toServiceString();
        }
        $this->PogEndDate = $pogEndDate;
        return $this;
    }

    /**
     * Get ItemNameManuel value
     * @return string|null
     */
    public function getItemNameManuel()
    {
        return $this->ItemNameManuel;
    }

    /**
     * Set ItemNameManuel value
     * @param string $itemNameManuel
     * @return InvoiceDetailDef
     */
    public function setItemNameManuel($itemNameManuel = null)
    {
        // validation for constraint: string
        if (!is_null($itemNameManuel) && !is_string($itemNameManuel)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemNameManuel, true), gettype($itemNameManuel)), __LINE__);
        }
        $this->ItemNameManuel = $itemNameManuel;
        return $this;
    }
}
