<?php

namespace Gek\UyumBahce\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomsDeclarationType StructType
 * @subpackage Structs
 */
class CustomsDeclarationType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The IssuerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PartyType
     */
    public $IssuerParty;

    /**
     * Constructor method for CustomsDeclarationType
     * @param IDType $iD
     * @param PartyType $issuerParty
     * @uses CustomsDeclarationType::setID()
     * @uses CustomsDeclarationType::setIssuerParty()
     */
    public function __construct(IDType $iD = null, PartyType $issuerParty = null)
    {
        $this
            ->setID($iD)
            ->setIssuerParty($issuerParty);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return CustomsDeclarationType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get IssuerParty value
     * @return PartyType|null
     */
    public function getIssuerParty()
    {
        return $this->IssuerParty;
    }

    /**
     * Set IssuerParty value
     * @param PartyType $issuerParty
     * @return CustomsDeclarationType
     */
    public function setIssuerParty(PartyType $issuerParty = null)
    {
        $this->IssuerParty = $issuerParty;
        return $this;
    }
}
