<?php

namespace Gek\UyumBahce\EnumType;

use WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for InvoiceStatus EnumType
 * @subpackage Enumerations
 */
class InvoiceStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'İrsaliye'
     * @return string 'İrsaliye'
     */
    const VALUE_IRSALIYE = 'İrsaliye';
    /**
     * Constant for value 'KısmiFatura'
     * @return string 'KısmiFatura'
     */
    const VALUE_KISMI_FATURA = 'KısmiFatura';
    /**
     * Constant for value 'Fatura'
     * @return string 'Fatura'
     */
    const VALUE_FATURA = 'Fatura';
    /**
     * Constant for value 'Dosyalandı'
     * @return string 'Dosyalandı'
     */
    const VALUE_DOSYALANDI = 'Dosyalandı';
    /**
     * Constant for value 'FaturaEdilmez'
     * @return string 'FaturaEdilmez'
     */
    const VALUE_FATURA_EDILMEZ = 'FaturaEdilmez';

    /**
     * Return allowed values
     * @return string[]
     * @uses self::VALUE_KISMI_FATURA
     * @uses self::VALUE_FATURA
     * @uses self::VALUE_DOSYALANDI
     * @uses self::VALUE_FATURA_EDILMEZ
     * @uses self::VALUE_IRSALIYE
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IRSALIYE,
            self::VALUE_KISMI_FATURA,
            self::VALUE_FATURA,
            self::VALUE_DOSYALANDI,
            self::VALUE_FATURA_EDILMEZ,
        );
    }
}
