<?php

namespace Gek\UyumBahce\ArrayType;

use Gek\UyumBahce\StructType\OrderDetailBarcode;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderDetailBarcode ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderDetailBarcode extends AbstractStructArrayBase
{
    /**
     * The OrderDetailBarcode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var OrderDetailBarcode[]
     */
    public $OrderDetailBarcode;

    /**
     * Constructor method for ArrayOfOrderDetailBarcode
     * @param OrderDetailBarcode[] $orderDetailBarcode
     * @uses ArrayOfOrderDetailBarcode::setOrderDetailBarcode()
     */
    public function __construct(array $orderDetailBarcode = array())
    {
        $this
            ->setOrderDetailBarcode($orderDetailBarcode);
    }

    /**
     * Get OrderDetailBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return OrderDetailBarcode[]|null
     */
    public function getOrderDetailBarcode()
    {
        return isset($this->OrderDetailBarcode) ? $this->OrderDetailBarcode : null;
    }

    /**
     * This method is responsible for validating the values passed to the setOrderDetailBarcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderDetailBarcode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderDetailBarcodeForArrayConstraintsFromSetOrderDetailBarcode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderDetailBarcodeOrderDetailBarcodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderDetailBarcodeOrderDetailBarcodeItem instanceof OrderDetailBarcode) {
                $invalidValues[] = is_object($arrayOfOrderDetailBarcodeOrderDetailBarcodeItem) ? get_class($arrayOfOrderDetailBarcodeOrderDetailBarcodeItem) : sprintf('%s(%s)', gettype($arrayOfOrderDetailBarcodeOrderDetailBarcodeItem), var_export($arrayOfOrderDetailBarcodeOrderDetailBarcodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderDetailBarcode property can only contain items of type \Gek\UyumBahce\StructType\OrderDetailBarcode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set OrderDetailBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param OrderDetailBarcode[] $orderDetailBarcode
     * @return ArrayOfOrderDetailBarcode
     * @throws InvalidArgumentException
     */
    public function setOrderDetailBarcode(array $orderDetailBarcode = array())
    {
        // validation for constraint: array
        if ('' !== ($orderDetailBarcodeArrayErrorMessage = self::validateOrderDetailBarcodeForArrayConstraintsFromSetOrderDetailBarcode($orderDetailBarcode))) {
            throw new InvalidArgumentException($orderDetailBarcodeArrayErrorMessage, __LINE__);
        }
        if (is_null($orderDetailBarcode) || (is_array($orderDetailBarcode) && empty($orderDetailBarcode))) {
            unset($this->OrderDetailBarcode);
        } else {
            $this->OrderDetailBarcode = $orderDetailBarcode;
        }
        return $this;
    }

    /**
     * Add item to OrderDetailBarcode value
     * @param OrderDetailBarcode $item
     * @return ArrayOfOrderDetailBarcode
     * @throws InvalidArgumentException
     */
    public function addToOrderDetailBarcode(OrderDetailBarcode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof OrderDetailBarcode) {
            throw new InvalidArgumentException(sprintf('The OrderDetailBarcode property can only contain items of type \Gek\UyumBahce\StructType\OrderDetailBarcode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderDetailBarcode[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return OrderDetailBarcode|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return OrderDetailBarcode|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return OrderDetailBarcode|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return OrderDetailBarcode|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return OrderDetailBarcode|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string OrderDetailBarcode
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'OrderDetailBarcode';
    }
}
