<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\EnumType\DiscTypes;
use Gek\UyumBahce\EnumType\VatStatus;
use InvalidArgumentException;

/**
 * This class stands for TransactionalDetailFields StructType
 * @subpackage Structs
 */
class TransactionalDetailFields extends DetailFields
{
    /**
     * The ColorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ColorId;
    /**
     * The PackageTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PackageTypeId;
    /**
     * The LineType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string|null
     */
    public $LineType;
    /**
     * The DcardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DcardId;
    /**
     * The UnitId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $UnitId;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The QtyPrm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $QtyPrm;
    /**
     * The QtyFreePrm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $QtyFreePrm;
    /**
     * The QtyFreeSec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $QtyFreeSec;
    /**
     * The DueDay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DueDay;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CampaignId;
    /**
     * The UnitPriceTra
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $UnitPriceTra;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $UnitPrice;
    /**
     * The VatStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $VatStatus;
    /**
     * The VatId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $VatId;
    /**
     * The VatRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $VatRate;
    /**
     * The AmtVat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtVat;
    /**
     * The AbtActId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AbtActId;
    /**
     * The AbtBudgetId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AbtBudgetId;
    /**
     * The PriceListId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PriceListId;
    /**
     * The PriceListDId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PriceListDId;
    /**
     * The WhouseId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WhouseId;
    /**
     * The AbtBudgetD2Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AbtBudgetD2Id;
    /**
     * The Disc1Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Disc1Id;
    /**
     * The Disc1Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Disc1Rate;
    /**
     * The AmtDisc1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtDisc1;
    /**
     * The AmtDisc1Tra
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtDisc1Tra;
    /**
     * The Disc2Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Disc2Id;
    /**
     * The Disc2Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Disc2Rate;
    /**
     * The AmtDisc2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtDisc2;
    /**
     * The AmtDisc2Tra
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtDisc2Tra;
    /**
     * The Disc3Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Disc3Id;
    /**
     * The Disc3Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Disc3Rate;
    /**
     * The AmtDisc3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtDisc3;
    /**
     * The AmtDisc3Tra
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtDisc3Tra;
    /**
     * The AmtDisc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtDisc;
    /**
     * The AmtWithDisc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtWithDisc;
    /**
     * The Amt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Amt;
    /**
     * The AmtTra
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtTra;
    /**
     * The FormContractMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FormContractMId;
    /**
     * The ItemAttribute1Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ItemAttribute1Id;
    /**
     * The ItemAttribute2Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ItemAttribute2Id;
    /**
     * The ItemAttribute3Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ItemAttribute3Id;
    /**
     * The ItemGnlAttribute1Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ItemGnlAttribute1Id;
    /**
     * The ItemGnlAttribute2Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ItemGnlAttribute2Id;
    /**
     * The ItemGnlAttribute3Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ItemGnlAttribute3Id;
    /**
     * The DiscCalcType1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DiscCalcType1;
    /**
     * The DiscCalcType2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DiscCalcType2;
    /**
     * The DiscCalcType3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DiscCalcType3;
    /**
     * The LotId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $LotId;
    /**
     * The QualityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $QualityId;
    /**
     * The SalesPersonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SalesPersonId;
    /**
     * The IsItemAttribute
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsItemAttribute;
    /**
     * The ColorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ColorCode;
    /**
     * The PackageTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackageTypeCode;
    /**
     * The DcardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DcardCode;
    /**
     * The UnitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitCode;
    /**
     * The VatCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VatCode;
    /**
     * The AbtActCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AbtActCode;
    /**
     * The AbtBudgetCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AbtBudgetCode;
    /**
     * The OTVCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OTVCode;
    /**
     * The OIVCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OIVCode;
    /**
     * The VatDiscCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VatDiscCode;
    /**
     * The PriceListCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceListCode;
    /**
     * The WhouseCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WhouseCode;
    /**
     * The Disc1Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Disc1Code;
    /**
     * The Disc2Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Disc2Code;
    /**
     * The Disc3Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Disc3Code;
    /**
     * The FormContractCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormContractCode;
    /**
     * The ItemAttributeCode1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemAttributeCode1;
    /**
     * The ItemAttributeCode2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemAttributeCode2;
    /**
     * The ItemAttributeCode3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemAttributeCode3;
    /**
     * The ItemGnlAttributeCode1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemGnlAttributeCode1;
    /**
     * The ItemGnlAttributeCode2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemGnlAttributeCode2;
    /**
     * The ItemGnlAttributeCode3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemGnlAttributeCode3;
    /**
     * The ReferanceDocNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferanceDocNo;
    /**
     * The LotCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LotCode;
    /**
     * The QualityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QualityCode;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * The ItemNameManual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemNameManual;

    /**
     * Constructor method for TransactionalDetailFields
     * @param int $colorId
     * @param int $packageTypeId
     * @param string|null $lineType
     * @param int $dcardId
     * @param int $unitId
     * @param float $qty
     * @param float $qtyPrm
     * @param float $qtyFreePrm
     * @param float $qtyFreeSec
     * @param int $dueDay
     * @param int $campaignId
     * @param float $unitPriceTra
     * @param float $unitPrice
     * @param string $vatStatus
     * @param int $vatId
     * @param float $vatRate
     * @param float $amtVat
     * @param int $abtActId
     * @param int $abtBudgetId
     * @param int $priceListId
     * @param int $priceListDId
     * @param int $whouseId
     * @param int $abtBudgetD2Id
     * @param int $disc1Id
     * @param float $disc1Rate
     * @param float $amtDisc1
     * @param float $amtDisc1Tra
     * @param int $disc2Id
     * @param float $disc2Rate
     * @param float $amtDisc2
     * @param float $amtDisc2Tra
     * @param int $disc3Id
     * @param float $disc3Rate
     * @param float $amtDisc3
     * @param float $amtDisc3Tra
     * @param float $amtDisc
     * @param float $amtWithDisc
     * @param float $amt
     * @param float $amtTra
     * @param int $formContractMId
     * @param int $itemAttribute1Id
     * @param int $itemAttribute2Id
     * @param int $itemAttribute3Id
     * @param int $itemGnlAttribute1Id
     * @param int $itemGnlAttribute2Id
     * @param int $itemGnlAttribute3Id
     * @param string $discCalcType1
     * @param string $discCalcType2
     * @param string $discCalcType3
     * @param int $lotId
     * @param int $qualityId
     * @param int $salesPersonId
     * @param bool $isItemAttribute
     * @param string $colorCode
     * @param string $packageTypeCode
     * @param string $dcardCode
     * @param string $unitCode
     * @param string $vatCode
     * @param string $abtActCode
     * @param string $abtBudgetCode
     * @param string $oTVCode
     * @param string $oIVCode
     * @param string $vatDiscCode
     * @param string $priceListCode
     * @param string $whouseCode
     * @param string $disc1Code
     * @param string $disc2Code
     * @param string $disc3Code
     * @param string $formContractCode
     * @param string $itemAttributeCode1
     * @param string $itemAttributeCode2
     * @param string $itemAttributeCode3
     * @param string $itemGnlAttributeCode1
     * @param string $itemGnlAttributeCode2
     * @param string $itemGnlAttributeCode3
     * @param string $referanceDocNo
     * @param string $lotCode
     * @param string $qualityCode
     * @param string $barcode
     * @param string $itemNameManual
     * @uses TransactionalDetailFields::setColorId()
     * @uses TransactionalDetailFields::setPackageTypeId()
     * @uses TransactionalDetailFields::setLineType()
     * @uses TransactionalDetailFields::setDcardId()
     * @uses TransactionalDetailFields::setUnitId()
     * @uses TransactionalDetailFields::setQty()
     * @uses TransactionalDetailFields::setQtyPrm()
     * @uses TransactionalDetailFields::setQtyFreePrm()
     * @uses TransactionalDetailFields::setQtyFreeSec()
     * @uses TransactionalDetailFields::setDueDay()
     * @uses TransactionalDetailFields::setCampaignId()
     * @uses TransactionalDetailFields::setUnitPriceTra()
     * @uses TransactionalDetailFields::setUnitPrice()
     * @uses TransactionalDetailFields::setVatStatus()
     * @uses TransactionalDetailFields::setVatId()
     * @uses TransactionalDetailFields::setVatRate()
     * @uses TransactionalDetailFields::setAmtVat()
     * @uses TransactionalDetailFields::setAbtActId()
     * @uses TransactionalDetailFields::setAbtBudgetId()
     * @uses TransactionalDetailFields::setPriceListId()
     * @uses TransactionalDetailFields::setPriceListDId()
     * @uses TransactionalDetailFields::setWhouseId()
     * @uses TransactionalDetailFields::setAbtBudgetD2Id()
     * @uses TransactionalDetailFields::setDisc1Id()
     * @uses TransactionalDetailFields::setDisc1Rate()
     * @uses TransactionalDetailFields::setAmtDisc1()
     * @uses TransactionalDetailFields::setAmtDisc1Tra()
     * @uses TransactionalDetailFields::setDisc2Id()
     * @uses TransactionalDetailFields::setDisc2Rate()
     * @uses TransactionalDetailFields::setAmtDisc2()
     * @uses TransactionalDetailFields::setAmtDisc2Tra()
     * @uses TransactionalDetailFields::setDisc3Id()
     * @uses TransactionalDetailFields::setDisc3Rate()
     * @uses TransactionalDetailFields::setAmtDisc3()
     * @uses TransactionalDetailFields::setAmtDisc3Tra()
     * @uses TransactionalDetailFields::setAmtDisc()
     * @uses TransactionalDetailFields::setAmtWithDisc()
     * @uses TransactionalDetailFields::setAmt()
     * @uses TransactionalDetailFields::setAmtTra()
     * @uses TransactionalDetailFields::setFormContractMId()
     * @uses TransactionalDetailFields::setItemAttribute1Id()
     * @uses TransactionalDetailFields::setItemAttribute2Id()
     * @uses TransactionalDetailFields::setItemAttribute3Id()
     * @uses TransactionalDetailFields::setItemGnlAttribute1Id()
     * @uses TransactionalDetailFields::setItemGnlAttribute2Id()
     * @uses TransactionalDetailFields::setItemGnlAttribute3Id()
     * @uses TransactionalDetailFields::setDiscCalcType1()
     * @uses TransactionalDetailFields::setDiscCalcType2()
     * @uses TransactionalDetailFields::setDiscCalcType3()
     * @uses TransactionalDetailFields::setLotId()
     * @uses TransactionalDetailFields::setQualityId()
     * @uses TransactionalDetailFields::setSalesPersonId()
     * @uses TransactionalDetailFields::setIsItemAttribute()
     * @uses TransactionalDetailFields::setColorCode()
     * @uses TransactionalDetailFields::setPackageTypeCode()
     * @uses TransactionalDetailFields::setDcardCode()
     * @uses TransactionalDetailFields::setUnitCode()
     * @uses TransactionalDetailFields::setVatCode()
     * @uses TransactionalDetailFields::setAbtActCode()
     * @uses TransactionalDetailFields::setAbtBudgetCode()
     * @uses TransactionalDetailFields::setOTVCode()
     * @uses TransactionalDetailFields::setOIVCode()
     * @uses TransactionalDetailFields::setVatDiscCode()
     * @uses TransactionalDetailFields::setPriceListCode()
     * @uses TransactionalDetailFields::setWhouseCode()
     * @uses TransactionalDetailFields::setDisc1Code()
     * @uses TransactionalDetailFields::setDisc2Code()
     * @uses TransactionalDetailFields::setDisc3Code()
     * @uses TransactionalDetailFields::setFormContractCode()
     * @uses TransactionalDetailFields::setItemAttributeCode1()
     * @uses TransactionalDetailFields::setItemAttributeCode2()
     * @uses TransactionalDetailFields::setItemAttributeCode3()
     * @uses TransactionalDetailFields::setItemGnlAttributeCode1()
     * @uses TransactionalDetailFields::setItemGnlAttributeCode2()
     * @uses TransactionalDetailFields::setItemGnlAttributeCode3()
     * @uses TransactionalDetailFields::setReferanceDocNo()
     * @uses TransactionalDetailFields::setLotCode()
     * @uses TransactionalDetailFields::setQualityCode()
     * @uses TransactionalDetailFields::setBarcode()
     * @uses TransactionalDetailFields::setItemNameManual()
     */
    public function __construct($colorId = null, $packageTypeId = null, $lineType = null, $dcardId = null, $unitId = null, $qty = null, $qtyPrm = null, $qtyFreePrm = null, $qtyFreeSec = null, $dueDay = null, $campaignId = null, $unitPriceTra = null, $unitPrice = null, $vatStatus = null, $vatId = null, $vatRate = null, $amtVat = null, $abtActId = null, $abtBudgetId = null, $priceListId = null, $priceListDId = null, $whouseId = null, $abtBudgetD2Id = null, $disc1Id = null, $disc1Rate = null, $amtDisc1 = null, $amtDisc1Tra = null, $disc2Id = null, $disc2Rate = null, $amtDisc2 = null, $amtDisc2Tra = null, $disc3Id = null, $disc3Rate = null, $amtDisc3 = null, $amtDisc3Tra = null, $amtDisc = null, $amtWithDisc = null, $amt = null, $amtTra = null, $formContractMId = null, $itemAttribute1Id = null, $itemAttribute2Id = null, $itemAttribute3Id = null, $itemGnlAttribute1Id = null, $itemGnlAttribute2Id = null, $itemGnlAttribute3Id = null, $discCalcType1 = null, $discCalcType2 = null, $discCalcType3 = null, $lotId = null, $qualityId = null, $salesPersonId = null, $isItemAttribute = null, $colorCode = null, $packageTypeCode = null, $dcardCode = null, $unitCode = null, $vatCode = null, $abtActCode = null, $abtBudgetCode = null, $oTVCode = null, $oIVCode = null, $vatDiscCode = null, $priceListCode = null, $whouseCode = null, $disc1Code = null, $disc2Code = null, $disc3Code = null, $formContractCode = null, $itemAttributeCode1 = null, $itemAttributeCode2 = null, $itemAttributeCode3 = null, $itemGnlAttributeCode1 = null, $itemGnlAttributeCode2 = null, $itemGnlAttributeCode3 = null, $referanceDocNo = null, $lotCode = null, $qualityCode = null, $barcode = null, $itemNameManual = null)
    {
        parent::__construct();
        $this
            ->setColorId($colorId)
            ->setPackageTypeId($packageTypeId)
            ->setLineType($lineType)
            ->setDcardId($dcardId)
            ->setUnitId($unitId)
            ->setQty($qty)
            ->setQtyPrm($qtyPrm)
            ->setQtyFreePrm($qtyFreePrm)
            ->setQtyFreeSec($qtyFreeSec)
            ->setDueDay($dueDay)
            ->setCampaignId($campaignId)
            ->setUnitPriceTra($unitPriceTra)
            ->setUnitPrice($unitPrice)
            ->setVatStatus($vatStatus)
            ->setVatId($vatId)
            ->setVatRate($vatRate)
            ->setAmtVat($amtVat)
            ->setAbtActId($abtActId)
            ->setAbtBudgetId($abtBudgetId)
            ->setPriceListId($priceListId)
            ->setPriceListDId($priceListDId)
            ->setWhouseId($whouseId)
            ->setAbtBudgetD2Id($abtBudgetD2Id)
            ->setDisc1Id($disc1Id)
            ->setDisc1Rate($disc1Rate)
            ->setAmtDisc1($amtDisc1)
            ->setAmtDisc1Tra($amtDisc1Tra)
            ->setDisc2Id($disc2Id)
            ->setDisc2Rate($disc2Rate)
            ->setAmtDisc2($amtDisc2)
            ->setAmtDisc2Tra($amtDisc2Tra)
            ->setDisc3Id($disc3Id)
            ->setDisc3Rate($disc3Rate)
            ->setAmtDisc3($amtDisc3)
            ->setAmtDisc3Tra($amtDisc3Tra)
            ->setAmtDisc($amtDisc)
            ->setAmtWithDisc($amtWithDisc)
            ->setAmt($amt)
            ->setAmtTra($amtTra)
            ->setFormContractMId($formContractMId)
            ->setItemAttribute1Id($itemAttribute1Id)
            ->setItemAttribute2Id($itemAttribute2Id)
            ->setItemAttribute3Id($itemAttribute3Id)
            ->setItemGnlAttribute1Id($itemGnlAttribute1Id)
            ->setItemGnlAttribute2Id($itemGnlAttribute2Id)
            ->setItemGnlAttribute3Id($itemGnlAttribute3Id)
            ->setDiscCalcType1($discCalcType1)
            ->setDiscCalcType2($discCalcType2)
            ->setDiscCalcType3($discCalcType3)
            ->setLotId($lotId)
            ->setQualityId($qualityId)
            ->setSalesPersonId($salesPersonId)
            ->setIsItemAttribute($isItemAttribute)
            ->setColorCode($colorCode)
            ->setPackageTypeCode($packageTypeCode)
            ->setDcardCode($dcardCode)
            ->setUnitCode($unitCode)
            ->setVatCode($vatCode)
            ->setAbtActCode($abtActCode)
            ->setAbtBudgetCode($abtBudgetCode)
            ->setOTVCode($oTVCode)
            ->setOIVCode($oIVCode)
            ->setVatDiscCode($vatDiscCode)
            ->setPriceListCode($priceListCode)
            ->setWhouseCode($whouseCode)
            ->setDisc1Code($disc1Code)
            ->setDisc2Code($disc2Code)
            ->setDisc3Code($disc3Code)
            ->setFormContractCode($formContractCode)
            ->setItemAttributeCode1($itemAttributeCode1)
            ->setItemAttributeCode2($itemAttributeCode2)
            ->setItemAttributeCode3($itemAttributeCode3)
            ->setItemGnlAttributeCode1($itemGnlAttributeCode1)
            ->setItemGnlAttributeCode2($itemGnlAttributeCode2)
            ->setItemGnlAttributeCode3($itemGnlAttributeCode3)
            ->setReferanceDocNo($referanceDocNo)
            ->setLotCode($lotCode)
            ->setQualityCode($qualityCode)
            ->setBarcode($barcode)
            ->setItemNameManual($itemNameManual);
    }

    /**
     * Get ColorId value
     * @return int
     */
    public function getColorId()
    {
        return $this->ColorId;
    }

    /**
     * Set ColorId value
     * @param int $colorId
     * @return TransactionalDetailFields
     */
    public function setColorId($colorId = null)
    {
        // validation for constraint: int
        if (!is_null($colorId) && !(is_int($colorId) || ctype_digit($colorId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($colorId, true), gettype($colorId)), __LINE__);
        }
        $this->ColorId = $colorId;
        return $this;
    }

    /**
     * Get PackageTypeId value
     * @return int
     */
    public function getPackageTypeId()
    {
        return $this->PackageTypeId;
    }

    /**
     * Set PackageTypeId value
     * @param int $packageTypeId
     * @return TransactionalDetailFields
     */
    public function setPackageTypeId($packageTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($packageTypeId) && !(is_int($packageTypeId) || ctype_digit($packageTypeId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageTypeId, true), gettype($packageTypeId)), __LINE__);
        }
        $this->PackageTypeId = $packageTypeId;
        return $this;
    }

    /**
     * Get LineType value
     * @return string|null
     */
    public function getLineType()
    {
        return $this->LineType;
    }

    /**
     * Set LineType value
     * @param string|null $lineType
     * @return TransactionalDetailFields
     */
    public function setLineType($lineType = null)
    {
        $this->LineType = $lineType;
        return $this;
    }

    /**
     * Get DcardId value
     * @return int
     */
    public function getDcardId()
    {
        return $this->DcardId;
    }

    /**
     * Set DcardId value
     * @param int $dcardId
     * @return TransactionalDetailFields
     */
    public function setDcardId($dcardId = null)
    {
        // validation for constraint: int
        if (!is_null($dcardId) && !(is_int($dcardId) || ctype_digit($dcardId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dcardId, true), gettype($dcardId)), __LINE__);
        }
        $this->DcardId = $dcardId;
        return $this;
    }

    /**
     * Get UnitId value
     * @return int
     */
    public function getUnitId()
    {
        return $this->UnitId;
    }

    /**
     * Set UnitId value
     * @param int $unitId
     * @return TransactionalDetailFields
     */
    public function setUnitId($unitId = null)
    {
        // validation for constraint: int
        if (!is_null($unitId) && !(is_int($unitId) || ctype_digit($unitId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitId, true), gettype($unitId)), __LINE__);
        }
        $this->UnitId = $unitId;
        return $this;
    }

    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }

    /**
     * Set Qty value
     * @param float $qty
     * @return TransactionalDetailFields
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }

    /**
     * Get QtyPrm value
     * @return float
     */
    public function getQtyPrm()
    {
        return $this->QtyPrm;
    }

    /**
     * Set QtyPrm value
     * @param float $qtyPrm
     * @return TransactionalDetailFields
     */
    public function setQtyPrm($qtyPrm = null)
    {
        // validation for constraint: float
        if (!is_null($qtyPrm) && !(is_float($qtyPrm) || is_numeric($qtyPrm))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyPrm, true), gettype($qtyPrm)), __LINE__);
        }
        $this->QtyPrm = $qtyPrm;
        return $this;
    }

    /**
     * Get QtyFreePrm value
     * @return float
     */
    public function getQtyFreePrm()
    {
        return $this->QtyFreePrm;
    }

    /**
     * Set QtyFreePrm value
     * @param float $qtyFreePrm
     * @return TransactionalDetailFields
     */
    public function setQtyFreePrm($qtyFreePrm = null)
    {
        // validation for constraint: float
        if (!is_null($qtyFreePrm) && !(is_float($qtyFreePrm) || is_numeric($qtyFreePrm))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyFreePrm, true), gettype($qtyFreePrm)), __LINE__);
        }
        $this->QtyFreePrm = $qtyFreePrm;
        return $this;
    }

    /**
     * Get QtyFreeSec value
     * @return float
     */
    public function getQtyFreeSec()
    {
        return $this->QtyFreeSec;
    }

    /**
     * Set QtyFreeSec value
     * @param float $qtyFreeSec
     * @return TransactionalDetailFields
     */
    public function setQtyFreeSec($qtyFreeSec = null)
    {
        // validation for constraint: float
        if (!is_null($qtyFreeSec) && !(is_float($qtyFreeSec) || is_numeric($qtyFreeSec))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyFreeSec, true), gettype($qtyFreeSec)), __LINE__);
        }
        $this->QtyFreeSec = $qtyFreeSec;
        return $this;
    }

    /**
     * Get DueDay value
     * @return int
     */
    public function getDueDay()
    {
        return $this->DueDay;
    }

    /**
     * Set DueDay value
     * @param int $dueDay
     * @return TransactionalDetailFields
     */
    public function setDueDay($dueDay = null)
    {
        // validation for constraint: int
        if (!is_null($dueDay) && !(is_int($dueDay) || ctype_digit($dueDay))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dueDay, true), gettype($dueDay)), __LINE__);
        }
        $this->DueDay = $dueDay;
        return $this;
    }

    /**
     * Get CampaignId value
     * @return int
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }

    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return TransactionalDetailFields
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }

    /**
     * Get UnitPriceTra value
     * @return float
     */
    public function getUnitPriceTra()
    {
        return $this->UnitPriceTra;
    }

    /**
     * Set UnitPriceTra value
     * @param float $unitPriceTra
     * @return TransactionalDetailFields
     */
    public function setUnitPriceTra($unitPriceTra = null)
    {
        // validation for constraint: float
        if (!is_null($unitPriceTra) && !(is_float($unitPriceTra) || is_numeric($unitPriceTra))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPriceTra, true), gettype($unitPriceTra)), __LINE__);
        }
        $this->UnitPriceTra = $unitPriceTra;
        return $this;
    }

    /**
     * Get UnitPrice value
     * @return float
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }

    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return TransactionalDetailFields
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }

    /**
     * Get VatStatus value
     * @return string
     */
    public function getVatStatus()
    {
        return $this->VatStatus;
    }

    /**
     * Set VatStatus value
     * @param string $vatStatus
     * @return TransactionalDetailFields
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\VatStatus::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\VatStatus::valueIsValid()
     */
    public function setVatStatus($vatStatus = null)
    {
        // validation for constraint: enumeration
        if (!VatStatus::valueIsValid($vatStatus)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\VatStatus', is_array($vatStatus) ? implode(', ', $vatStatus) : var_export($vatStatus, true), implode(', ', VatStatus::getValidValues())), __LINE__);
        }
        $this->VatStatus = $vatStatus;
        return $this;
    }

    /**
     * Get VatId value
     * @return int
     */
    public function getVatId()
    {
        return $this->VatId;
    }

    /**
     * Set VatId value
     * @param int $vatId
     * @return TransactionalDetailFields
     */
    public function setVatId($vatId = null)
    {
        // validation for constraint: int
        if (!is_null($vatId) && !(is_int($vatId) || ctype_digit($vatId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vatId, true), gettype($vatId)), __LINE__);
        }
        $this->VatId = $vatId;
        return $this;
    }

    /**
     * Get VatRate value
     * @return float
     */
    public function getVatRate()
    {
        return $this->VatRate;
    }

    /**
     * Set VatRate value
     * @param float $vatRate
     * @return TransactionalDetailFields
     */
    public function setVatRate($vatRate = null)
    {
        // validation for constraint: float
        if (!is_null($vatRate) && !(is_float($vatRate) || is_numeric($vatRate))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatRate, true), gettype($vatRate)), __LINE__);
        }
        $this->VatRate = $vatRate;
        return $this;
    }

    /**
     * Get AmtVat value
     * @return float
     */
    public function getAmtVat()
    {
        return $this->AmtVat;
    }

    /**
     * Set AmtVat value
     * @param float $amtVat
     * @return TransactionalDetailFields
     */
    public function setAmtVat($amtVat = null)
    {
        // validation for constraint: float
        if (!is_null($amtVat) && !(is_float($amtVat) || is_numeric($amtVat))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtVat, true), gettype($amtVat)), __LINE__);
        }
        $this->AmtVat = $amtVat;
        return $this;
    }

    /**
     * Get AbtActId value
     * @return int
     */
    public function getAbtActId()
    {
        return $this->AbtActId;
    }

    /**
     * Set AbtActId value
     * @param int $abtActId
     * @return TransactionalDetailFields
     */
    public function setAbtActId($abtActId = null)
    {
        // validation for constraint: int
        if (!is_null($abtActId) && !(is_int($abtActId) || ctype_digit($abtActId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abtActId, true), gettype($abtActId)), __LINE__);
        }
        $this->AbtActId = $abtActId;
        return $this;
    }

    /**
     * Get AbtBudgetId value
     * @return int
     */
    public function getAbtBudgetId()
    {
        return $this->AbtBudgetId;
    }

    /**
     * Set AbtBudgetId value
     * @param int $abtBudgetId
     * @return TransactionalDetailFields
     */
    public function setAbtBudgetId($abtBudgetId = null)
    {
        // validation for constraint: int
        if (!is_null($abtBudgetId) && !(is_int($abtBudgetId) || ctype_digit($abtBudgetId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abtBudgetId, true), gettype($abtBudgetId)), __LINE__);
        }
        $this->AbtBudgetId = $abtBudgetId;
        return $this;
    }

    /**
     * Get PriceListId value
     * @return int
     */
    public function getPriceListId()
    {
        return $this->PriceListId;
    }

    /**
     * Set PriceListId value
     * @param int $priceListId
     * @return TransactionalDetailFields
     */
    public function setPriceListId($priceListId = null)
    {
        // validation for constraint: int
        if (!is_null($priceListId) && !(is_int($priceListId) || ctype_digit($priceListId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceListId, true), gettype($priceListId)), __LINE__);
        }
        $this->PriceListId = $priceListId;
        return $this;
    }

    /**
     * Get PriceListDId value
     * @return int
     */
    public function getPriceListDId()
    {
        return $this->PriceListDId;
    }

    /**
     * Set PriceListDId value
     * @param int $priceListDId
     * @return TransactionalDetailFields
     */
    public function setPriceListDId($priceListDId = null)
    {
        // validation for constraint: int
        if (!is_null($priceListDId) && !(is_int($priceListDId) || ctype_digit($priceListDId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceListDId, true), gettype($priceListDId)), __LINE__);
        }
        $this->PriceListDId = $priceListDId;
        return $this;
    }

    /**
     * Get WhouseId value
     * @return int
     */
    public function getWhouseId()
    {
        return $this->WhouseId;
    }

    /**
     * Set WhouseId value
     * @param int $whouseId
     * @return TransactionalDetailFields
     */
    public function setWhouseId($whouseId = null)
    {
        // validation for constraint: int
        if (!is_null($whouseId) && !(is_int($whouseId) || ctype_digit($whouseId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($whouseId, true), gettype($whouseId)), __LINE__);
        }
        $this->WhouseId = $whouseId;
        return $this;
    }

    /**
     * Get AbtBudgetD2Id value
     * @return int
     */
    public function getAbtBudgetD2Id()
    {
        return $this->AbtBudgetD2Id;
    }

    /**
     * Set AbtBudgetD2Id value
     * @param int $abtBudgetD2Id
     * @return TransactionalDetailFields
     */
    public function setAbtBudgetD2Id($abtBudgetD2Id = null)
    {
        // validation for constraint: int
        if (!is_null($abtBudgetD2Id) && !(is_int($abtBudgetD2Id) || ctype_digit($abtBudgetD2Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abtBudgetD2Id, true), gettype($abtBudgetD2Id)), __LINE__);
        }
        $this->AbtBudgetD2Id = $abtBudgetD2Id;
        return $this;
    }

    /**
     * Get Disc1Id value
     * @return int
     */
    public function getDisc1Id()
    {
        return $this->Disc1Id;
    }

    /**
     * Set Disc1Id value
     * @param int $disc1Id
     * @return TransactionalDetailFields
     */
    public function setDisc1Id($disc1Id = null)
    {
        // validation for constraint: int
        if (!is_null($disc1Id) && !(is_int($disc1Id) || ctype_digit($disc1Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($disc1Id, true), gettype($disc1Id)), __LINE__);
        }
        $this->Disc1Id = $disc1Id;
        return $this;
    }

    /**
     * Get Disc1Rate value
     * @return float
     */
    public function getDisc1Rate()
    {
        return $this->Disc1Rate;
    }

    /**
     * Set Disc1Rate value
     * @param float $disc1Rate
     * @return TransactionalDetailFields
     */
    public function setDisc1Rate($disc1Rate = null)
    {
        // validation for constraint: float
        if (!is_null($disc1Rate) && !(is_float($disc1Rate) || is_numeric($disc1Rate))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disc1Rate, true), gettype($disc1Rate)), __LINE__);
        }
        $this->Disc1Rate = $disc1Rate;
        return $this;
    }

    /**
     * Get AmtDisc1 value
     * @return float
     */
    public function getAmtDisc1()
    {
        return $this->AmtDisc1;
    }

    /**
     * Set AmtDisc1 value
     * @param float $amtDisc1
     * @return TransactionalDetailFields
     */
    public function setAmtDisc1($amtDisc1 = null)
    {
        // validation for constraint: float
        if (!is_null($amtDisc1) && !(is_float($amtDisc1) || is_numeric($amtDisc1))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDisc1, true), gettype($amtDisc1)), __LINE__);
        }
        $this->AmtDisc1 = $amtDisc1;
        return $this;
    }

    /**
     * Get AmtDisc1Tra value
     * @return float
     */
    public function getAmtDisc1Tra()
    {
        return $this->AmtDisc1Tra;
    }

    /**
     * Set AmtDisc1Tra value
     * @param float $amtDisc1Tra
     * @return TransactionalDetailFields
     */
    public function setAmtDisc1Tra($amtDisc1Tra = null)
    {
        // validation for constraint: float
        if (!is_null($amtDisc1Tra) && !(is_float($amtDisc1Tra) || is_numeric($amtDisc1Tra))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDisc1Tra, true), gettype($amtDisc1Tra)), __LINE__);
        }
        $this->AmtDisc1Tra = $amtDisc1Tra;
        return $this;
    }

    /**
     * Get Disc2Id value
     * @return int
     */
    public function getDisc2Id()
    {
        return $this->Disc2Id;
    }

    /**
     * Set Disc2Id value
     * @param int $disc2Id
     * @return TransactionalDetailFields
     */
    public function setDisc2Id($disc2Id = null)
    {
        // validation for constraint: int
        if (!is_null($disc2Id) && !(is_int($disc2Id) || ctype_digit($disc2Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($disc2Id, true), gettype($disc2Id)), __LINE__);
        }
        $this->Disc2Id = $disc2Id;
        return $this;
    }

    /**
     * Get Disc2Rate value
     * @return float
     */
    public function getDisc2Rate()
    {
        return $this->Disc2Rate;
    }

    /**
     * Set Disc2Rate value
     * @param float $disc2Rate
     * @return TransactionalDetailFields
     */
    public function setDisc2Rate($disc2Rate = null)
    {
        // validation for constraint: float
        if (!is_null($disc2Rate) && !(is_float($disc2Rate) || is_numeric($disc2Rate))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disc2Rate, true), gettype($disc2Rate)), __LINE__);
        }
        $this->Disc2Rate = $disc2Rate;
        return $this;
    }

    /**
     * Get AmtDisc2 value
     * @return float
     */
    public function getAmtDisc2()
    {
        return $this->AmtDisc2;
    }

    /**
     * Set AmtDisc2 value
     * @param float $amtDisc2
     * @return TransactionalDetailFields
     */
    public function setAmtDisc2($amtDisc2 = null)
    {
        // validation for constraint: float
        if (!is_null($amtDisc2) && !(is_float($amtDisc2) || is_numeric($amtDisc2))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDisc2, true), gettype($amtDisc2)), __LINE__);
        }
        $this->AmtDisc2 = $amtDisc2;
        return $this;
    }

    /**
     * Get AmtDisc2Tra value
     * @return float
     */
    public function getAmtDisc2Tra()
    {
        return $this->AmtDisc2Tra;
    }

    /**
     * Set AmtDisc2Tra value
     * @param float $amtDisc2Tra
     * @return TransactionalDetailFields
     */
    public function setAmtDisc2Tra($amtDisc2Tra = null)
    {
        // validation for constraint: float
        if (!is_null($amtDisc2Tra) && !(is_float($amtDisc2Tra) || is_numeric($amtDisc2Tra))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDisc2Tra, true), gettype($amtDisc2Tra)), __LINE__);
        }
        $this->AmtDisc2Tra = $amtDisc2Tra;
        return $this;
    }

    /**
     * Get Disc3Id value
     * @return int
     */
    public function getDisc3Id()
    {
        return $this->Disc3Id;
    }

    /**
     * Set Disc3Id value
     * @param int $disc3Id
     * @return TransactionalDetailFields
     */
    public function setDisc3Id($disc3Id = null)
    {
        // validation for constraint: int
        if (!is_null($disc3Id) && !(is_int($disc3Id) || ctype_digit($disc3Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($disc3Id, true), gettype($disc3Id)), __LINE__);
        }
        $this->Disc3Id = $disc3Id;
        return $this;
    }

    /**
     * Get Disc3Rate value
     * @return float
     */
    public function getDisc3Rate()
    {
        return $this->Disc3Rate;
    }

    /**
     * Set Disc3Rate value
     * @param float $disc3Rate
     * @return TransactionalDetailFields
     */
    public function setDisc3Rate($disc3Rate = null)
    {
        // validation for constraint: float
        if (!is_null($disc3Rate) && !(is_float($disc3Rate) || is_numeric($disc3Rate))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disc3Rate, true), gettype($disc3Rate)), __LINE__);
        }
        $this->Disc3Rate = $disc3Rate;
        return $this;
    }

    /**
     * Get AmtDisc3 value
     * @return float
     */
    public function getAmtDisc3()
    {
        return $this->AmtDisc3;
    }

    /**
     * Set AmtDisc3 value
     * @param float $amtDisc3
     * @return TransactionalDetailFields
     */
    public function setAmtDisc3($amtDisc3 = null)
    {
        // validation for constraint: float
        if (!is_null($amtDisc3) && !(is_float($amtDisc3) || is_numeric($amtDisc3))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDisc3, true), gettype($amtDisc3)), __LINE__);
        }
        $this->AmtDisc3 = $amtDisc3;
        return $this;
    }

    /**
     * Get AmtDisc3Tra value
     * @return float
     */
    public function getAmtDisc3Tra()
    {
        return $this->AmtDisc3Tra;
    }

    /**
     * Set AmtDisc3Tra value
     * @param float $amtDisc3Tra
     * @return TransactionalDetailFields
     */
    public function setAmtDisc3Tra($amtDisc3Tra = null)
    {
        // validation for constraint: float
        if (!is_null($amtDisc3Tra) && !(is_float($amtDisc3Tra) || is_numeric($amtDisc3Tra))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDisc3Tra, true), gettype($amtDisc3Tra)), __LINE__);
        }
        $this->AmtDisc3Tra = $amtDisc3Tra;
        return $this;
    }

    /**
     * Get AmtDisc value
     * @return float
     */
    public function getAmtDisc()
    {
        return $this->AmtDisc;
    }

    /**
     * Set AmtDisc value
     * @param float $amtDisc
     * @return TransactionalDetailFields
     */
    public function setAmtDisc($amtDisc = null)
    {
        // validation for constraint: float
        if (!is_null($amtDisc) && !(is_float($amtDisc) || is_numeric($amtDisc))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDisc, true), gettype($amtDisc)), __LINE__);
        }
        $this->AmtDisc = $amtDisc;
        return $this;
    }

    /**
     * Get AmtWithDisc value
     * @return float
     */
    public function getAmtWithDisc()
    {
        return $this->AmtWithDisc;
    }

    /**
     * Set AmtWithDisc value
     * @param float $amtWithDisc
     * @return TransactionalDetailFields
     */
    public function setAmtWithDisc($amtWithDisc = null)
    {
        // validation for constraint: float
        if (!is_null($amtWithDisc) && !(is_float($amtWithDisc) || is_numeric($amtWithDisc))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtWithDisc, true), gettype($amtWithDisc)), __LINE__);
        }
        $this->AmtWithDisc = $amtWithDisc;
        return $this;
    }

    /**
     * Get Amt value
     * @return float
     */
    public function getAmt()
    {
        return $this->Amt;
    }

    /**
     * Set Amt value
     * @param float $amt
     * @return TransactionalDetailFields
     */
    public function setAmt($amt = null)
    {
        // validation for constraint: float
        if (!is_null($amt) && !(is_float($amt) || is_numeric($amt))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amt, true), gettype($amt)), __LINE__);
        }
        $this->Amt = $amt;
        return $this;
    }

    /**
     * Get AmtTra value
     * @return float
     */
    public function getAmtTra()
    {
        return $this->AmtTra;
    }

    /**
     * Set AmtTra value
     * @param float $amtTra
     * @return TransactionalDetailFields
     */
    public function setAmtTra($amtTra = null)
    {
        // validation for constraint: float
        if (!is_null($amtTra) && !(is_float($amtTra) || is_numeric($amtTra))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtTra, true), gettype($amtTra)), __LINE__);
        }
        $this->AmtTra = $amtTra;
        return $this;
    }

    /**
     * Get FormContractMId value
     * @return int
     */
    public function getFormContractMId()
    {
        return $this->FormContractMId;
    }

    /**
     * Set FormContractMId value
     * @param int $formContractMId
     * @return TransactionalDetailFields
     */
    public function setFormContractMId($formContractMId = null)
    {
        // validation for constraint: int
        if (!is_null($formContractMId) && !(is_int($formContractMId) || ctype_digit($formContractMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($formContractMId, true), gettype($formContractMId)), __LINE__);
        }
        $this->FormContractMId = $formContractMId;
        return $this;
    }

    /**
     * Get ItemAttribute1Id value
     * @return int
     */
    public function getItemAttribute1Id()
    {
        return $this->ItemAttribute1Id;
    }

    /**
     * Set ItemAttribute1Id value
     * @param int $itemAttribute1Id
     * @return TransactionalDetailFields
     */
    public function setItemAttribute1Id($itemAttribute1Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemAttribute1Id) && !(is_int($itemAttribute1Id) || ctype_digit($itemAttribute1Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAttribute1Id, true), gettype($itemAttribute1Id)), __LINE__);
        }
        $this->ItemAttribute1Id = $itemAttribute1Id;
        return $this;
    }

    /**
     * Get ItemAttribute2Id value
     * @return int
     */
    public function getItemAttribute2Id()
    {
        return $this->ItemAttribute2Id;
    }

    /**
     * Set ItemAttribute2Id value
     * @param int $itemAttribute2Id
     * @return TransactionalDetailFields
     */
    public function setItemAttribute2Id($itemAttribute2Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemAttribute2Id) && !(is_int($itemAttribute2Id) || ctype_digit($itemAttribute2Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAttribute2Id, true), gettype($itemAttribute2Id)), __LINE__);
        }
        $this->ItemAttribute2Id = $itemAttribute2Id;
        return $this;
    }

    /**
     * Get ItemAttribute3Id value
     * @return int
     */
    public function getItemAttribute3Id()
    {
        return $this->ItemAttribute3Id;
    }

    /**
     * Set ItemAttribute3Id value
     * @param int $itemAttribute3Id
     * @return TransactionalDetailFields
     */
    public function setItemAttribute3Id($itemAttribute3Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemAttribute3Id) && !(is_int($itemAttribute3Id) || ctype_digit($itemAttribute3Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAttribute3Id, true), gettype($itemAttribute3Id)), __LINE__);
        }
        $this->ItemAttribute3Id = $itemAttribute3Id;
        return $this;
    }

    /**
     * Get ItemGnlAttribute1Id value
     * @return int
     */
    public function getItemGnlAttribute1Id()
    {
        return $this->ItemGnlAttribute1Id;
    }

    /**
     * Set ItemGnlAttribute1Id value
     * @param int $itemGnlAttribute1Id
     * @return TransactionalDetailFields
     */
    public function setItemGnlAttribute1Id($itemGnlAttribute1Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemGnlAttribute1Id) && !(is_int($itemGnlAttribute1Id) || ctype_digit($itemGnlAttribute1Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemGnlAttribute1Id, true), gettype($itemGnlAttribute1Id)), __LINE__);
        }
        $this->ItemGnlAttribute1Id = $itemGnlAttribute1Id;
        return $this;
    }

    /**
     * Get ItemGnlAttribute2Id value
     * @return int
     */
    public function getItemGnlAttribute2Id()
    {
        return $this->ItemGnlAttribute2Id;
    }

    /**
     * Set ItemGnlAttribute2Id value
     * @param int $itemGnlAttribute2Id
     * @return TransactionalDetailFields
     */
    public function setItemGnlAttribute2Id($itemGnlAttribute2Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemGnlAttribute2Id) && !(is_int($itemGnlAttribute2Id) || ctype_digit($itemGnlAttribute2Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemGnlAttribute2Id, true), gettype($itemGnlAttribute2Id)), __LINE__);
        }
        $this->ItemGnlAttribute2Id = $itemGnlAttribute2Id;
        return $this;
    }

    /**
     * Get ItemGnlAttribute3Id value
     * @return int
     */
    public function getItemGnlAttribute3Id()
    {
        return $this->ItemGnlAttribute3Id;
    }

    /**
     * Set ItemGnlAttribute3Id value
     * @param int $itemGnlAttribute3Id
     * @return TransactionalDetailFields
     */
    public function setItemGnlAttribute3Id($itemGnlAttribute3Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemGnlAttribute3Id) && !(is_int($itemGnlAttribute3Id) || ctype_digit($itemGnlAttribute3Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemGnlAttribute3Id, true), gettype($itemGnlAttribute3Id)), __LINE__);
        }
        $this->ItemGnlAttribute3Id = $itemGnlAttribute3Id;
        return $this;
    }

    /**
     * Get DiscCalcType1 value
     * @return string
     */
    public function getDiscCalcType1()
    {
        return $this->DiscCalcType1;
    }

    /**
     * Set DiscCalcType1 value
     * @param string $discCalcType1
     * @return TransactionalDetailFields
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\DiscTypes::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\DiscTypes::valueIsValid()
     */
    public function setDiscCalcType1($discCalcType1 = null)
    {
        // validation for constraint: enumeration
        if (!DiscTypes::valueIsValid($discCalcType1)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\DiscTypes', is_array($discCalcType1) ? implode(', ', $discCalcType1) : var_export($discCalcType1, true), implode(', ', DiscTypes::getValidValues())), __LINE__);
        }
        $this->DiscCalcType1 = $discCalcType1;
        return $this;
    }

    /**
     * Get DiscCalcType2 value
     * @return string
     */
    public function getDiscCalcType2()
    {
        return $this->DiscCalcType2;
    }

    /**
     * Set DiscCalcType2 value
     * @param string $discCalcType2
     * @return TransactionalDetailFields
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\DiscTypes::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\DiscTypes::valueIsValid()
     */
    public function setDiscCalcType2($discCalcType2 = null)
    {
        // validation for constraint: enumeration
        if (!DiscTypes::valueIsValid($discCalcType2)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\DiscTypes', is_array($discCalcType2) ? implode(', ', $discCalcType2) : var_export($discCalcType2, true), implode(', ', DiscTypes::getValidValues())), __LINE__);
        }
        $this->DiscCalcType2 = $discCalcType2;
        return $this;
    }

    /**
     * Get DiscCalcType3 value
     * @return string
     */
    public function getDiscCalcType3()
    {
        return $this->DiscCalcType3;
    }

    /**
     * Set DiscCalcType3 value
     * @param string $discCalcType3
     * @return TransactionalDetailFields
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\DiscTypes::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\DiscTypes::valueIsValid()
     */
    public function setDiscCalcType3($discCalcType3 = null)
    {
        // validation for constraint: enumeration
        if (!DiscTypes::valueIsValid($discCalcType3)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\DiscTypes', is_array($discCalcType3) ? implode(', ', $discCalcType3) : var_export($discCalcType3, true), implode(', ', DiscTypes::getValidValues())), __LINE__);
        }
        $this->DiscCalcType3 = $discCalcType3;
        return $this;
    }

    /**
     * Get LotId value
     * @return int
     */
    public function getLotId()
    {
        return $this->LotId;
    }

    /**
     * Set LotId value
     * @param int $lotId
     * @return TransactionalDetailFields
     */
    public function setLotId($lotId = null)
    {
        // validation for constraint: int
        if (!is_null($lotId) && !(is_int($lotId) || ctype_digit($lotId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lotId, true), gettype($lotId)), __LINE__);
        }
        $this->LotId = $lotId;
        return $this;
    }

    /**
     * Get QualityId value
     * @return int
     */
    public function getQualityId()
    {
        return $this->QualityId;
    }

    /**
     * Set QualityId value
     * @param int $qualityId
     * @return TransactionalDetailFields
     */
    public function setQualityId($qualityId = null)
    {
        // validation for constraint: int
        if (!is_null($qualityId) && !(is_int($qualityId) || ctype_digit($qualityId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qualityId, true), gettype($qualityId)), __LINE__);
        }
        $this->QualityId = $qualityId;
        return $this;
    }

    /**
     * Get SalesPersonId value
     * @return int
     */
    public function getSalesPersonId()
    {
        return $this->SalesPersonId;
    }

    /**
     * Set SalesPersonId value
     * @param int $salesPersonId
     * @return TransactionalDetailFields
     */
    public function setSalesPersonId($salesPersonId = null)
    {
        // validation for constraint: int
        if (!is_null($salesPersonId) && !(is_int($salesPersonId) || ctype_digit($salesPersonId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salesPersonId, true), gettype($salesPersonId)), __LINE__);
        }
        $this->SalesPersonId = $salesPersonId;
        return $this;
    }

    /**
     * Get IsItemAttribute value
     * @return bool
     */
    public function getIsItemAttribute()
    {
        return $this->IsItemAttribute;
    }

    /**
     * Set IsItemAttribute value
     * @param bool $isItemAttribute
     * @return TransactionalDetailFields
     */
    public function setIsItemAttribute($isItemAttribute = null)
    {
        // validation for constraint: boolean
        if (!is_null($isItemAttribute) && !is_bool($isItemAttribute)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isItemAttribute, true), gettype($isItemAttribute)), __LINE__);
        }
        $this->IsItemAttribute = $isItemAttribute;
        return $this;
    }

    /**
     * Get ColorCode value
     * @return string|null
     */
    public function getColorCode()
    {
        return $this->ColorCode;
    }

    /**
     * Set ColorCode value
     * @param string $colorCode
     * @return TransactionalDetailFields
     */
    public function setColorCode($colorCode = null)
    {
        // validation for constraint: string
        if (!is_null($colorCode) && !is_string($colorCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorCode, true), gettype($colorCode)), __LINE__);
        }
        $this->ColorCode = $colorCode;
        return $this;
    }

    /**
     * Get PackageTypeCode value
     * @return string|null
     */
    public function getPackageTypeCode()
    {
        return $this->PackageTypeCode;
    }

    /**
     * Set PackageTypeCode value
     * @param string $packageTypeCode
     * @return TransactionalDetailFields
     */
    public function setPackageTypeCode($packageTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($packageTypeCode) && !is_string($packageTypeCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageTypeCode, true), gettype($packageTypeCode)), __LINE__);
        }
        $this->PackageTypeCode = $packageTypeCode;
        return $this;
    }

    /**
     * Get DcardCode value
     * @return string|null
     */
    public function getDcardCode()
    {
        return $this->DcardCode;
    }

    /**
     * Set DcardCode value
     * @param string $dcardCode
     * @return TransactionalDetailFields
     */
    public function setDcardCode($dcardCode = null)
    {
        // validation for constraint: string
        if (!is_null($dcardCode) && !is_string($dcardCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dcardCode, true), gettype($dcardCode)), __LINE__);
        }
        $this->DcardCode = $dcardCode;
        return $this;
    }

    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }

    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return TransactionalDetailFields
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }

    /**
     * Get VatCode value
     * @return string|null
     */
    public function getVatCode()
    {
        return $this->VatCode;
    }

    /**
     * Set VatCode value
     * @param string $vatCode
     * @return TransactionalDetailFields
     */
    public function setVatCode($vatCode = null)
    {
        // validation for constraint: string
        if (!is_null($vatCode) && !is_string($vatCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatCode, true), gettype($vatCode)), __LINE__);
        }
        $this->VatCode = $vatCode;
        return $this;
    }

    /**
     * Get AbtActCode value
     * @return string|null
     */
    public function getAbtActCode()
    {
        return $this->AbtActCode;
    }

    /**
     * Set AbtActCode value
     * @param string $abtActCode
     * @return TransactionalDetailFields
     */
    public function setAbtActCode($abtActCode = null)
    {
        // validation for constraint: string
        if (!is_null($abtActCode) && !is_string($abtActCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abtActCode, true), gettype($abtActCode)), __LINE__);
        }
        $this->AbtActCode = $abtActCode;
        return $this;
    }

    /**
     * Get AbtBudgetCode value
     * @return string|null
     */
    public function getAbtBudgetCode()
    {
        return $this->AbtBudgetCode;
    }

    /**
     * Set AbtBudgetCode value
     * @param string $abtBudgetCode
     * @return TransactionalDetailFields
     */
    public function setAbtBudgetCode($abtBudgetCode = null)
    {
        // validation for constraint: string
        if (!is_null($abtBudgetCode) && !is_string($abtBudgetCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abtBudgetCode, true), gettype($abtBudgetCode)), __LINE__);
        }
        $this->AbtBudgetCode = $abtBudgetCode;
        return $this;
    }

    /**
     * Get OTVCode value
     * @return string|null
     */
    public function getOTVCode()
    {
        return $this->OTVCode;
    }

    /**
     * Set OTVCode value
     * @param string $oTVCode
     * @return TransactionalDetailFields
     */
    public function setOTVCode($oTVCode = null)
    {
        // validation for constraint: string
        if (!is_null($oTVCode) && !is_string($oTVCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oTVCode, true), gettype($oTVCode)), __LINE__);
        }
        $this->OTVCode = $oTVCode;
        return $this;
    }

    /**
     * Get OIVCode value
     * @return string|null
     */
    public function getOIVCode()
    {
        return $this->OIVCode;
    }

    /**
     * Set OIVCode value
     * @param string $oIVCode
     * @return TransactionalDetailFields
     */
    public function setOIVCode($oIVCode = null)
    {
        // validation for constraint: string
        if (!is_null($oIVCode) && !is_string($oIVCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIVCode, true), gettype($oIVCode)), __LINE__);
        }
        $this->OIVCode = $oIVCode;
        return $this;
    }

    /**
     * Get VatDiscCode value
     * @return string|null
     */
    public function getVatDiscCode()
    {
        return $this->VatDiscCode;
    }

    /**
     * Set VatDiscCode value
     * @param string $vatDiscCode
     * @return TransactionalDetailFields
     */
    public function setVatDiscCode($vatDiscCode = null)
    {
        // validation for constraint: string
        if (!is_null($vatDiscCode) && !is_string($vatDiscCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatDiscCode, true), gettype($vatDiscCode)), __LINE__);
        }
        $this->VatDiscCode = $vatDiscCode;
        return $this;
    }

    /**
     * Get PriceListCode value
     * @return string|null
     */
    public function getPriceListCode()
    {
        return $this->PriceListCode;
    }

    /**
     * Set PriceListCode value
     * @param string $priceListCode
     * @return TransactionalDetailFields
     */
    public function setPriceListCode($priceListCode = null)
    {
        // validation for constraint: string
        if (!is_null($priceListCode) && !is_string($priceListCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListCode, true), gettype($priceListCode)), __LINE__);
        }
        $this->PriceListCode = $priceListCode;
        return $this;
    }

    /**
     * Get WhouseCode value
     * @return string|null
     */
    public function getWhouseCode()
    {
        return $this->WhouseCode;
    }

    /**
     * Set WhouseCode value
     * @param string $whouseCode
     * @return TransactionalDetailFields
     */
    public function setWhouseCode($whouseCode = null)
    {
        // validation for constraint: string
        if (!is_null($whouseCode) && !is_string($whouseCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whouseCode, true), gettype($whouseCode)), __LINE__);
        }
        $this->WhouseCode = $whouseCode;
        return $this;
    }

    /**
     * Get Disc1Code value
     * @return string|null
     */
    public function getDisc1Code()
    {
        return $this->Disc1Code;
    }

    /**
     * Set Disc1Code value
     * @param string $disc1Code
     * @return TransactionalDetailFields
     */
    public function setDisc1Code($disc1Code = null)
    {
        // validation for constraint: string
        if (!is_null($disc1Code) && !is_string($disc1Code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disc1Code, true), gettype($disc1Code)), __LINE__);
        }
        $this->Disc1Code = $disc1Code;
        return $this;
    }

    /**
     * Get Disc2Code value
     * @return string|null
     */
    public function getDisc2Code()
    {
        return $this->Disc2Code;
    }

    /**
     * Set Disc2Code value
     * @param string $disc2Code
     * @return TransactionalDetailFields
     */
    public function setDisc2Code($disc2Code = null)
    {
        // validation for constraint: string
        if (!is_null($disc2Code) && !is_string($disc2Code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disc2Code, true), gettype($disc2Code)), __LINE__);
        }
        $this->Disc2Code = $disc2Code;
        return $this;
    }

    /**
     * Get Disc3Code value
     * @return string|null
     */
    public function getDisc3Code()
    {
        return $this->Disc3Code;
    }

    /**
     * Set Disc3Code value
     * @param string $disc3Code
     * @return TransactionalDetailFields
     */
    public function setDisc3Code($disc3Code = null)
    {
        // validation for constraint: string
        if (!is_null($disc3Code) && !is_string($disc3Code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disc3Code, true), gettype($disc3Code)), __LINE__);
        }
        $this->Disc3Code = $disc3Code;
        return $this;
    }

    /**
     * Get FormContractCode value
     * @return string|null
     */
    public function getFormContractCode()
    {
        return $this->FormContractCode;
    }

    /**
     * Set FormContractCode value
     * @param string $formContractCode
     * @return TransactionalDetailFields
     */
    public function setFormContractCode($formContractCode = null)
    {
        // validation for constraint: string
        if (!is_null($formContractCode) && !is_string($formContractCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formContractCode, true), gettype($formContractCode)), __LINE__);
        }
        $this->FormContractCode = $formContractCode;
        return $this;
    }

    /**
     * Get ItemAttributeCode1 value
     * @return string|null
     */
    public function getItemAttributeCode1()
    {
        return $this->ItemAttributeCode1;
    }

    /**
     * Set ItemAttributeCode1 value
     * @param string $itemAttributeCode1
     * @return TransactionalDetailFields
     */
    public function setItemAttributeCode1($itemAttributeCode1 = null)
    {
        // validation for constraint: string
        if (!is_null($itemAttributeCode1) && !is_string($itemAttributeCode1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemAttributeCode1, true), gettype($itemAttributeCode1)), __LINE__);
        }
        $this->ItemAttributeCode1 = $itemAttributeCode1;
        return $this;
    }

    /**
     * Get ItemAttributeCode2 value
     * @return string|null
     */
    public function getItemAttributeCode2()
    {
        return $this->ItemAttributeCode2;
    }

    /**
     * Set ItemAttributeCode2 value
     * @param string $itemAttributeCode2
     * @return TransactionalDetailFields
     */
    public function setItemAttributeCode2($itemAttributeCode2 = null)
    {
        // validation for constraint: string
        if (!is_null($itemAttributeCode2) && !is_string($itemAttributeCode2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemAttributeCode2, true), gettype($itemAttributeCode2)), __LINE__);
        }
        $this->ItemAttributeCode2 = $itemAttributeCode2;
        return $this;
    }

    /**
     * Get ItemAttributeCode3 value
     * @return string|null
     */
    public function getItemAttributeCode3()
    {
        return $this->ItemAttributeCode3;
    }

    /**
     * Set ItemAttributeCode3 value
     * @param string $itemAttributeCode3
     * @return TransactionalDetailFields
     */
    public function setItemAttributeCode3($itemAttributeCode3 = null)
    {
        // validation for constraint: string
        if (!is_null($itemAttributeCode3) && !is_string($itemAttributeCode3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemAttributeCode3, true), gettype($itemAttributeCode3)), __LINE__);
        }
        $this->ItemAttributeCode3 = $itemAttributeCode3;
        return $this;
    }

    /**
     * Get ItemGnlAttributeCode1 value
     * @return string|null
     */
    public function getItemGnlAttributeCode1()
    {
        return $this->ItemGnlAttributeCode1;
    }

    /**
     * Set ItemGnlAttributeCode1 value
     * @param string $itemGnlAttributeCode1
     * @return TransactionalDetailFields
     */
    public function setItemGnlAttributeCode1($itemGnlAttributeCode1 = null)
    {
        // validation for constraint: string
        if (!is_null($itemGnlAttributeCode1) && !is_string($itemGnlAttributeCode1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemGnlAttributeCode1, true), gettype($itemGnlAttributeCode1)), __LINE__);
        }
        $this->ItemGnlAttributeCode1 = $itemGnlAttributeCode1;
        return $this;
    }

    /**
     * Get ItemGnlAttributeCode2 value
     * @return string|null
     */
    public function getItemGnlAttributeCode2()
    {
        return $this->ItemGnlAttributeCode2;
    }

    /**
     * Set ItemGnlAttributeCode2 value
     * @param string $itemGnlAttributeCode2
     * @return TransactionalDetailFields
     */
    public function setItemGnlAttributeCode2($itemGnlAttributeCode2 = null)
    {
        // validation for constraint: string
        if (!is_null($itemGnlAttributeCode2) && !is_string($itemGnlAttributeCode2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemGnlAttributeCode2, true), gettype($itemGnlAttributeCode2)), __LINE__);
        }
        $this->ItemGnlAttributeCode2 = $itemGnlAttributeCode2;
        return $this;
    }

    /**
     * Get ItemGnlAttributeCode3 value
     * @return string|null
     */
    public function getItemGnlAttributeCode3()
    {
        return $this->ItemGnlAttributeCode3;
    }

    /**
     * Set ItemGnlAttributeCode3 value
     * @param string $itemGnlAttributeCode3
     * @return TransactionalDetailFields
     */
    public function setItemGnlAttributeCode3($itemGnlAttributeCode3 = null)
    {
        // validation for constraint: string
        if (!is_null($itemGnlAttributeCode3) && !is_string($itemGnlAttributeCode3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemGnlAttributeCode3, true), gettype($itemGnlAttributeCode3)), __LINE__);
        }
        $this->ItemGnlAttributeCode3 = $itemGnlAttributeCode3;
        return $this;
    }

    /**
     * Get ReferanceDocNo value
     * @return string|null
     */
    public function getReferanceDocNo()
    {
        return $this->ReferanceDocNo;
    }

    /**
     * Set ReferanceDocNo value
     * @param string $referanceDocNo
     * @return TransactionalDetailFields
     */
    public function setReferanceDocNo($referanceDocNo = null)
    {
        // validation for constraint: string
        if (!is_null($referanceDocNo) && !is_string($referanceDocNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referanceDocNo, true), gettype($referanceDocNo)), __LINE__);
        }
        $this->ReferanceDocNo = $referanceDocNo;
        return $this;
    }

    /**
     * Get LotCode value
     * @return string|null
     */
    public function getLotCode()
    {
        return $this->LotCode;
    }

    /**
     * Set LotCode value
     * @param string $lotCode
     * @return TransactionalDetailFields
     */
    public function setLotCode($lotCode = null)
    {
        // validation for constraint: string
        if (!is_null($lotCode) && !is_string($lotCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lotCode, true), gettype($lotCode)), __LINE__);
        }
        $this->LotCode = $lotCode;
        return $this;
    }

    /**
     * Get QualityCode value
     * @return string|null
     */
    public function getQualityCode()
    {
        return $this->QualityCode;
    }

    /**
     * Set QualityCode value
     * @param string $qualityCode
     * @return TransactionalDetailFields
     */
    public function setQualityCode($qualityCode = null)
    {
        // validation for constraint: string
        if (!is_null($qualityCode) && !is_string($qualityCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualityCode, true), gettype($qualityCode)), __LINE__);
        }
        $this->QualityCode = $qualityCode;
        return $this;
    }

    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }

    /**
     * Set Barcode value
     * @param string $barcode
     * @return TransactionalDetailFields
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }

    /**
     * Get ItemNameManual value
     * @return string|null
     */
    public function getItemNameManual()
    {
        return $this->ItemNameManual;
    }

    /**
     * Set ItemNameManual value
     * @param string $itemNameManual
     * @return TransactionalDetailFields
     */
    public function setItemNameManual($itemNameManual = null)
    {
        // validation for constraint: string
        if (!is_null($itemNameManual) && !is_string($itemNameManual)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemNameManual, true), gettype($itemNameManual)), __LINE__);
        }
        $this->ItemNameManual = $itemNameManual;
        return $this;
    }
}
