<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Token StructType
 * @subpackage Structs
 */
class Token extends AbstractStructBase
{
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BranchId;
    /**
     * The CoId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CoId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The BranchCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchCode;
    /**
     * The BranchDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchDesc;
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceId;

    /**
     * Constructor method for Token
     * @param int $branchId
     * @param int $coId
     * @param string $userName
     * @param string $password
     * @param string $branchCode
     * @param string $branchDesc
     * @param string $deviceId
     * @uses Token::setBranchId()
     * @uses Token::setCoId()
     * @uses Token::setUserName()
     * @uses Token::setPassword()
     * @uses Token::setBranchCode()
     * @uses Token::setBranchDesc()
     * @uses Token::setDeviceId()
     */
    public function __construct($branchId = null, $coId = null, $userName = null, $password = null, $branchCode = null, $branchDesc = null, $deviceId = null)
    {
        $this
            ->setBranchId($branchId)
            ->setCoId($coId)
            ->setUserName($userName)
            ->setPassword($password)
            ->setBranchCode($branchCode)
            ->setBranchDesc($branchDesc)
            ->setDeviceId($deviceId);
    }

    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }

    /**
     * Set BranchId value
     * @param int $branchId
     * @return Token
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }

    /**
     * Get CoId value
     * @return int
     */
    public function getCoId()
    {
        return $this->CoId;
    }

    /**
     * Set CoId value
     * @param int $coId
     * @return Token
     */
    public function setCoId($coId = null)
    {
        // validation for constraint: int
        if (!is_null($coId) && !(is_int($coId) || ctype_digit($coId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coId, true), gettype($coId)), __LINE__);
        }
        $this->CoId = $coId;
        return $this;
    }

    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }

    /**
     * Set UserName value
     * @param string $userName
     * @return Token
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }

    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }

    /**
     * Set Password value
     * @param string $password
     * @return Token
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }

    /**
     * Get BranchCode value
     * @return string|null
     */
    public function getBranchCode()
    {
        return $this->BranchCode;
    }

    /**
     * Set BranchCode value
     * @param string $branchCode
     * @return Token
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchCode, true), gettype($branchCode)), __LINE__);
        }
        $this->BranchCode = $branchCode;
        return $this;
    }

    /**
     * Get BranchDesc value
     * @return string|null
     */
    public function getBranchDesc()
    {
        return $this->BranchDesc;
    }

    /**
     * Set BranchDesc value
     * @param string $branchDesc
     * @return Token
     */
    public function setBranchDesc($branchDesc = null)
    {
        // validation for constraint: string
        if (!is_null($branchDesc) && !is_string($branchDesc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchDesc, true), gettype($branchDesc)), __LINE__);
        }
        $this->BranchDesc = $branchDesc;
        return $this;
    }

    /**
     * Get DeviceId value
     * @return string|null
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }

    /**
     * Set DeviceId value
     * @param string $deviceId
     * @return Token
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: string
        if (!is_null($deviceId) && !is_string($deviceId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
}
