<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRequestOfOfferDef StructType
 * @subpackage Structs
 */
class ServiceRequestOfOfferDef extends AbstractStructBase
{
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageSize;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Token
     */
    public $Token;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OfferDef
     */
    public $Value;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Attachment;

    /**
     * Constructor method for ServiceRequestOfOfferDef
     * @param int $pageIndex
     * @param int $pageSize
     * @param Token $token
     * @param OfferDef $value
     * @param string $attachment
     * @uses ServiceRequestOfOfferDef::setPageIndex()
     * @uses ServiceRequestOfOfferDef::setPageSize()
     * @uses ServiceRequestOfOfferDef::setToken()
     * @uses ServiceRequestOfOfferDef::setValue()
     * @uses ServiceRequestOfOfferDef::setAttachment()
     */
    public function __construct($pageIndex = null, $pageSize = null, Token $token = null, OfferDef $value = null, $attachment = null)
    {
        $this
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize)
            ->setToken($token)
            ->setValue($value)
            ->setAttachment($attachment);
    }

    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }

    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return ServiceRequestOfOfferDef
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }

    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }

    /**
     * Set PageSize value
     * @param int $pageSize
     * @return ServiceRequestOfOfferDef
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }

    /**
     * Get Token value
     * @return Token|null
     */
    public function getToken()
    {
        return $this->Token;
    }

    /**
     * Set Token value
     * @param Token $token
     * @return ServiceRequestOfOfferDef
     */
    public function setToken(Token $token = null)
    {
        $this->Token = $token;
        return $this;
    }

    /**
     * Get Value value
     * @return OfferDef|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param OfferDef $value
     * @return ServiceRequestOfOfferDef
     */
    public function setValue(OfferDef $value = null)
    {
        $this->Value = $value;
        return $this;
    }

    /**
     * Get Attachment value
     * @return string|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }

    /**
     * Set Attachment value
     * @param string $attachment
     * @return ServiceRequestOfOfferDef
     */
    public function setAttachment($attachment = null)
    {
        // validation for constraint: string
        if (!is_null($attachment) && !is_string($attachment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachment, true), gettype($attachment)), __LINE__);
        }
        $this->Attachment = $attachment;
        return $this;
    }
}
