<?php

namespace Gek\UyumBahce\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailTransportType StructType
 * @subpackage Structs
 */
class RailTransportType extends AbstractStructBase
{
    /**
     * The TrainID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TrainID
     * @var TrainIDType
     */
    public $TrainID;
    /**
     * The RailCarID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:RailCarID
     * @var RailCarIDType
     */
    public $RailCarID;

    /**
     * Constructor method for RailTransportType
     * @param TrainIDType $trainID
     * @param RailCarIDType $railCarID
     * @uses RailTransportType::setTrainID()
     * @uses RailTransportType::setRailCarID()
     */
    public function __construct(TrainIDType $trainID = null, RailCarIDType $railCarID = null)
    {
        $this
            ->setTrainID($trainID)
            ->setRailCarID($railCarID);
    }

    /**
     * Get TrainID value
     * @return TrainIDType|null
     */
    public function getTrainID()
    {
        return $this->TrainID;
    }

    /**
     * Set TrainID value
     * @param TrainIDType $trainID
     * @return RailTransportType
     */
    public function setTrainID(TrainIDType $trainID = null)
    {
        $this->TrainID = $trainID;
        return $this;
    }

    /**
     * Get RailCarID value
     * @return RailCarIDType|null
     */
    public function getRailCarID()
    {
        return $this->RailCarID;
    }

    /**
     * Set RailCarID value
     * @param RailCarIDType $railCarID
     * @return RailTransportType
     */
    public function setRailCarID(RailCarIDType $railCarID = null)
    {
        $this->RailCarID = $railCarID;
        return $this;
    }
}
