<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;

/**
 * This class stands for OrderDetailDef StructType
 * @subpackage Structs
 */
class OrderDetailDef extends TransactionalDetailFields
{
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The ExpenseId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ExpenseId;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeliveryDate;
    /**
     * The ShippingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ShippingDate;

    /**
     * Constructor method for OrderDetailDef
     * @param int $itemId
     * @param int $expenseId
     * @param string $deliveryDate
     * @param string $shippingDate
     * @uses OrderDetailDef::setItemId()
     * @uses OrderDetailDef::setExpenseId()
     * @uses OrderDetailDef::setDeliveryDate()
     * @uses OrderDetailDef::setShippingDate()
     */
    public function __construct($itemId = null, $expenseId = null, $deliveryDate = null, $shippingDate = null)
    {
        parent::__construct();
        $this
            ->setItemId($itemId)
            ->setExpenseId($expenseId)
            ->setDeliveryDate($deliveryDate)
            ->setShippingDate($shippingDate);
    }

    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }

    /**
     * Set ItemId value
     * @param int $itemId
     * @return OrderDetailDef
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }

    /**
     * Get ExpenseId value
     * @return int
     */
    public function getExpenseId()
    {
        return $this->ExpenseId;
    }

    /**
     * Set ExpenseId value
     * @param int $expenseId
     * @return OrderDetailDef
     */
    public function setExpenseId($expenseId = null)
    {
        // validation for constraint: int
        if (!is_null($expenseId) && !(is_int($expenseId) || ctype_digit($expenseId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expenseId, true), gettype($expenseId)), __LINE__);
        }
        $this->ExpenseId = $expenseId;
        return $this;
    }

    /**
     * Get DeliveryDate value
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }

    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return OrderDetailDef
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate) && !($deliveryDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        if ($deliveryDate instanceof GekDateTime) {
            $deliveryDate = $deliveryDate->toServiceString();
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }

    /**
     * Get ShippingDate value
     * @return string
     */
    public function getShippingDate()
    {
        return $this->ShippingDate;
    }

    /**
     * Set ShippingDate value
     * @param string $shippingDate
     * @return OrderDetailDef
     */
    public function setShippingDate($shippingDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDate) && !is_string($shippingDate) && !($shippingDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingDate, true), gettype($shippingDate)), __LINE__);
        }
        if ($shippingDate instanceof GekDateTime) {
            $shippingDate = $shippingDate->toServiceString();
        }
        $this->ShippingDate = $shippingDate;
        return $this;
    }
}
