<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\ArrayType\ArrayOfOfferDetailDef;
use InvalidArgumentException;

/**
 * This class stands for OfferDef StructType
 * @subpackage Structs
 */
class OfferDef extends TransactionalMasterFields
{
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EntityId;
    /**
     * The EntityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityCode;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfOfferDetailDef
     */
    public $Details;

    /**
     * Constructor method for OfferDef
     * @param int $entityId
     * @param string $entityCode
     * @param ArrayOfOfferDetailDef $details
     * @uses OfferDef::setEntityId()
     * @uses OfferDef::setEntityCode()
     * @uses OfferDef::setDetails()
     */
    public function __construct($entityId = null, $entityCode = null, ArrayOfOfferDetailDef $details = null)
    {
        parent::__construct();
        $this
            ->setEntityId($entityId)
            ->setEntityCode($entityCode)
            ->setDetails($details);
    }

    /**
     * Get EntityId value
     * @return int
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }

    /**
     * Set EntityId value
     * @param int $entityId
     * @return OfferDef
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }

    /**
     * Get EntityCode value
     * @return string|null
     */
    public function getEntityCode()
    {
        return $this->EntityCode;
    }

    /**
     * Set EntityCode value
     * @param string $entityCode
     * @return OfferDef
     */
    public function setEntityCode($entityCode = null)
    {
        // validation for constraint: string
        if (!is_null($entityCode) && !is_string($entityCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityCode, true), gettype($entityCode)), __LINE__);
        }
        $this->EntityCode = $entityCode;
        return $this;
    }

    /**
     * Get Details value
     * @return ArrayOfOfferDetailDef|null
     */
    public function getDetails()
    {
        return $this->Details;
    }

    /**
     * Set Details value
     * @param ArrayOfOfferDetailDef $details
     * @return OfferDef
     */
    public function setDetails(ArrayOfOfferDetailDef $details = null)
    {
        $this->Details = $details;
        return $this;
    }
}
