<?php

namespace Gek\UyumBahce\StructType;

use DOMDocument;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class ObjectType extends AbstractStructBase
{
    /**
     * The any
     * @var DOMDocument
     */
    public $any;
    /**
     * The Encoding
     * @var string
     */
    public $Encoding;
    /**
     * The MimeType
     * @var string
     */
    public $MimeType;
    /**
     * The Id
     * @var string
     */
    public $Id;

    /**
     * Constructor method for ObjectType
     * @param DOMDocument $any
     * @param string $encoding
     * @param string $mimeType
     * @param string $id
     * @uses ObjectType::setAny()
     * @uses ObjectType::setEncoding()
     * @uses ObjectType::setMimeType()
     * @uses ObjectType::setId()
     */
    public function __construct(DOMDocument $any = null, $encoding = null, $mimeType = null, $id = null)
    {
        $this
            ->setAny($any)
            ->setEncoding($encoding)
            ->setMimeType($mimeType)
            ->setId($id);
    }

    /**
     * Get any value
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return DOMDocument|null
     * @uses \DOMDocument::loadXML()
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }

    /**
     * Set any value
     * @param DOMDocument $any
     * @return ObjectType
     * @uses \DOMNode::item()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     */
    public function setAny(DOMDocument $any = null)
    {
        $this->any = ($any instanceof DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }

    /**
     * Get Encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->Encoding;
    }

    /**
     * Set Encoding value
     * @param string $encoding
     * @return ObjectType
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: string
        if (!is_null($encoding) && !is_string($encoding)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encoding, true), gettype($encoding)), __LINE__);
        }
        $this->Encoding = $encoding;
        return $this;
    }

    /**
     * Get MimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->MimeType;
    }

    /**
     * Set MimeType value
     * @param string $mimeType
     * @return ObjectType
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeType, true), gettype($mimeType)), __LINE__);
        }
        $this->MimeType = $mimeType;
        return $this;
    }

    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param string $id
     * @return ObjectType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
