<?php

namespace Gek\UyumBahce\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonetaryTotalType StructType
 * @subpackage Structs
 */
class MonetaryTotalType extends AbstractStructBase
{
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LineExtensionAmount
     * @var LineExtensionAmountType
     */
    public $LineExtensionAmount;
    /**
     * The TaxExclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TaxExclusiveAmount
     * @var TaxExclusiveAmountType
     */
    public $TaxExclusiveAmount;
    /**
     * The TaxInclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TaxInclusiveAmount
     * @var TaxInclusiveAmountType
     */
    public $TaxInclusiveAmount;
    /**
     * The AllowanceTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:AllowanceTotalAmount
     * @var AllowanceTotalAmountType
     */
    public $AllowanceTotalAmount;
    /**
     * The ChargeTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ChargeTotalAmount
     * @var ChargeTotalAmountType
     */
    public $ChargeTotalAmount;
    /**
     * The PayableRoundingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PayableRoundingAmount
     * @var PayableRoundingAmountType
     */
    public $PayableRoundingAmount;
    /**
     * The PayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PayableAmount
     * @var PayableAmountType
     */
    public $PayableAmount;

    /**
     * Constructor method for MonetaryTotalType
     * @param LineExtensionAmountType $lineExtensionAmount
     * @param TaxExclusiveAmountType $taxExclusiveAmount
     * @param TaxInclusiveAmountType $taxInclusiveAmount
     * @param AllowanceTotalAmountType $allowanceTotalAmount
     * @param ChargeTotalAmountType $chargeTotalAmount
     * @param PayableRoundingAmountType $payableRoundingAmount
     * @param PayableAmountType $payableAmount
     * @uses MonetaryTotalType::setLineExtensionAmount()
     * @uses MonetaryTotalType::setTaxExclusiveAmount()
     * @uses MonetaryTotalType::setTaxInclusiveAmount()
     * @uses MonetaryTotalType::setAllowanceTotalAmount()
     * @uses MonetaryTotalType::setChargeTotalAmount()
     * @uses MonetaryTotalType::setPayableRoundingAmount()
     * @uses MonetaryTotalType::setPayableAmount()
     */
    public function __construct(LineExtensionAmountType $lineExtensionAmount = null, TaxExclusiveAmountType $taxExclusiveAmount = null, TaxInclusiveAmountType $taxInclusiveAmount = null, AllowanceTotalAmountType $allowanceTotalAmount = null, ChargeTotalAmountType $chargeTotalAmount = null, PayableRoundingAmountType $payableRoundingAmount = null, PayableAmountType $payableAmount = null)
    {
        $this
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setTaxExclusiveAmount($taxExclusiveAmount)
            ->setTaxInclusiveAmount($taxInclusiveAmount)
            ->setAllowanceTotalAmount($allowanceTotalAmount)
            ->setChargeTotalAmount($chargeTotalAmount)
            ->setPayableRoundingAmount($payableRoundingAmount)
            ->setPayableAmount($payableAmount);
    }

    /**
     * Get LineExtensionAmount value
     * @return LineExtensionAmountType|null
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }

    /**
     * Set LineExtensionAmount value
     * @param LineExtensionAmountType $lineExtensionAmount
     * @return MonetaryTotalType
     */
    public function setLineExtensionAmount(LineExtensionAmountType $lineExtensionAmount = null)
    {
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }

    /**
     * Get TaxExclusiveAmount value
     * @return TaxExclusiveAmountType|null
     */
    public function getTaxExclusiveAmount()
    {
        return $this->TaxExclusiveAmount;
    }

    /**
     * Set TaxExclusiveAmount value
     * @param TaxExclusiveAmountType $taxExclusiveAmount
     * @return MonetaryTotalType
     */
    public function setTaxExclusiveAmount(TaxExclusiveAmountType $taxExclusiveAmount = null)
    {
        $this->TaxExclusiveAmount = $taxExclusiveAmount;
        return $this;
    }

    /**
     * Get TaxInclusiveAmount value
     * @return TaxInclusiveAmountType|null
     */
    public function getTaxInclusiveAmount()
    {
        return $this->TaxInclusiveAmount;
    }

    /**
     * Set TaxInclusiveAmount value
     * @param TaxInclusiveAmountType $taxInclusiveAmount
     * @return MonetaryTotalType
     */
    public function setTaxInclusiveAmount(TaxInclusiveAmountType $taxInclusiveAmount = null)
    {
        $this->TaxInclusiveAmount = $taxInclusiveAmount;
        return $this;
    }

    /**
     * Get AllowanceTotalAmount value
     * @return AllowanceTotalAmountType|null
     */
    public function getAllowanceTotalAmount()
    {
        return $this->AllowanceTotalAmount;
    }

    /**
     * Set AllowanceTotalAmount value
     * @param AllowanceTotalAmountType $allowanceTotalAmount
     * @return MonetaryTotalType
     */
    public function setAllowanceTotalAmount(AllowanceTotalAmountType $allowanceTotalAmount = null)
    {
        $this->AllowanceTotalAmount = $allowanceTotalAmount;
        return $this;
    }

    /**
     * Get ChargeTotalAmount value
     * @return ChargeTotalAmountType|null
     */
    public function getChargeTotalAmount()
    {
        return $this->ChargeTotalAmount;
    }

    /**
     * Set ChargeTotalAmount value
     * @param ChargeTotalAmountType $chargeTotalAmount
     * @return MonetaryTotalType
     */
    public function setChargeTotalAmount(ChargeTotalAmountType $chargeTotalAmount = null)
    {
        $this->ChargeTotalAmount = $chargeTotalAmount;
        return $this;
    }

    /**
     * Get PayableRoundingAmount value
     * @return PayableRoundingAmountType|null
     */
    public function getPayableRoundingAmount()
    {
        return $this->PayableRoundingAmount;
    }

    /**
     * Set PayableRoundingAmount value
     * @param PayableRoundingAmountType $payableRoundingAmount
     * @return MonetaryTotalType
     */
    public function setPayableRoundingAmount(PayableRoundingAmountType $payableRoundingAmount = null)
    {
        $this->PayableRoundingAmount = $payableRoundingAmount;
        return $this;
    }

    /**
     * Get PayableAmount value
     * @return PayableAmountType|null
     */
    public function getPayableAmount()
    {
        return $this->PayableAmount;
    }

    /**
     * Set PayableAmount value
     * @param PayableAmountType $payableAmount
     * @return MonetaryTotalType
     */
    public function setPayableAmount(PayableAmountType $payableAmount = null)
    {
        $this->PayableAmount = $payableAmount;
        return $this;
    }
}
