<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaritimeTransportType StructType
 * @subpackage Structs
 */
class MaritimeTransportType extends AbstractStructBase
{
    /**
     * The VesselID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:VesselID
     * @var VesselIDType
     */
    public $VesselID;
    /**
     * The VesselName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:VesselName
     * @var VesselNameType
     */
    public $VesselName;
    /**
     * The RadioCallSignID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:RadioCallSignID
     * @var RadioCallSignIDType
     */
    public $RadioCallSignID;
    /**
     * The ShipsRequirements
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:ShipsRequirements
     * @var ShipsRequirementsType[]
     */
    public $ShipsRequirements;
    /**
     * The GrossTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:GrossTonnageMeasure
     * @var GrossTonnageMeasureType
     */
    public $GrossTonnageMeasure;
    /**
     * The NetTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NetTonnageMeasure
     * @var NetTonnageMeasureType
     */
    public $NetTonnageMeasure;
    /**
     * The RegistryCertificateDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocumentReferenceType
     */
    public $RegistryCertificateDocumentReference;
    /**
     * The RegistryPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LocationType
     */
    public $RegistryPortLocation;

    /**
     * Constructor method for MaritimeTransportType
     * @param VesselIDType $vesselID
     * @param VesselNameType $vesselName
     * @param RadioCallSignIDType $radioCallSignID
     * @param ShipsRequirementsType[] $shipsRequirements
     * @param GrossTonnageMeasureType $grossTonnageMeasure
     * @param NetTonnageMeasureType $netTonnageMeasure
     * @param DocumentReferenceType $registryCertificateDocumentReference
     * @param LocationType $registryPortLocation
     * @uses MaritimeTransportType::setVesselID()
     * @uses MaritimeTransportType::setVesselName()
     * @uses MaritimeTransportType::setRadioCallSignID()
     * @uses MaritimeTransportType::setShipsRequirements()
     * @uses MaritimeTransportType::setGrossTonnageMeasure()
     * @uses MaritimeTransportType::setNetTonnageMeasure()
     * @uses MaritimeTransportType::setRegistryCertificateDocumentReference()
     * @uses MaritimeTransportType::setRegistryPortLocation()
     */
    public function __construct(VesselIDType $vesselID = null, VesselNameType $vesselName = null, RadioCallSignIDType $radioCallSignID = null, array $shipsRequirements = array(), GrossTonnageMeasureType $grossTonnageMeasure = null, NetTonnageMeasureType $netTonnageMeasure = null, DocumentReferenceType $registryCertificateDocumentReference = null, LocationType $registryPortLocation = null)
    {
        $this
            ->setVesselID($vesselID)
            ->setVesselName($vesselName)
            ->setRadioCallSignID($radioCallSignID)
            ->setShipsRequirements($shipsRequirements)
            ->setGrossTonnageMeasure($grossTonnageMeasure)
            ->setNetTonnageMeasure($netTonnageMeasure)
            ->setRegistryCertificateDocumentReference($registryCertificateDocumentReference)
            ->setRegistryPortLocation($registryPortLocation);
    }

    /**
     * Get VesselID value
     * @return VesselIDType|null
     */
    public function getVesselID()
    {
        return $this->VesselID;
    }

    /**
     * Set VesselID value
     * @param VesselIDType $vesselID
     * @return MaritimeTransportType
     */
    public function setVesselID(VesselIDType $vesselID = null)
    {
        $this->VesselID = $vesselID;
        return $this;
    }

    /**
     * Get VesselName value
     * @return VesselNameType|null
     */
    public function getVesselName()
    {
        return $this->VesselName;
    }

    /**
     * Set VesselName value
     * @param VesselNameType $vesselName
     * @return MaritimeTransportType
     */
    public function setVesselName(VesselNameType $vesselName = null)
    {
        $this->VesselName = $vesselName;
        return $this;
    }

    /**
     * Get RadioCallSignID value
     * @return RadioCallSignIDType|null
     */
    public function getRadioCallSignID()
    {
        return $this->RadioCallSignID;
    }

    /**
     * Set RadioCallSignID value
     * @param RadioCallSignIDType $radioCallSignID
     * @return MaritimeTransportType
     */
    public function setRadioCallSignID(RadioCallSignIDType $radioCallSignID = null)
    {
        $this->RadioCallSignID = $radioCallSignID;
        return $this;
    }

    /**
     * Get ShipsRequirements value
     * @return ShipsRequirementsType[]|null
     */
    public function getShipsRequirements()
    {
        return $this->ShipsRequirements;
    }

    /**
     * This method is responsible for validating the values passed to the setShipsRequirements method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipsRequirements method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipsRequirementsForArrayConstraintsFromSetShipsRequirements(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $maritimeTransportTypeShipsRequirementsItem) {
            // validation for constraint: itemType
            if (!$maritimeTransportTypeShipsRequirementsItem instanceof ShipsRequirementsType) {
                $invalidValues[] = is_object($maritimeTransportTypeShipsRequirementsItem) ? get_class($maritimeTransportTypeShipsRequirementsItem) : sprintf('%s(%s)', gettype($maritimeTransportTypeShipsRequirementsItem), var_export($maritimeTransportTypeShipsRequirementsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipsRequirements property can only contain items of type \Gek\UyumBahce\StructType\ShipsRequirementsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ShipsRequirements value
     * @param ShipsRequirementsType[] $shipsRequirements
     * @return MaritimeTransportType
     * @throws InvalidArgumentException
     */
    public function setShipsRequirements(array $shipsRequirements = array())
    {
        // validation for constraint: array
        if ('' !== ($shipsRequirementsArrayErrorMessage = self::validateShipsRequirementsForArrayConstraintsFromSetShipsRequirements($shipsRequirements))) {
            throw new InvalidArgumentException($shipsRequirementsArrayErrorMessage, __LINE__);
        }
        $this->ShipsRequirements = $shipsRequirements;
        return $this;
    }

    /**
     * Add item to ShipsRequirements value
     * @param ShipsRequirementsType $item
     * @return MaritimeTransportType
     * @throws InvalidArgumentException
     */
    public function addToShipsRequirements(ShipsRequirementsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ShipsRequirementsType) {
            throw new InvalidArgumentException(sprintf('The ShipsRequirements property can only contain items of type \Gek\UyumBahce\StructType\ShipsRequirementsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipsRequirements[] = $item;
        return $this;
    }

    /**
     * Get GrossTonnageMeasure value
     * @return GrossTonnageMeasureType|null
     */
    public function getGrossTonnageMeasure()
    {
        return $this->GrossTonnageMeasure;
    }

    /**
     * Set GrossTonnageMeasure value
     * @param GrossTonnageMeasureType $grossTonnageMeasure
     * @return MaritimeTransportType
     */
    public function setGrossTonnageMeasure(GrossTonnageMeasureType $grossTonnageMeasure = null)
    {
        $this->GrossTonnageMeasure = $grossTonnageMeasure;
        return $this;
    }

    /**
     * Get NetTonnageMeasure value
     * @return NetTonnageMeasureType|null
     */
    public function getNetTonnageMeasure()
    {
        return $this->NetTonnageMeasure;
    }

    /**
     * Set NetTonnageMeasure value
     * @param NetTonnageMeasureType $netTonnageMeasure
     * @return MaritimeTransportType
     */
    public function setNetTonnageMeasure(NetTonnageMeasureType $netTonnageMeasure = null)
    {
        $this->NetTonnageMeasure = $netTonnageMeasure;
        return $this;
    }

    /**
     * Get RegistryCertificateDocumentReference value
     * @return DocumentReferenceType|null
     */
    public function getRegistryCertificateDocumentReference()
    {
        return $this->RegistryCertificateDocumentReference;
    }

    /**
     * Set RegistryCertificateDocumentReference value
     * @param DocumentReferenceType $registryCertificateDocumentReference
     * @return MaritimeTransportType
     */
    public function setRegistryCertificateDocumentReference(DocumentReferenceType $registryCertificateDocumentReference = null)
    {
        $this->RegistryCertificateDocumentReference = $registryCertificateDocumentReference;
        return $this;
    }

    /**
     * Get RegistryPortLocation value
     * @return LocationType|null
     */
    public function getRegistryPortLocation()
    {
        return $this->RegistryPortLocation;
    }

    /**
     * Set RegistryPortLocation value
     * @param LocationType $registryPortLocation
     * @return MaritimeTransportType
     */
    public function setRegistryPortLocation(LocationType $registryPortLocation = null)
    {
        $this->RegistryPortLocation = $registryPortLocation;
        return $this;
    }
}
