<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EDespatchDetails StructType
 * @subpackage Structs
 */
class EDespatchDetails extends AbstractStructBase
{
    /**
     * The EDespatchDId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EDespatchDId;
    /**
     * The ReceivedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ReceivedQuantity;
    /**
     * The ShortQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ShortQuantity;
    /**
     * The RejectedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RejectedQuantity;
    /**
     * The OversupplyQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OversupplyQuantity;

    /**
     * Constructor method for EDespatchDetails
     * @param int $eDespatchDId
     * @param float $receivedQuantity
     * @param float $shortQuantity
     * @param float $rejectedQuantity
     * @param float $oversupplyQuantity
     * @uses EDespatchDetails::setEDespatchDId()
     * @uses EDespatchDetails::setReceivedQuantity()
     * @uses EDespatchDetails::setShortQuantity()
     * @uses EDespatchDetails::setRejectedQuantity()
     * @uses EDespatchDetails::setOversupplyQuantity()
     */
    public function __construct($eDespatchDId = null, $receivedQuantity = null, $shortQuantity = null, $rejectedQuantity = null, $oversupplyQuantity = null)
    {
        $this
            ->setEDespatchDId($eDespatchDId)
            ->setReceivedQuantity($receivedQuantity)
            ->setShortQuantity($shortQuantity)
            ->setRejectedQuantity($rejectedQuantity)
            ->setOversupplyQuantity($oversupplyQuantity);
    }

    /**
     * Get EDespatchDId value
     * @return int
     */
    public function getEDespatchDId()
    {
        return $this->EDespatchDId;
    }

    /**
     * Set EDespatchDId value
     * @param int $eDespatchDId
     * @return EDespatchDetails
     */
    public function setEDespatchDId($eDespatchDId = null)
    {
        // validation for constraint: int
        if (!is_null($eDespatchDId) && !(is_int($eDespatchDId) || ctype_digit($eDespatchDId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eDespatchDId, true), gettype($eDespatchDId)), __LINE__);
        }
        $this->EDespatchDId = $eDespatchDId;
        return $this;
    }

    /**
     * Get ReceivedQuantity value
     * @return float
     */
    public function getReceivedQuantity()
    {
        return $this->ReceivedQuantity;
    }

    /**
     * Set ReceivedQuantity value
     * @param float $receivedQuantity
     * @return EDespatchDetails
     */
    public function setReceivedQuantity($receivedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($receivedQuantity) && !(is_float($receivedQuantity) || is_numeric($receivedQuantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receivedQuantity, true), gettype($receivedQuantity)), __LINE__);
        }
        $this->ReceivedQuantity = $receivedQuantity;
        return $this;
    }

    /**
     * Get ShortQuantity value
     * @return float
     */
    public function getShortQuantity()
    {
        return $this->ShortQuantity;
    }

    /**
     * Set ShortQuantity value
     * @param float $shortQuantity
     * @return EDespatchDetails
     */
    public function setShortQuantity($shortQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($shortQuantity) && !(is_float($shortQuantity) || is_numeric($shortQuantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shortQuantity, true), gettype($shortQuantity)), __LINE__);
        }
        $this->ShortQuantity = $shortQuantity;
        return $this;
    }

    /**
     * Get RejectedQuantity value
     * @return float
     */
    public function getRejectedQuantity()
    {
        return $this->RejectedQuantity;
    }

    /**
     * Set RejectedQuantity value
     * @param float $rejectedQuantity
     * @return EDespatchDetails
     */
    public function setRejectedQuantity($rejectedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($rejectedQuantity) && !(is_float($rejectedQuantity) || is_numeric($rejectedQuantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rejectedQuantity, true), gettype($rejectedQuantity)), __LINE__);
        }
        $this->RejectedQuantity = $rejectedQuantity;
        return $this;
    }

    /**
     * Get OversupplyQuantity value
     * @return float
     */
    public function getOversupplyQuantity()
    {
        return $this->OversupplyQuantity;
    }

    /**
     * Set OversupplyQuantity value
     * @param float $oversupplyQuantity
     * @return EDespatchDetails
     */
    public function setOversupplyQuantity($oversupplyQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($oversupplyQuantity) && !(is_float($oversupplyQuantity) || is_numeric($oversupplyQuantity))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($oversupplyQuantity, true), gettype($oversupplyQuantity)), __LINE__);
        }
        $this->OversupplyQuantity = $oversupplyQuantity;
        return $this;
    }
}
