<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\ArrayType\ArrayOfAccGainLossDetailDef;
use Gek\UyumBahce\EnumType\GainLoss;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccGainLossMDef StructType
 * @subpackage Structs
 */
class AccGainLossMDef extends AbstractStructBase
{
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CreateUserId;
    /**
     * The GainLoss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GainLoss;
    /**
     * The ESMMStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ESMMStatus;
    /**
     * The CoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CoCode;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfAccGainLossDetailDef
     */
    public $Details;
    /**
     * The Note1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note1;

    /**
     * Constructor method for AccGainLossMDef
     * @param int $createUserId
     * @param string $gainLoss
     * @param int $eSMMStatus
     * @param string $coCode
     * @param ArrayOfAccGainLossDetailDef $details
     * @param string $note1
     * @uses AccGainLossMDef::setCreateUserId()
     * @uses AccGainLossMDef::setGainLoss()
     * @uses AccGainLossMDef::setESMMStatus()
     * @uses AccGainLossMDef::setCoCode()
     * @uses AccGainLossMDef::setDetails()
     * @uses AccGainLossMDef::setNote1()
     */
    public function __construct($createUserId = null, $gainLoss = null, $eSMMStatus = null, $coCode = null, ArrayOfAccGainLossDetailDef $details = null, $note1 = null)
    {
        $this
            ->setCreateUserId($createUserId)
            ->setGainLoss($gainLoss)
            ->setESMMStatus($eSMMStatus)
            ->setCoCode($coCode)
            ->setDetails($details)
            ->setNote1($note1);
    }

    /**
     * Get CreateUserId value
     * @return int
     */
    public function getCreateUserId()
    {
        return $this->CreateUserId;
    }

    /**
     * Set CreateUserId value
     * @param int $createUserId
     * @return AccGainLossMDef
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: int
        if (!is_null($createUserId) && !(is_int($createUserId) || ctype_digit($createUserId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        $this->CreateUserId = $createUserId;
        return $this;
    }

    /**
     * Get GainLoss value
     * @return string
     */
    public function getGainLoss()
    {
        return $this->GainLoss;
    }

    /**
     * Set GainLoss value
     * @param string $gainLoss
     * @return AccGainLossMDef
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\GainLoss::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\GainLoss::valueIsValid()
     */
    public function setGainLoss($gainLoss = null)
    {
        // validation for constraint: enumeration
        if (!GainLoss::valueIsValid($gainLoss)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\GainLoss', is_array($gainLoss) ? implode(', ', $gainLoss) : var_export($gainLoss, true), implode(', ', GainLoss::getValidValues())), __LINE__);
        }
        $this->GainLoss = $gainLoss;
        return $this;
    }

    /**
     * Get ESMMStatus value
     * @return int
     */
    public function getESMMStatus()
    {
        return $this->ESMMStatus;
    }

    /**
     * Set ESMMStatus value
     * @param int $eSMMStatus
     * @return AccGainLossMDef
     */
    public function setESMMStatus($eSMMStatus = null)
    {
        // validation for constraint: int
        if (!is_null($eSMMStatus) && !(is_int($eSMMStatus) || ctype_digit($eSMMStatus))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eSMMStatus, true), gettype($eSMMStatus)), __LINE__);
        }
        $this->ESMMStatus = $eSMMStatus;
        return $this;
    }

    /**
     * Get CoCode value
     * @return string|null
     */
    public function getCoCode()
    {
        return $this->CoCode;
    }

    /**
     * Set CoCode value
     * @param string $coCode
     * @return AccGainLossMDef
     */
    public function setCoCode($coCode = null)
    {
        // validation for constraint: string
        if (!is_null($coCode) && !is_string($coCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coCode, true), gettype($coCode)), __LINE__);
        }
        $this->CoCode = $coCode;
        return $this;
    }

    /**
     * Get Details value
     * @return ArrayOfAccGainLossDetailDef|null
     */
    public function getDetails()
    {
        return $this->Details;
    }

    /**
     * Set Details value
     * @param ArrayOfAccGainLossDetailDef $details
     * @return AccGainLossMDef
     */
    public function setDetails(ArrayOfAccGainLossDetailDef $details = null)
    {
        $this->Details = $details;
        return $this;
    }

    /**
     * Get Note1 value
     * @return string|null
     */
    public function getNote1()
    {
        return $this->Note1;
    }

    /**
     * Set Note1 value
     * @param string $note1
     * @return AccGainLossMDef
     */
    public function setNote1($note1 = null)
    {
        // validation for constraint: string
        if (!is_null($note1) && !is_string($note1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note1, true), gettype($note1)), __LINE__);
        }
        $this->Note1 = $note1;
        return $this;
    }
}
