<?php

namespace Gek\UyumBahce\ArrayType;

use Gek\UyumBahce\StructType\OrderDetailDef;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderDetailDef ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderDetailDef extends AbstractStructArrayBase
{
    /**
     * The OrderDetailDef
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var OrderDetailDef[]
     */
    public $OrderDetailDef;

    /**
     * Constructor method for ArrayOfOrderDetailDef
     * @param OrderDetailDef[] $orderDetailDef
     * @uses ArrayOfOrderDetailDef::setOrderDetailDef()
     */
    public function __construct(array $orderDetailDef = array())
    {
        $this
            ->setOrderDetailDef($orderDetailDef);
    }

    /**
     * Get OrderDetailDef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return OrderDetailDef[]|null
     */
    public function getOrderDetailDef()
    {
        return isset($this->OrderDetailDef) ? $this->OrderDetailDef : null;
    }

    /**
     * This method is responsible for validating the values passed to the setOrderDetailDef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderDetailDef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderDetailDefForArrayConstraintsFromSetOrderDetailDef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderDetailDefOrderDetailDefItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderDetailDefOrderDetailDefItem instanceof OrderDetailDef) {
                $invalidValues[] = is_object($arrayOfOrderDetailDefOrderDetailDefItem) ? get_class($arrayOfOrderDetailDefOrderDetailDefItem) : sprintf('%s(%s)', gettype($arrayOfOrderDetailDefOrderDetailDefItem), var_export($arrayOfOrderDetailDefOrderDetailDefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderDetailDef property can only contain items of type \Gek\UyumBahce\StructType\OrderDetailDef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set OrderDetailDef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param OrderDetailDef[] $orderDetailDef
     * @return ArrayOfOrderDetailDef
     * @throws InvalidArgumentException
     */
    public function setOrderDetailDef(array $orderDetailDef = array())
    {
        // validation for constraint: array
        if ('' !== ($orderDetailDefArrayErrorMessage = self::validateOrderDetailDefForArrayConstraintsFromSetOrderDetailDef($orderDetailDef))) {
            throw new InvalidArgumentException($orderDetailDefArrayErrorMessage, __LINE__);
        }
        if (is_null($orderDetailDef) || (is_array($orderDetailDef) && empty($orderDetailDef))) {
            unset($this->OrderDetailDef);
        } else {
            $this->OrderDetailDef = $orderDetailDef;
        }
        return $this;
    }

    /**
     * Add item to OrderDetailDef value
     * @param OrderDetailDef $item
     * @return ArrayOfOrderDetailDef
     * @throws InvalidArgumentException
     */
    public function addToOrderDetailDef(OrderDetailDef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof OrderDetailDef) {
            throw new InvalidArgumentException(sprintf('The OrderDetailDef property can only contain items of type \Gek\UyumBahce\StructType\OrderDetailDef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderDetailDef[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return OrderDetailDef|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return OrderDetailDef|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return OrderDetailDef|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return OrderDetailDef|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return OrderDetailDef|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string OrderDetailDef
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'OrderDetailDef';
    }
}
