<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\ArrayType\ArrayOfOrderDetailBarcode;
use Gek\UyumBahce\ArrayType\ArrayOfOrderDetailInfo;
use Gek\UyumBahce\ArrayType\ArrayOfReferralDetailInfo;

/**
 * This class stands for WaybillInfo StructType
 * @subpackage Structs
 */
class WaybillInfo extends SaveSevkIrsaliyeParam
{
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfReferralDetailInfo
     */
    public $Details;
    /**
     * The OrderDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfOrderDetailInfo
     */
    public $OrderDetails;
    /**
     * The BarcodeList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfOrderDetailBarcode
     */
    public $BarcodeList;

    /**
     * Constructor method for WaybillInfo
     * @param ArrayOfReferralDetailInfo $details
     * @param ArrayOfOrderDetailInfo $orderDetails
     * @param ArrayOfOrderDetailBarcode $barcodeList
     * @uses WaybillInfo::setDetails()
     * @uses WaybillInfo::setOrderDetails()
     * @uses WaybillInfo::setBarcodeList()
     */
    public function __construct(ArrayOfReferralDetailInfo $details = null, ArrayOfOrderDetailInfo $orderDetails = null, ArrayOfOrderDetailBarcode $barcodeList = null)
    {
        parent::__construct();
        $this
            ->setDetails($details)
            ->setOrderDetails($orderDetails)
            ->setBarcodeList($barcodeList);
    }

    /**
     * Get Details value
     * @return ArrayOfReferralDetailInfo|null
     */
    public function getDetails()
    {
        return $this->Details;
    }

    /**
     * Set Details value
     * @param ArrayOfReferralDetailInfo $details
     * @return WaybillInfo
     */
    public function setDetails(ArrayOfReferralDetailInfo $details = null)
    {
        $this->Details = $details;
        return $this;
    }

    /**
     * Get OrderDetails value
     * @return ArrayOfOrderDetailInfo|null
     */
    public function getOrderDetails()
    {
        return $this->OrderDetails;
    }

    /**
     * Set OrderDetails value
     * @param ArrayOfOrderDetailInfo $orderDetails
     * @return WaybillInfo
     */
    public function setOrderDetails(ArrayOfOrderDetailInfo $orderDetails = null)
    {
        $this->OrderDetails = $orderDetails;
        return $this;
    }

    /**
     * Get BarcodeList value
     * @return ArrayOfOrderDetailBarcode|null
     */
    public function getBarcodeList()
    {
        return $this->BarcodeList;
    }

    /**
     * Set BarcodeList value
     * @param ArrayOfOrderDetailBarcode $barcodeList
     * @return WaybillInfo
     */
    public function setBarcodeList(ArrayOfOrderDetailBarcode $barcodeList = null)
    {
        $this->BarcodeList = $barcodeList;
        return $this;
    }
}
