<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportMeansType StructType
 * @subpackage Structs
 */
class TransportMeansType extends AbstractStructBase
{
    /**
     * The JourneyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:JourneyID
     * @var JourneyIDType
     */
    public $JourneyID;
    /**
     * The RegistrationNationalityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:RegistrationNationalityID
     * @var RegistrationNationalityIDType
     */
    public $RegistrationNationalityID;
    /**
     * The RegistrationNationality
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:RegistrationNationality
     * @var RegistrationNationalityType[]
     */
    public $RegistrationNationality;
    /**
     * The DirectionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DirectionCode
     * @var DirectionCodeType
     */
    public $DirectionCode;
    /**
     * The TransportMeansTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransportMeansTypeCode
     * @var TransportMeansTypeCodeType
     */
    public $TransportMeansTypeCode;
    /**
     * The TradeServiceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TradeServiceCode
     * @var TradeServiceCodeType
     */
    public $TradeServiceCode;
    /**
     * The Stowage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var StowageType
     */
    public $Stowage;
    /**
     * The AirTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AirTransportType
     */
    public $AirTransport;
    /**
     * The RoadTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RoadTransportType
     */
    public $RoadTransport;
    /**
     * The RailTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RailTransportType
     */
    public $RailTransport;
    /**
     * The MaritimeTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var MaritimeTransportType
     */
    public $MaritimeTransport;
    /**
     * The OwnerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PartyType
     */
    public $OwnerParty;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DimensionType[]
     */
    public $MeasurementDimension;

    /**
     * Constructor method for TransportMeansType
     * @param JourneyIDType $journeyID
     * @param RegistrationNationalityIDType $registrationNationalityID
     * @param RegistrationNationalityType[] $registrationNationality
     * @param DirectionCodeType $directionCode
     * @param TransportMeansTypeCodeType $transportMeansTypeCode
     * @param TradeServiceCodeType $tradeServiceCode
     * @param StowageType $stowage
     * @param AirTransportType $airTransport
     * @param RoadTransportType $roadTransport
     * @param RailTransportType $railTransport
     * @param MaritimeTransportType $maritimeTransport
     * @param PartyType $ownerParty
     * @param DimensionType[] $measurementDimension
     * @uses TransportMeansType::setJourneyID()
     * @uses TransportMeansType::setRegistrationNationalityID()
     * @uses TransportMeansType::setRegistrationNationality()
     * @uses TransportMeansType::setDirectionCode()
     * @uses TransportMeansType::setTransportMeansTypeCode()
     * @uses TransportMeansType::setTradeServiceCode()
     * @uses TransportMeansType::setStowage()
     * @uses TransportMeansType::setAirTransport()
     * @uses TransportMeansType::setRoadTransport()
     * @uses TransportMeansType::setRailTransport()
     * @uses TransportMeansType::setMaritimeTransport()
     * @uses TransportMeansType::setOwnerParty()
     * @uses TransportMeansType::setMeasurementDimension()
     */
    public function __construct(JourneyIDType $journeyID = null, RegistrationNationalityIDType $registrationNationalityID = null, array $registrationNationality = array(), DirectionCodeType $directionCode = null, TransportMeansTypeCodeType $transportMeansTypeCode = null, TradeServiceCodeType $tradeServiceCode = null, StowageType $stowage = null, AirTransportType $airTransport = null, RoadTransportType $roadTransport = null, RailTransportType $railTransport = null, MaritimeTransportType $maritimeTransport = null, PartyType $ownerParty = null, array $measurementDimension = array())
    {
        $this
            ->setJourneyID($journeyID)
            ->setRegistrationNationalityID($registrationNationalityID)
            ->setRegistrationNationality($registrationNationality)
            ->setDirectionCode($directionCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode)
            ->setTradeServiceCode($tradeServiceCode)
            ->setStowage($stowage)
            ->setAirTransport($airTransport)
            ->setRoadTransport($roadTransport)
            ->setRailTransport($railTransport)
            ->setMaritimeTransport($maritimeTransport)
            ->setOwnerParty($ownerParty)
            ->setMeasurementDimension($measurementDimension);
    }

    /**
     * Get JourneyID value
     * @return JourneyIDType|null
     */
    public function getJourneyID()
    {
        return $this->JourneyID;
    }

    /**
     * Set JourneyID value
     * @param JourneyIDType $journeyID
     * @return TransportMeansType
     */
    public function setJourneyID(JourneyIDType $journeyID = null)
    {
        $this->JourneyID = $journeyID;
        return $this;
    }

    /**
     * Get RegistrationNationalityID value
     * @return RegistrationNationalityIDType|null
     */
    public function getRegistrationNationalityID()
    {
        return $this->RegistrationNationalityID;
    }

    /**
     * Set RegistrationNationalityID value
     * @param RegistrationNationalityIDType $registrationNationalityID
     * @return TransportMeansType
     */
    public function setRegistrationNationalityID(RegistrationNationalityIDType $registrationNationalityID = null)
    {
        $this->RegistrationNationalityID = $registrationNationalityID;
        return $this;
    }

    /**
     * Get RegistrationNationality value
     * @return RegistrationNationalityType[]|null
     */
    public function getRegistrationNationality()
    {
        return $this->RegistrationNationality;
    }

    /**
     * This method is responsible for validating the values passed to the setRegistrationNationality method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegistrationNationality method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegistrationNationalityForArrayConstraintsFromSetRegistrationNationality(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportMeansTypeRegistrationNationalityItem) {
            // validation for constraint: itemType
            if (!$transportMeansTypeRegistrationNationalityItem instanceof RegistrationNationalityType) {
                $invalidValues[] = is_object($transportMeansTypeRegistrationNationalityItem) ? get_class($transportMeansTypeRegistrationNationalityItem) : sprintf('%s(%s)', gettype($transportMeansTypeRegistrationNationalityItem), var_export($transportMeansTypeRegistrationNationalityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RegistrationNationality property can only contain items of type \Gek\UyumBahce\StructType\RegistrationNationalityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set RegistrationNationality value
     * @param RegistrationNationalityType[] $registrationNationality
     * @return TransportMeansType
     * @throws InvalidArgumentException
     */
    public function setRegistrationNationality(array $registrationNationality = array())
    {
        // validation for constraint: array
        if ('' !== ($registrationNationalityArrayErrorMessage = self::validateRegistrationNationalityForArrayConstraintsFromSetRegistrationNationality($registrationNationality))) {
            throw new InvalidArgumentException($registrationNationalityArrayErrorMessage, __LINE__);
        }
        $this->RegistrationNationality = $registrationNationality;
        return $this;
    }

    /**
     * Add item to RegistrationNationality value
     * @param RegistrationNationalityType $item
     * @return TransportMeansType
     * @throws InvalidArgumentException
     */
    public function addToRegistrationNationality(RegistrationNationalityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof RegistrationNationalityType) {
            throw new InvalidArgumentException(sprintf('The RegistrationNationality property can only contain items of type \Gek\UyumBahce\StructType\RegistrationNationalityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RegistrationNationality[] = $item;
        return $this;
    }

    /**
     * Get DirectionCode value
     * @return DirectionCodeType|null
     */
    public function getDirectionCode()
    {
        return $this->DirectionCode;
    }

    /**
     * Set DirectionCode value
     * @param DirectionCodeType $directionCode
     * @return TransportMeansType
     */
    public function setDirectionCode(DirectionCodeType $directionCode = null)
    {
        $this->DirectionCode = $directionCode;
        return $this;
    }

    /**
     * Get TransportMeansTypeCode value
     * @return TransportMeansTypeCodeType|null
     */
    public function getTransportMeansTypeCode()
    {
        return $this->TransportMeansTypeCode;
    }

    /**
     * Set TransportMeansTypeCode value
     * @param TransportMeansTypeCodeType $transportMeansTypeCode
     * @return TransportMeansType
     */
    public function setTransportMeansTypeCode(TransportMeansTypeCodeType $transportMeansTypeCode = null)
    {
        $this->TransportMeansTypeCode = $transportMeansTypeCode;
        return $this;
    }

    /**
     * Get TradeServiceCode value
     * @return TradeServiceCodeType|null
     */
    public function getTradeServiceCode()
    {
        return $this->TradeServiceCode;
    }

    /**
     * Set TradeServiceCode value
     * @param TradeServiceCodeType $tradeServiceCode
     * @return TransportMeansType
     */
    public function setTradeServiceCode(TradeServiceCodeType $tradeServiceCode = null)
    {
        $this->TradeServiceCode = $tradeServiceCode;
        return $this;
    }

    /**
     * Get Stowage value
     * @return StowageType|null
     */
    public function getStowage()
    {
        return $this->Stowage;
    }

    /**
     * Set Stowage value
     * @param StowageType $stowage
     * @return TransportMeansType
     */
    public function setStowage(StowageType $stowage = null)
    {
        $this->Stowage = $stowage;
        return $this;
    }

    /**
     * Get AirTransport value
     * @return AirTransportType|null
     */
    public function getAirTransport()
    {
        return $this->AirTransport;
    }

    /**
     * Set AirTransport value
     * @param AirTransportType $airTransport
     * @return TransportMeansType
     */
    public function setAirTransport(AirTransportType $airTransport = null)
    {
        $this->AirTransport = $airTransport;
        return $this;
    }

    /**
     * Get RoadTransport value
     * @return RoadTransportType|null
     */
    public function getRoadTransport()
    {
        return $this->RoadTransport;
    }

    /**
     * Set RoadTransport value
     * @param RoadTransportType $roadTransport
     * @return TransportMeansType
     */
    public function setRoadTransport(RoadTransportType $roadTransport = null)
    {
        $this->RoadTransport = $roadTransport;
        return $this;
    }

    /**
     * Get RailTransport value
     * @return RailTransportType|null
     */
    public function getRailTransport()
    {
        return $this->RailTransport;
    }

    /**
     * Set RailTransport value
     * @param RailTransportType $railTransport
     * @return TransportMeansType
     */
    public function setRailTransport(RailTransportType $railTransport = null)
    {
        $this->RailTransport = $railTransport;
        return $this;
    }

    /**
     * Get MaritimeTransport value
     * @return MaritimeTransportType|null
     */
    public function getMaritimeTransport()
    {
        return $this->MaritimeTransport;
    }

    /**
     * Set MaritimeTransport value
     * @param MaritimeTransportType $maritimeTransport
     * @return TransportMeansType
     */
    public function setMaritimeTransport(MaritimeTransportType $maritimeTransport = null)
    {
        $this->MaritimeTransport = $maritimeTransport;
        return $this;
    }

    /**
     * Get OwnerParty value
     * @return PartyType|null
     */
    public function getOwnerParty()
    {
        return $this->OwnerParty;
    }

    /**
     * Set OwnerParty value
     * @param PartyType $ownerParty
     * @return TransportMeansType
     */
    public function setOwnerParty(PartyType $ownerParty = null)
    {
        $this->OwnerParty = $ownerParty;
        return $this;
    }

    /**
     * Get MeasurementDimension value
     * @return DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }

    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportMeansTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$transportMeansTypeMeasurementDimensionItem instanceof DimensionType) {
                $invalidValues[] = is_object($transportMeansTypeMeasurementDimensionItem) ? get_class($transportMeansTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($transportMeansTypeMeasurementDimensionItem), var_export($transportMeansTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set MeasurementDimension value
     * @param DimensionType[] $measurementDimension
     * @return TransportMeansType
     * @throws InvalidArgumentException
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }

    /**
     * Add item to MeasurementDimension value
     * @param DimensionType $item
     * @return TransportMeansType
     * @throws InvalidArgumentException
     */
    public function addToMeasurementDimension(DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DimensionType) {
            throw new InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
