<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignedInfoType StructType
 * @subpackage Structs
 */
class SignedInfoType extends AbstractStructBase
{
    /**
     * The CanonicalizationMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CanonicalizationMethodType
     */
    public $CanonicalizationMethod;
    /**
     * The SignatureMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var SignatureMethodType
     */
    public $SignatureMethod;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ReferenceType[]
     */
    public $Reference;
    /**
     * The Id
     * @var string
     */
    public $Id;

    /**
     * Constructor method for SignedInfoType
     * @param CanonicalizationMethodType $canonicalizationMethod
     * @param SignatureMethodType $signatureMethod
     * @param ReferenceType[] $reference
     * @param string $id
     * @uses SignedInfoType::setCanonicalizationMethod()
     * @uses SignedInfoType::setSignatureMethod()
     * @uses SignedInfoType::setReference()
     * @uses SignedInfoType::setId()
     */
    public function __construct(CanonicalizationMethodType $canonicalizationMethod = null, SignatureMethodType $signatureMethod = null, array $reference = array(), $id = null)
    {
        $this
            ->setCanonicalizationMethod($canonicalizationMethod)
            ->setSignatureMethod($signatureMethod)
            ->setReference($reference)
            ->setId($id);
    }

    /**
     * Get CanonicalizationMethod value
     * @return CanonicalizationMethodType|null
     */
    public function getCanonicalizationMethod()
    {
        return $this->CanonicalizationMethod;
    }

    /**
     * Set CanonicalizationMethod value
     * @param CanonicalizationMethodType $canonicalizationMethod
     * @return SignedInfoType
     */
    public function setCanonicalizationMethod(CanonicalizationMethodType $canonicalizationMethod = null)
    {
        $this->CanonicalizationMethod = $canonicalizationMethod;
        return $this;
    }

    /**
     * Get SignatureMethod value
     * @return SignatureMethodType|null
     */
    public function getSignatureMethod()
    {
        return $this->SignatureMethod;
    }

    /**
     * Set SignatureMethod value
     * @param SignatureMethodType $signatureMethod
     * @return SignedInfoType
     */
    public function setSignatureMethod(SignatureMethodType $signatureMethod = null)
    {
        $this->SignatureMethod = $signatureMethod;
        return $this;
    }

    /**
     * Get Reference value
     * @return ReferenceType[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }

    /**
     * This method is responsible for validating the values passed to the setReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceForArrayConstraintsFromSetReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $signedInfoTypeReferenceItem) {
            // validation for constraint: itemType
            if (!$signedInfoTypeReferenceItem instanceof ReferenceType) {
                $invalidValues[] = is_object($signedInfoTypeReferenceItem) ? get_class($signedInfoTypeReferenceItem) : sprintf('%s(%s)', gettype($signedInfoTypeReferenceItem), var_export($signedInfoTypeReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reference property can only contain items of type \Gek\UyumBahce\StructType\ReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Reference value
     * @param ReferenceType[] $reference
     * @return SignedInfoType
     * @throws InvalidArgumentException
     */
    public function setReference(array $reference = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceArrayErrorMessage = self::validateReferenceForArrayConstraintsFromSetReference($reference))) {
            throw new InvalidArgumentException($referenceArrayErrorMessage, __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }

    /**
     * Add item to Reference value
     * @param ReferenceType $item
     * @return SignedInfoType
     * @throws InvalidArgumentException
     */
    public function addToReference(ReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ReferenceType) {
            throw new InvalidArgumentException(sprintf('The Reference property can only contain items of type \Gek\UyumBahce\StructType\ReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reference[] = $item;
        return $this;
    }

    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param string $id
     * @return SignedInfoType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
