<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\EnumType\RequestStatus;
use Gek\UyumBahce\EnumType\VatStatus;
use InvalidArgumentException;

/**
 * This class stands for RequestDetailDef StructType
 * @subpackage Structs
 */
class RequestDetailDef extends DetailFields
{
    /**
     * The LineType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var LineType
     */
    public $LineType;
    /**
     * The DcardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DcardId;
    /**
     * The UnitId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $UnitId;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The UnitPriceTra
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UnitPriceTra;
    /**
     * The VatRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $VatRate;
    /**
     * The VatId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $VatId;
    /**
     * The AmtVat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtVat;
    /**
     * The AbtActId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AbtActId;
    /**
     * The AbtBudgetId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AbtBudgetId;
    /**
     * The VatStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $VatStatus;
    /**
     * The UseExpBudget
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UseExpBudget;
    /**
     * The RequestStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RequestStatus;
    /**
     * The DcardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DcardCode;
    /**
     * The UnitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitCode;
    /**
     * The VatCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VatCode;
    /**
     * The AbtActCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AbtActCode;
    /**
     * The AbtBudgetCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AbtBudgetCode;
    /**
     * The OTVCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OTVCode;
    /**
     * The OIVCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OIVCode;

    /**
     * Constructor method for RequestDetailDef
     * @param LineType $lineType
     * @param int $dcardId
     * @param int $unitId
     * @param float $qty
     * @param float $unitPriceTra
     * @param float $vatRate
     * @param int $vatId
     * @param float $amtVat
     * @param int $abtActId
     * @param int $abtBudgetId
     * @param string $vatStatus
     * @param bool $useExpBudget
     * @param string $requestStatus
     * @param string $dcardCode
     * @param string $unitCode
     * @param string $vatCode
     * @param string $abtActCode
     * @param string $abtBudgetCode
     * @param string $oTVCode
     * @param string $oIVCode
     * @uses RequestDetailDef::setLineType()
     * @uses RequestDetailDef::setDcardId()
     * @uses RequestDetailDef::setUnitId()
     * @uses RequestDetailDef::setQty()
     * @uses RequestDetailDef::setUnitPriceTra()
     * @uses RequestDetailDef::setVatRate()
     * @uses RequestDetailDef::setVatId()
     * @uses RequestDetailDef::setAmtVat()
     * @uses RequestDetailDef::setAbtActId()
     * @uses RequestDetailDef::setAbtBudgetId()
     * @uses RequestDetailDef::setVatStatus()
     * @uses RequestDetailDef::setUseExpBudget()
     * @uses RequestDetailDef::setRequestStatus()
     * @uses RequestDetailDef::setDcardCode()
     * @uses RequestDetailDef::setUnitCode()
     * @uses RequestDetailDef::setVatCode()
     * @uses RequestDetailDef::setAbtActCode()
     * @uses RequestDetailDef::setAbtBudgetCode()
     * @uses RequestDetailDef::setOTVCode()
     * @uses RequestDetailDef::setOIVCode()
     */
    public function __construct(LineType $lineType = null, $dcardId = null, $unitId = null, $qty = null, $unitPriceTra = null, $vatRate = null, $vatId = null, $amtVat = null, $abtActId = null, $abtBudgetId = null, $vatStatus = null, $useExpBudget = null, $requestStatus = null, $dcardCode = null, $unitCode = null, $vatCode = null, $abtActCode = null, $abtBudgetCode = null, $oTVCode = null, $oIVCode = null)
    {
        $this
            ->setLineType($lineType)
            ->setDcardId($dcardId)
            ->setUnitId($unitId)
            ->setQty($qty)
            ->setUnitPriceTra($unitPriceTra)
            ->setVatRate($vatRate)
            ->setVatId($vatId)
            ->setAmtVat($amtVat)
            ->setAbtActId($abtActId)
            ->setAbtBudgetId($abtBudgetId)
            ->setVatStatus($vatStatus)
            ->setUseExpBudget($useExpBudget)
            ->setRequestStatus($requestStatus)
            ->setDcardCode($dcardCode)
            ->setUnitCode($unitCode)
            ->setVatCode($vatCode)
            ->setAbtActCode($abtActCode)
            ->setAbtBudgetCode($abtBudgetCode)
            ->setOTVCode($oTVCode)
            ->setOIVCode($oIVCode);
    }

    /**
     * Get LineType value
     * @return LineType
     */
    public function getLineType()
    {
        return $this->LineType;
    }

    /**
     * Set LineType value
     * @param LineType $lineType
     * @return RequestDetailDef
     */
    public function setLineType(LineType $lineType = null)
    {
        $this->LineType = $lineType;
        return $this;
    }

    /**
     * Get DcardId value
     * @return int
     */
    public function getDcardId()
    {
        return $this->DcardId;
    }

    /**
     * Set DcardId value
     * @param int $dcardId
     * @return RequestDetailDef
     */
    public function setDcardId($dcardId = null)
    {
        // validation for constraint: int
        if (!is_null($dcardId) && !(is_int($dcardId) || ctype_digit($dcardId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dcardId, true), gettype($dcardId)), __LINE__);
        }
        $this->DcardId = $dcardId;
        return $this;
    }

    /**
     * Get UnitId value
     * @return int
     */
    public function getUnitId()
    {
        return $this->UnitId;
    }

    /**
     * Set UnitId value
     * @param int $unitId
     * @return RequestDetailDef
     */
    public function setUnitId($unitId = null)
    {
        // validation for constraint: int
        if (!is_null($unitId) && !(is_int($unitId) || ctype_digit($unitId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitId, true), gettype($unitId)), __LINE__);
        }
        $this->UnitId = $unitId;
        return $this;
    }

    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }

    /**
     * Set Qty value
     * @param float $qty
     * @return RequestDetailDef
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }

    /**
     * Get UnitPriceTra value
     * @return float
     */
    public function getUnitPriceTra()
    {
        return $this->UnitPriceTra;
    }

    /**
     * Set UnitPriceTra value
     * @param float $unitPriceTra
     * @return RequestDetailDef
     */
    public function setUnitPriceTra($unitPriceTra = null)
    {
        // validation for constraint: float
        if (!is_null($unitPriceTra) && !(is_float($unitPriceTra) || is_numeric($unitPriceTra))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPriceTra, true), gettype($unitPriceTra)), __LINE__);
        }
        $this->UnitPriceTra = $unitPriceTra;
        return $this;
    }

    /**
     * Get VatRate value
     * @return float
     */
    public function getVatRate()
    {
        return $this->VatRate;
    }

    /**
     * Set VatRate value
     * @param float $vatRate
     * @return RequestDetailDef
     */
    public function setVatRate($vatRate = null)
    {
        // validation for constraint: float
        if (!is_null($vatRate) && !(is_float($vatRate) || is_numeric($vatRate))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatRate, true), gettype($vatRate)), __LINE__);
        }
        $this->VatRate = $vatRate;
        return $this;
    }

    /**
     * Get VatId value
     * @return int
     */
    public function getVatId()
    {
        return $this->VatId;
    }

    /**
     * Set VatId value
     * @param int $vatId
     * @return RequestDetailDef
     */
    public function setVatId($vatId = null)
    {
        // validation for constraint: int
        if (!is_null($vatId) && !(is_int($vatId) || ctype_digit($vatId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vatId, true), gettype($vatId)), __LINE__);
        }
        $this->VatId = $vatId;
        return $this;
    }

    /**
     * Get AmtVat value
     * @return float
     */
    public function getAmtVat()
    {
        return $this->AmtVat;
    }

    /**
     * Set AmtVat value
     * @param float $amtVat
     * @return RequestDetailDef
     */
    public function setAmtVat($amtVat = null)
    {
        // validation for constraint: float
        if (!is_null($amtVat) && !(is_float($amtVat) || is_numeric($amtVat))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtVat, true), gettype($amtVat)), __LINE__);
        }
        $this->AmtVat = $amtVat;
        return $this;
    }

    /**
     * Get AbtActId value
     * @return int
     */
    public function getAbtActId()
    {
        return $this->AbtActId;
    }

    /**
     * Set AbtActId value
     * @param int $abtActId
     * @return RequestDetailDef
     */
    public function setAbtActId($abtActId = null)
    {
        // validation for constraint: int
        if (!is_null($abtActId) && !(is_int($abtActId) || ctype_digit($abtActId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abtActId, true), gettype($abtActId)), __LINE__);
        }
        $this->AbtActId = $abtActId;
        return $this;
    }

    /**
     * Get AbtBudgetId value
     * @return int
     */
    public function getAbtBudgetId()
    {
        return $this->AbtBudgetId;
    }

    /**
     * Set AbtBudgetId value
     * @param int $abtBudgetId
     * @return RequestDetailDef
     */
    public function setAbtBudgetId($abtBudgetId = null)
    {
        // validation for constraint: int
        if (!is_null($abtBudgetId) && !(is_int($abtBudgetId) || ctype_digit($abtBudgetId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abtBudgetId, true), gettype($abtBudgetId)), __LINE__);
        }
        $this->AbtBudgetId = $abtBudgetId;
        return $this;
    }

    /**
     * Get VatStatus value
     * @return string
     */
    public function getVatStatus()
    {
        return $this->VatStatus;
    }

    /**
     * Set VatStatus value
     * @param string $vatStatus
     * @return RequestDetailDef
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\VatStatus::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\VatStatus::valueIsValid()
     */
    public function setVatStatus($vatStatus = null)
    {
        // validation for constraint: enumeration
        if (!VatStatus::valueIsValid($vatStatus)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\VatStatus', is_array($vatStatus) ? implode(', ', $vatStatus) : var_export($vatStatus, true), implode(', ', VatStatus::getValidValues())), __LINE__);
        }
        $this->VatStatus = $vatStatus;
        return $this;
    }

    /**
     * Get UseExpBudget value
     * @return bool
     */
    public function getUseExpBudget()
    {
        return $this->UseExpBudget;
    }

    /**
     * Set UseExpBudget value
     * @param bool $useExpBudget
     * @return RequestDetailDef
     */
    public function setUseExpBudget($useExpBudget = null)
    {
        // validation for constraint: boolean
        if (!is_null($useExpBudget) && !is_bool($useExpBudget)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useExpBudget, true), gettype($useExpBudget)), __LINE__);
        }
        $this->UseExpBudget = $useExpBudget;
        return $this;
    }

    /**
     * Get RequestStatus value
     * @return string
     */
    public function getRequestStatus()
    {
        return $this->RequestStatus;
    }

    /**
     * Set RequestStatus value
     * @param string $requestStatus
     * @return RequestDetailDef
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\RequestStatus::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\RequestStatus::valueIsValid()
     */
    public function setRequestStatus($requestStatus = null)
    {
        // validation for constraint: enumeration
        if (!RequestStatus::valueIsValid($requestStatus)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\RequestStatus', is_array($requestStatus) ? implode(', ', $requestStatus) : var_export($requestStatus, true), implode(', ', RequestStatus::getValidValues())), __LINE__);
        }
        $this->RequestStatus = $requestStatus;
        return $this;
    }

    /**
     * Get DcardCode value
     * @return string|null
     */
    public function getDcardCode()
    {
        return $this->DcardCode;
    }

    /**
     * Set DcardCode value
     * @param string $dcardCode
     * @return RequestDetailDef
     */
    public function setDcardCode($dcardCode = null)
    {
        // validation for constraint: string
        if (!is_null($dcardCode) && !is_string($dcardCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dcardCode, true), gettype($dcardCode)), __LINE__);
        }
        $this->DcardCode = $dcardCode;
        return $this;
    }

    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }

    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return RequestDetailDef
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }

    /**
     * Get VatCode value
     * @return string|null
     */
    public function getVatCode()
    {
        return $this->VatCode;
    }

    /**
     * Set VatCode value
     * @param string $vatCode
     * @return RequestDetailDef
     */
    public function setVatCode($vatCode = null)
    {
        // validation for constraint: string
        if (!is_null($vatCode) && !is_string($vatCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatCode, true), gettype($vatCode)), __LINE__);
        }
        $this->VatCode = $vatCode;
        return $this;
    }

    /**
     * Get AbtActCode value
     * @return string|null
     */
    public function getAbtActCode()
    {
        return $this->AbtActCode;
    }

    /**
     * Set AbtActCode value
     * @param string $abtActCode
     * @return RequestDetailDef
     */
    public function setAbtActCode($abtActCode = null)
    {
        // validation for constraint: string
        if (!is_null($abtActCode) && !is_string($abtActCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abtActCode, true), gettype($abtActCode)), __LINE__);
        }
        $this->AbtActCode = $abtActCode;
        return $this;
    }

    /**
     * Get AbtBudgetCode value
     * @return string|null
     */
    public function getAbtBudgetCode()
    {
        return $this->AbtBudgetCode;
    }

    /**
     * Set AbtBudgetCode value
     * @param string $abtBudgetCode
     * @return RequestDetailDef
     */
    public function setAbtBudgetCode($abtBudgetCode = null)
    {
        // validation for constraint: string
        if (!is_null($abtBudgetCode) && !is_string($abtBudgetCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abtBudgetCode, true), gettype($abtBudgetCode)), __LINE__);
        }
        $this->AbtBudgetCode = $abtBudgetCode;
        return $this;
    }

    /**
     * Get OTVCode value
     * @return string|null
     */
    public function getOTVCode()
    {
        return $this->OTVCode;
    }

    /**
     * Set OTVCode value
     * @param string $oTVCode
     * @return RequestDetailDef
     */
    public function setOTVCode($oTVCode = null)
    {
        // validation for constraint: string
        if (!is_null($oTVCode) && !is_string($oTVCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oTVCode, true), gettype($oTVCode)), __LINE__);
        }
        $this->OTVCode = $oTVCode;
        return $this;
    }

    /**
     * Get OIVCode value
     * @return string|null
     */
    public function getOIVCode()
    {
        return $this->OIVCode;
    }

    /**
     * Set OIVCode value
     * @param string $oIVCode
     * @return RequestDetailDef
     */
    public function setOIVCode($oIVCode = null)
    {
        // validation for constraint: string
        if (!is_null($oIVCode) && !is_string($oIVCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIVCode, true), gettype($oIVCode)), __LINE__);
        }
        $this->OIVCode = $oIVCode;
        return $this;
    }
}
