<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\EnumType\VatStatus;
use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferralDetailInfo StructType
 * @subpackage Structs
 */
class ReferralDetailInfo extends AbstractStructBase
{
    /**
     * The ReferralDetailId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReferralDetailId;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The QtyOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QtyOrder;
    /**
     * The QtyRemainder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QtyRemainder;
    /**
     * The QtyReferral
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QtyReferral;
    /**
     * The QtyReferralTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QtyReferralTotal;
    /**
     * The QtyShipping
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QtyShipping;
    /**
     * The QtySum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QtySum;
    /**
     * The WhouseId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WhouseId;
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalDate;
    /**
     * The PackageTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PackageTypeId;
    /**
     * The LotId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LotId;
    /**
     * The QtyRead
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QtyRead;
    /**
     * The ReferralMasterId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReferralMasterId;
    /**
     * The Linetype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var LineType
     */
    public $Linetype;
    /**
     * The UnitPriceTra
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UnitPriceTra;
    /**
     * The UnitId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitId;
    /**
     * The VatStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VatStatus;
    /**
     * The QualityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QualityId;
    /**
     * The ColorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ColorId;
    /**
     * The ItemAttribute1Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemAttribute1Id;
    /**
     * The ItemAttribute2Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemAttribute2Id;
    /**
     * The ItemAttribute3Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemAttribute3Id;
    /**
     * The SourceDId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceDId;
    /**
     * The TempCoDocTraIdWaybill
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TempCoDocTraIdWaybill;
    /**
     * The IsserialTrack
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsserialTrack;
    /**
     * The SalesToleranceMaxSo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SalesToleranceMaxSo;
    /**
     * The UnitFactor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UnitFactor;
    /**
     * The TempCoDocTraIsTransfer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TempCoDocTraIsTransfer;
    /**
     * The ItemCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemName;
    /**
     * The WhouseCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WhouseCode;
    /**
     * The PackageTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackageTypeCode;
    /**
     * The OrderNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderNo;
    /**
     * The LotCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LotCode;
    /**
     * The Note1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note1;
    /**
     * The Note2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note2;
    /**
     * The VatCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VatCode;
    /**
     * The QualityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QualityCode;
    /**
     * The ColorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ColorCode;
    /**
     * The ItemAttribute1Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemAttribute1Code;
    /**
     * The ItemAttribute2Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemAttribute2Code;
    /**
     * The ItemAttribute3Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemAttribute3Code;
    /**
     * The IncotermsName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IncotermsName;
    /**
     * The PaymentMethodDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodDesc;
    /**
     * The ItemAddString01
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemAddString01;
    /**
     * The TempCoDocTraCodeWaybill
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TempCoDocTraCodeWaybill;

    /**
     * Constructor method for ReferralDetailInfo
     * @param int $referralDetailId
     * @param int $itemId
     * @param float $qtyOrder
     * @param float $qtyRemainder
     * @param float $qtyReferral
     * @param float $qtyReferralTotal
     * @param float $qtyShipping
     * @param float $qtySum
     * @param int $whouseId
     * @param string|GekDateTime $arrivalDate
     * @param int $packageTypeId
     * @param int $lotId
     * @param int $qtyRead
     * @param int $referralMasterId
     * @param LineType $linetype
     * @param float $unitPriceTra
     * @param int $unitId
     * @param string $vatStatus
     * @param int $qualityId
     * @param int $colorId
     * @param int $itemAttribute1Id
     * @param int $itemAttribute2Id
     * @param int $itemAttribute3Id
     * @param int $sourceDId
     * @param int $tempCoDocTraIdWaybill
     * @param bool $isserialTrack
     * @param float $salesToleranceMaxSo
     * @param float $unitFactor
     * @param bool $tempCoDocTraIsTransfer
     * @param string $itemCode
     * @param string $itemName
     * @param string $whouseCode
     * @param string $packageTypeCode
     * @param string $orderNo
     * @param string $lotCode
     * @param string $note1
     * @param string $note2
     * @param string $vatCode
     * @param string $qualityCode
     * @param string $colorCode
     * @param string $itemAttribute1Code
     * @param string $itemAttribute2Code
     * @param string $itemAttribute3Code
     * @param string $incotermsName
     * @param string $paymentMethodDesc
     * @param string $itemAddString01
     * @param string $tempCoDocTraCodeWaybill
     * @uses ReferralDetailInfo::setReferralDetailId()
     * @uses ReferralDetailInfo::setItemId()
     * @uses ReferralDetailInfo::setQtyOrder()
     * @uses ReferralDetailInfo::setQtyRemainder()
     * @uses ReferralDetailInfo::setQtyReferral()
     * @uses ReferralDetailInfo::setQtyReferralTotal()
     * @uses ReferralDetailInfo::setQtyShipping()
     * @uses ReferralDetailInfo::setQtySum()
     * @uses ReferralDetailInfo::setWhouseId()
     * @uses ReferralDetailInfo::setArrivalDate()
     * @uses ReferralDetailInfo::setPackageTypeId()
     * @uses ReferralDetailInfo::setLotId()
     * @uses ReferralDetailInfo::setQtyRead()
     * @uses ReferralDetailInfo::setReferralMasterId()
     * @uses ReferralDetailInfo::setLinetype()
     * @uses ReferralDetailInfo::setUnitPriceTra()
     * @uses ReferralDetailInfo::setUnitId()
     * @uses ReferralDetailInfo::setVatStatus()
     * @uses ReferralDetailInfo::setQualityId()
     * @uses ReferralDetailInfo::setColorId()
     * @uses ReferralDetailInfo::setItemAttribute1Id()
     * @uses ReferralDetailInfo::setItemAttribute2Id()
     * @uses ReferralDetailInfo::setItemAttribute3Id()
     * @uses ReferralDetailInfo::setSourceDId()
     * @uses ReferralDetailInfo::setTempCoDocTraIdWaybill()
     * @uses ReferralDetailInfo::setIsserialTrack()
     * @uses ReferralDetailInfo::setSalesToleranceMaxSo()
     * @uses ReferralDetailInfo::setUnitFactor()
     * @uses ReferralDetailInfo::setTempCoDocTraIsTransfer()
     * @uses ReferralDetailInfo::setItemCode()
     * @uses ReferralDetailInfo::setItemName()
     * @uses ReferralDetailInfo::setWhouseCode()
     * @uses ReferralDetailInfo::setPackageTypeCode()
     * @uses ReferralDetailInfo::setOrderNo()
     * @uses ReferralDetailInfo::setLotCode()
     * @uses ReferralDetailInfo::setNote1()
     * @uses ReferralDetailInfo::setNote2()
     * @uses ReferralDetailInfo::setVatCode()
     * @uses ReferralDetailInfo::setQualityCode()
     * @uses ReferralDetailInfo::setColorCode()
     * @uses ReferralDetailInfo::setItemAttribute1Code()
     * @uses ReferralDetailInfo::setItemAttribute2Code()
     * @uses ReferralDetailInfo::setItemAttribute3Code()
     * @uses ReferralDetailInfo::setIncotermsName()
     * @uses ReferralDetailInfo::setPaymentMethodDesc()
     * @uses ReferralDetailInfo::setItemAddString01()
     * @uses ReferralDetailInfo::setTempCoDocTraCodeWaybill()
     */
    public function __construct($referralDetailId = null, $itemId = null, $qtyOrder = null, $qtyRemainder = null, $qtyReferral = null, $qtyReferralTotal = null, $qtyShipping = null, $qtySum = null, $whouseId = null, $arrivalDate = null, $packageTypeId = null, $lotId = null, $qtyRead = null, $referralMasterId = null, LineType $linetype = null, $unitPriceTra = null, $unitId = null, $vatStatus = null, $qualityId = null, $colorId = null, $itemAttribute1Id = null, $itemAttribute2Id = null, $itemAttribute3Id = null, $sourceDId = null, $tempCoDocTraIdWaybill = null, $isserialTrack = null, $salesToleranceMaxSo = null, $unitFactor = null, $tempCoDocTraIsTransfer = null, $itemCode = null, $itemName = null, $whouseCode = null, $packageTypeCode = null, $orderNo = null, $lotCode = null, $note1 = null, $note2 = null, $vatCode = null, $qualityCode = null, $colorCode = null, $itemAttribute1Code = null, $itemAttribute2Code = null, $itemAttribute3Code = null, $incotermsName = null, $paymentMethodDesc = null, $itemAddString01 = null, $tempCoDocTraCodeWaybill = null)
    {
        $this
            ->setReferralDetailId($referralDetailId)
            ->setItemId($itemId)
            ->setQtyOrder($qtyOrder)
            ->setQtyRemainder($qtyRemainder)
            ->setQtyReferral($qtyReferral)
            ->setQtyReferralTotal($qtyReferralTotal)
            ->setQtyShipping($qtyShipping)
            ->setQtySum($qtySum)
            ->setWhouseId($whouseId)
            ->setArrivalDate($arrivalDate)
            ->setPackageTypeId($packageTypeId)
            ->setLotId($lotId)
            ->setQtyRead($qtyRead)
            ->setReferralMasterId($referralMasterId)
            ->setLinetype($linetype)
            ->setUnitPriceTra($unitPriceTra)
            ->setUnitId($unitId)
            ->setVatStatus($vatStatus)
            ->setQualityId($qualityId)
            ->setColorId($colorId)
            ->setItemAttribute1Id($itemAttribute1Id)
            ->setItemAttribute2Id($itemAttribute2Id)
            ->setItemAttribute3Id($itemAttribute3Id)
            ->setSourceDId($sourceDId)
            ->setTempCoDocTraIdWaybill($tempCoDocTraIdWaybill)
            ->setIsserialTrack($isserialTrack)
            ->setSalesToleranceMaxSo($salesToleranceMaxSo)
            ->setUnitFactor($unitFactor)
            ->setTempCoDocTraIsTransfer($tempCoDocTraIsTransfer)
            ->setItemCode($itemCode)
            ->setItemName($itemName)
            ->setWhouseCode($whouseCode)
            ->setPackageTypeCode($packageTypeCode)
            ->setOrderNo($orderNo)
            ->setLotCode($lotCode)
            ->setNote1($note1)
            ->setNote2($note2)
            ->setVatCode($vatCode)
            ->setQualityCode($qualityCode)
            ->setColorCode($colorCode)
            ->setItemAttribute1Code($itemAttribute1Code)
            ->setItemAttribute2Code($itemAttribute2Code)
            ->setItemAttribute3Code($itemAttribute3Code)
            ->setIncotermsName($incotermsName)
            ->setPaymentMethodDesc($paymentMethodDesc)
            ->setItemAddString01($itemAddString01)
            ->setTempCoDocTraCodeWaybill($tempCoDocTraCodeWaybill);
    }

    /**
     * Get ReferralDetailId value
     * @return int
     */
    public function getReferralDetailId()
    {
        return $this->ReferralDetailId;
    }

    /**
     * Set ReferralDetailId value
     * @param int $referralDetailId
     * @return ReferralDetailInfo
     */
    public function setReferralDetailId($referralDetailId = null)
    {
        // validation for constraint: int
        if (!is_null($referralDetailId) && !(is_int($referralDetailId) || ctype_digit($referralDetailId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referralDetailId, true), gettype($referralDetailId)), __LINE__);
        }
        $this->ReferralDetailId = $referralDetailId;
        return $this;
    }

    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }

    /**
     * Set ItemId value
     * @param int $itemId
     * @return ReferralDetailInfo
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }

    /**
     * Get QtyOrder value
     * @return float
     */
    public function getQtyOrder()
    {
        return $this->QtyOrder;
    }

    /**
     * Set QtyOrder value
     * @param float $qtyOrder
     * @return ReferralDetailInfo
     */
    public function setQtyOrder($qtyOrder = null)
    {
        // validation for constraint: float
        if (!is_null($qtyOrder) && !(is_float($qtyOrder) || is_numeric($qtyOrder))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyOrder, true), gettype($qtyOrder)), __LINE__);
        }
        $this->QtyOrder = $qtyOrder;
        return $this;
    }

    /**
     * Get QtyRemainder value
     * @return float
     */
    public function getQtyRemainder()
    {
        return $this->QtyRemainder;
    }

    /**
     * Set QtyRemainder value
     * @param float $qtyRemainder
     * @return ReferralDetailInfo
     */
    public function setQtyRemainder($qtyRemainder = null)
    {
        // validation for constraint: float
        if (!is_null($qtyRemainder) && !(is_float($qtyRemainder) || is_numeric($qtyRemainder))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyRemainder, true), gettype($qtyRemainder)), __LINE__);
        }
        $this->QtyRemainder = $qtyRemainder;
        return $this;
    }

    /**
     * Get QtyReferral value
     * @return float
     */
    public function getQtyReferral()
    {
        return $this->QtyReferral;
    }

    /**
     * Set QtyReferral value
     * @param float $qtyReferral
     * @return ReferralDetailInfo
     */
    public function setQtyReferral($qtyReferral = null)
    {
        // validation for constraint: float
        if (!is_null($qtyReferral) && !(is_float($qtyReferral) || is_numeric($qtyReferral))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyReferral, true), gettype($qtyReferral)), __LINE__);
        }
        $this->QtyReferral = $qtyReferral;
        return $this;
    }

    /**
     * Get QtyReferralTotal value
     * @return float
     */
    public function getQtyReferralTotal()
    {
        return $this->QtyReferralTotal;
    }

    /**
     * Set QtyReferralTotal value
     * @param float $qtyReferralTotal
     * @return ReferralDetailInfo
     */
    public function setQtyReferralTotal($qtyReferralTotal = null)
    {
        // validation for constraint: float
        if (!is_null($qtyReferralTotal) && !(is_float($qtyReferralTotal) || is_numeric($qtyReferralTotal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyReferralTotal, true), gettype($qtyReferralTotal)), __LINE__);
        }
        $this->QtyReferralTotal = $qtyReferralTotal;
        return $this;
    }

    /**
     * Get QtyShipping value
     * @return float
     */
    public function getQtyShipping()
    {
        return $this->QtyShipping;
    }

    /**
     * Set QtyShipping value
     * @param float $qtyShipping
     * @return ReferralDetailInfo
     */
    public function setQtyShipping($qtyShipping = null)
    {
        // validation for constraint: float
        if (!is_null($qtyShipping) && !(is_float($qtyShipping) || is_numeric($qtyShipping))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyShipping, true), gettype($qtyShipping)), __LINE__);
        }
        $this->QtyShipping = $qtyShipping;
        return $this;
    }

    /**
     * Get QtySum value
     * @return float
     */
    public function getQtySum()
    {
        return $this->QtySum;
    }

    /**
     * Set QtySum value
     * @param float $qtySum
     * @return ReferralDetailInfo
     */
    public function setQtySum($qtySum = null)
    {
        // validation for constraint: float
        if (!is_null($qtySum) && !(is_float($qtySum) || is_numeric($qtySum))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtySum, true), gettype($qtySum)), __LINE__);
        }
        $this->QtySum = $qtySum;
        return $this;
    }

    /**
     * Get WhouseId value
     * @return int
     */
    public function getWhouseId()
    {
        return $this->WhouseId;
    }

    /**
     * Set WhouseId value
     * @param int $whouseId
     * @return ReferralDetailInfo
     */
    public function setWhouseId($whouseId = null)
    {
        // validation for constraint: int
        if (!is_null($whouseId) && !(is_int($whouseId) || ctype_digit($whouseId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($whouseId, true), gettype($whouseId)), __LINE__);
        }
        $this->WhouseId = $whouseId;
        return $this;
    }

    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }

    /**
     * Set ArrivalDate value
     * @param string|GekDateTime $arrivalDate
     * @return ReferralDetailInfo
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate) && !($arrivalDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        if ($arrivalDate instanceof GekDateTime) {
            $arrivalDate = $arrivalDate->toServiceString();
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }

    /**
     * Get PackageTypeId value
     * @return int
     */
    public function getPackageTypeId()
    {
        return $this->PackageTypeId;
    }

    /**
     * Set PackageTypeId value
     * @param int $packageTypeId
     * @return ReferralDetailInfo
     */
    public function setPackageTypeId($packageTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($packageTypeId) && !(is_int($packageTypeId) || ctype_digit($packageTypeId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageTypeId, true), gettype($packageTypeId)), __LINE__);
        }
        $this->PackageTypeId = $packageTypeId;
        return $this;
    }

    /**
     * Get LotId value
     * @return int
     */
    public function getLotId()
    {
        return $this->LotId;
    }

    /**
     * Set LotId value
     * @param int $lotId
     * @return ReferralDetailInfo
     */
    public function setLotId($lotId = null)
    {
        // validation for constraint: int
        if (!is_null($lotId) && !(is_int($lotId) || ctype_digit($lotId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lotId, true), gettype($lotId)), __LINE__);
        }
        $this->LotId = $lotId;
        return $this;
    }

    /**
     * Get QtyRead value
     * @return int
     */
    public function getQtyRead()
    {
        return $this->QtyRead;
    }

    /**
     * Set QtyRead value
     * @param int $qtyRead
     * @return ReferralDetailInfo
     */
    public function setQtyRead($qtyRead = null)
    {
        // validation for constraint: int
        if (!is_null($qtyRead) && !(is_int($qtyRead) || ctype_digit($qtyRead))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qtyRead, true), gettype($qtyRead)), __LINE__);
        }
        $this->QtyRead = $qtyRead;
        return $this;
    }

    /**
     * Get ReferralMasterId value
     * @return int
     */
    public function getReferralMasterId()
    {
        return $this->ReferralMasterId;
    }

    /**
     * Set ReferralMasterId value
     * @param int $referralMasterId
     * @return ReferralDetailInfo
     */
    public function setReferralMasterId($referralMasterId = null)
    {
        // validation for constraint: int
        if (!is_null($referralMasterId) && !(is_int($referralMasterId) || ctype_digit($referralMasterId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referralMasterId, true), gettype($referralMasterId)), __LINE__);
        }
        $this->ReferralMasterId = $referralMasterId;
        return $this;
    }

    /**
     * Get Linetype value
     * @return LineType
     */
    public function getLinetype()
    {
        return $this->Linetype;
    }

    /**
     * Set Linetype value
     * @param LineType $linetype
     * @return ReferralDetailInfo
     */
    public function setLinetype(LineType $linetype = null)
    {
        $this->Linetype = $linetype;
        return $this;
    }

    /**
     * Get UnitPriceTra value
     * @return float
     */
    public function getUnitPriceTra()
    {
        return $this->UnitPriceTra;
    }

    /**
     * Set UnitPriceTra value
     * @param float $unitPriceTra
     * @return ReferralDetailInfo
     */
    public function setUnitPriceTra($unitPriceTra = null)
    {
        // validation for constraint: float
        if (!is_null($unitPriceTra) && !(is_float($unitPriceTra) || is_numeric($unitPriceTra))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPriceTra, true), gettype($unitPriceTra)), __LINE__);
        }
        $this->UnitPriceTra = $unitPriceTra;
        return $this;
    }

    /**
     * Get UnitId value
     * @return int
     */
    public function getUnitId()
    {
        return $this->UnitId;
    }

    /**
     * Set UnitId value
     * @param int $unitId
     * @return ReferralDetailInfo
     */
    public function setUnitId($unitId = null)
    {
        // validation for constraint: int
        if (!is_null($unitId) && !(is_int($unitId) || ctype_digit($unitId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitId, true), gettype($unitId)), __LINE__);
        }
        $this->UnitId = $unitId;
        return $this;
    }

    /**
     * Get VatStatus value
     * @return string
     */
    public function getVatStatus()
    {
        return $this->VatStatus;
    }

    /**
     * Set VatStatus value
     * @param string $vatStatus
     * @return ReferralDetailInfo
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\VatStatus::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\VatStatus::valueIsValid()
     */
    public function setVatStatus($vatStatus = null)
    {
        // validation for constraint: enumeration
        if (!VatStatus::valueIsValid($vatStatus)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\VatStatus', is_array($vatStatus) ? implode(', ', $vatStatus) : var_export($vatStatus, true), implode(', ', VatStatus::getValidValues())), __LINE__);
        }
        $this->VatStatus = $vatStatus;
        return $this;
    }

    /**
     * Get QualityId value
     * @return int
     */
    public function getQualityId()
    {
        return $this->QualityId;
    }

    /**
     * Set QualityId value
     * @param int $qualityId
     * @return ReferralDetailInfo
     */
    public function setQualityId($qualityId = null)
    {
        // validation for constraint: int
        if (!is_null($qualityId) && !(is_int($qualityId) || ctype_digit($qualityId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qualityId, true), gettype($qualityId)), __LINE__);
        }
        $this->QualityId = $qualityId;
        return $this;
    }

    /**
     * Get ColorId value
     * @return int
     */
    public function getColorId()
    {
        return $this->ColorId;
    }

    /**
     * Set ColorId value
     * @param int $colorId
     * @return ReferralDetailInfo
     */
    public function setColorId($colorId = null)
    {
        // validation for constraint: int
        if (!is_null($colorId) && !(is_int($colorId) || ctype_digit($colorId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($colorId, true), gettype($colorId)), __LINE__);
        }
        $this->ColorId = $colorId;
        return $this;
    }

    /**
     * Get ItemAttribute1Id value
     * @return int
     */
    public function getItemAttribute1Id()
    {
        return $this->ItemAttribute1Id;
    }

    /**
     * Set ItemAttribute1Id value
     * @param int $itemAttribute1Id
     * @return ReferralDetailInfo
     */
    public function setItemAttribute1Id($itemAttribute1Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemAttribute1Id) && !(is_int($itemAttribute1Id) || ctype_digit($itemAttribute1Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAttribute1Id, true), gettype($itemAttribute1Id)), __LINE__);
        }
        $this->ItemAttribute1Id = $itemAttribute1Id;
        return $this;
    }

    /**
     * Get ItemAttribute2Id value
     * @return int
     */
    public function getItemAttribute2Id()
    {
        return $this->ItemAttribute2Id;
    }

    /**
     * Set ItemAttribute2Id value
     * @param int $itemAttribute2Id
     * @return ReferralDetailInfo
     */
    public function setItemAttribute2Id($itemAttribute2Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemAttribute2Id) && !(is_int($itemAttribute2Id) || ctype_digit($itemAttribute2Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAttribute2Id, true), gettype($itemAttribute2Id)), __LINE__);
        }
        $this->ItemAttribute2Id = $itemAttribute2Id;
        return $this;
    }

    /**
     * Get ItemAttribute3Id value
     * @return int
     */
    public function getItemAttribute3Id()
    {
        return $this->ItemAttribute3Id;
    }

    /**
     * Set ItemAttribute3Id value
     * @param int $itemAttribute3Id
     * @return ReferralDetailInfo
     */
    public function setItemAttribute3Id($itemAttribute3Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemAttribute3Id) && !(is_int($itemAttribute3Id) || ctype_digit($itemAttribute3Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAttribute3Id, true), gettype($itemAttribute3Id)), __LINE__);
        }
        $this->ItemAttribute3Id = $itemAttribute3Id;
        return $this;
    }

    /**
     * Get SourceDId value
     * @return int
     */
    public function getSourceDId()
    {
        return $this->SourceDId;
    }

    /**
     * Set SourceDId value
     * @param int $sourceDId
     * @return ReferralDetailInfo
     */
    public function setSourceDId($sourceDId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceDId) && !(is_int($sourceDId) || ctype_digit($sourceDId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceDId, true), gettype($sourceDId)), __LINE__);
        }
        $this->SourceDId = $sourceDId;
        return $this;
    }

    /**
     * Get TempCoDocTraIdWaybill value
     * @return int
     */
    public function getTempCoDocTraIdWaybill()
    {
        return $this->TempCoDocTraIdWaybill;
    }

    /**
     * Set TempCoDocTraIdWaybill value
     * @param int $tempCoDocTraIdWaybill
     * @return ReferralDetailInfo
     */
    public function setTempCoDocTraIdWaybill($tempCoDocTraIdWaybill = null)
    {
        // validation for constraint: int
        if (!is_null($tempCoDocTraIdWaybill) && !(is_int($tempCoDocTraIdWaybill) || ctype_digit($tempCoDocTraIdWaybill))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tempCoDocTraIdWaybill, true), gettype($tempCoDocTraIdWaybill)), __LINE__);
        }
        $this->TempCoDocTraIdWaybill = $tempCoDocTraIdWaybill;
        return $this;
    }

    /**
     * Get IsserialTrack value
     * @return bool
     */
    public function getIsserialTrack()
    {
        return $this->IsserialTrack;
    }

    /**
     * Set IsserialTrack value
     * @param bool $isserialTrack
     * @return ReferralDetailInfo
     */
    public function setIsserialTrack($isserialTrack = null)
    {
        // validation for constraint: boolean
        if (!is_null($isserialTrack) && !is_bool($isserialTrack)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isserialTrack, true), gettype($isserialTrack)), __LINE__);
        }
        $this->IsserialTrack = $isserialTrack;
        return $this;
    }

    /**
     * Get SalesToleranceMaxSo value
     * @return float
     */
    public function getSalesToleranceMaxSo()
    {
        return $this->SalesToleranceMaxSo;
    }

    /**
     * Set SalesToleranceMaxSo value
     * @param float $salesToleranceMaxSo
     * @return ReferralDetailInfo
     */
    public function setSalesToleranceMaxSo($salesToleranceMaxSo = null)
    {
        // validation for constraint: float
        if (!is_null($salesToleranceMaxSo) && !(is_float($salesToleranceMaxSo) || is_numeric($salesToleranceMaxSo))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesToleranceMaxSo, true), gettype($salesToleranceMaxSo)), __LINE__);
        }
        $this->SalesToleranceMaxSo = $salesToleranceMaxSo;
        return $this;
    }

    /**
     * Get UnitFactor value
     * @return float
     */
    public function getUnitFactor()
    {
        return $this->UnitFactor;
    }

    /**
     * Set UnitFactor value
     * @param float $unitFactor
     * @return ReferralDetailInfo
     */
    public function setUnitFactor($unitFactor = null)
    {
        // validation for constraint: float
        if (!is_null($unitFactor) && !(is_float($unitFactor) || is_numeric($unitFactor))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitFactor, true), gettype($unitFactor)), __LINE__);
        }
        $this->UnitFactor = $unitFactor;
        return $this;
    }

    /**
     * Get TempCoDocTraIsTransfer value
     * @return bool
     */
    public function getTempCoDocTraIsTransfer()
    {
        return $this->TempCoDocTraIsTransfer;
    }

    /**
     * Set TempCoDocTraIsTransfer value
     * @param bool $tempCoDocTraIsTransfer
     * @return ReferralDetailInfo
     */
    public function setTempCoDocTraIsTransfer($tempCoDocTraIsTransfer = null)
    {
        // validation for constraint: boolean
        if (!is_null($tempCoDocTraIsTransfer) && !is_bool($tempCoDocTraIsTransfer)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tempCoDocTraIsTransfer, true), gettype($tempCoDocTraIsTransfer)), __LINE__);
        }
        $this->TempCoDocTraIsTransfer = $tempCoDocTraIsTransfer;
        return $this;
    }

    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }

    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return ReferralDetailInfo
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }

    /**
     * Get ItemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->ItemName;
    }

    /**
     * Set ItemName value
     * @param string $itemName
     * @return ReferralDetailInfo
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->ItemName = $itemName;
        return $this;
    }

    /**
     * Get WhouseCode value
     * @return string|null
     */
    public function getWhouseCode()
    {
        return $this->WhouseCode;
    }

    /**
     * Set WhouseCode value
     * @param string $whouseCode
     * @return ReferralDetailInfo
     */
    public function setWhouseCode($whouseCode = null)
    {
        // validation for constraint: string
        if (!is_null($whouseCode) && !is_string($whouseCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whouseCode, true), gettype($whouseCode)), __LINE__);
        }
        $this->WhouseCode = $whouseCode;
        return $this;
    }

    /**
     * Get PackageTypeCode value
     * @return string|null
     */
    public function getPackageTypeCode()
    {
        return $this->PackageTypeCode;
    }

    /**
     * Set PackageTypeCode value
     * @param string $packageTypeCode
     * @return ReferralDetailInfo
     */
    public function setPackageTypeCode($packageTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($packageTypeCode) && !is_string($packageTypeCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageTypeCode, true), gettype($packageTypeCode)), __LINE__);
        }
        $this->PackageTypeCode = $packageTypeCode;
        return $this;
    }

    /**
     * Get OrderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->OrderNo;
    }

    /**
     * Set OrderNo value
     * @param string $orderNo
     * @return ReferralDetailInfo
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNo, true), gettype($orderNo)), __LINE__);
        }
        $this->OrderNo = $orderNo;
        return $this;
    }

    /**
     * Get LotCode value
     * @return string|null
     */
    public function getLotCode()
    {
        return $this->LotCode;
    }

    /**
     * Set LotCode value
     * @param string $lotCode
     * @return ReferralDetailInfo
     */
    public function setLotCode($lotCode = null)
    {
        // validation for constraint: string
        if (!is_null($lotCode) && !is_string($lotCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lotCode, true), gettype($lotCode)), __LINE__);
        }
        $this->LotCode = $lotCode;
        return $this;
    }

    /**
     * Get Note1 value
     * @return string|null
     */
    public function getNote1()
    {
        return $this->Note1;
    }

    /**
     * Set Note1 value
     * @param string $note1
     * @return ReferralDetailInfo
     */
    public function setNote1($note1 = null)
    {
        // validation for constraint: string
        if (!is_null($note1) && !is_string($note1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note1, true), gettype($note1)), __LINE__);
        }
        $this->Note1 = $note1;
        return $this;
    }

    /**
     * Get Note2 value
     * @return string|null
     */
    public function getNote2()
    {
        return $this->Note2;
    }

    /**
     * Set Note2 value
     * @param string $note2
     * @return ReferralDetailInfo
     */
    public function setNote2($note2 = null)
    {
        // validation for constraint: string
        if (!is_null($note2) && !is_string($note2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note2, true), gettype($note2)), __LINE__);
        }
        $this->Note2 = $note2;
        return $this;
    }

    /**
     * Get VatCode value
     * @return string|null
     */
    public function getVatCode()
    {
        return $this->VatCode;
    }

    /**
     * Set VatCode value
     * @param string $vatCode
     * @return ReferralDetailInfo
     */
    public function setVatCode($vatCode = null)
    {
        // validation for constraint: string
        if (!is_null($vatCode) && !is_string($vatCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatCode, true), gettype($vatCode)), __LINE__);
        }
        $this->VatCode = $vatCode;
        return $this;
    }

    /**
     * Get QualityCode value
     * @return string|null
     */
    public function getQualityCode()
    {
        return $this->QualityCode;
    }

    /**
     * Set QualityCode value
     * @param string $qualityCode
     * @return ReferralDetailInfo
     */
    public function setQualityCode($qualityCode = null)
    {
        // validation for constraint: string
        if (!is_null($qualityCode) && !is_string($qualityCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualityCode, true), gettype($qualityCode)), __LINE__);
        }
        $this->QualityCode = $qualityCode;
        return $this;
    }

    /**
     * Get ColorCode value
     * @return string|null
     */
    public function getColorCode()
    {
        return $this->ColorCode;
    }

    /**
     * Set ColorCode value
     * @param string $colorCode
     * @return ReferralDetailInfo
     */
    public function setColorCode($colorCode = null)
    {
        // validation for constraint: string
        if (!is_null($colorCode) && !is_string($colorCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorCode, true), gettype($colorCode)), __LINE__);
        }
        $this->ColorCode = $colorCode;
        return $this;
    }

    /**
     * Get ItemAttribute1Code value
     * @return string|null
     */
    public function getItemAttribute1Code()
    {
        return $this->ItemAttribute1Code;
    }

    /**
     * Set ItemAttribute1Code value
     * @param string $itemAttribute1Code
     * @return ReferralDetailInfo
     */
    public function setItemAttribute1Code($itemAttribute1Code = null)
    {
        // validation for constraint: string
        if (!is_null($itemAttribute1Code) && !is_string($itemAttribute1Code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemAttribute1Code, true), gettype($itemAttribute1Code)), __LINE__);
        }
        $this->ItemAttribute1Code = $itemAttribute1Code;
        return $this;
    }

    /**
     * Get ItemAttribute2Code value
     * @return string|null
     */
    public function getItemAttribute2Code()
    {
        return $this->ItemAttribute2Code;
    }

    /**
     * Set ItemAttribute2Code value
     * @param string $itemAttribute2Code
     * @return ReferralDetailInfo
     */
    public function setItemAttribute2Code($itemAttribute2Code = null)
    {
        // validation for constraint: string
        if (!is_null($itemAttribute2Code) && !is_string($itemAttribute2Code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemAttribute2Code, true), gettype($itemAttribute2Code)), __LINE__);
        }
        $this->ItemAttribute2Code = $itemAttribute2Code;
        return $this;
    }

    /**
     * Get ItemAttribute3Code value
     * @return string|null
     */
    public function getItemAttribute3Code()
    {
        return $this->ItemAttribute3Code;
    }

    /**
     * Set ItemAttribute3Code value
     * @param string $itemAttribute3Code
     * @return ReferralDetailInfo
     */
    public function setItemAttribute3Code($itemAttribute3Code = null)
    {
        // validation for constraint: string
        if (!is_null($itemAttribute3Code) && !is_string($itemAttribute3Code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemAttribute3Code, true), gettype($itemAttribute3Code)), __LINE__);
        }
        $this->ItemAttribute3Code = $itemAttribute3Code;
        return $this;
    }

    /**
     * Get IncotermsName value
     * @return string|null
     */
    public function getIncotermsName()
    {
        return $this->IncotermsName;
    }

    /**
     * Set IncotermsName value
     * @param string $incotermsName
     * @return ReferralDetailInfo
     */
    public function setIncotermsName($incotermsName = null)
    {
        // validation for constraint: string
        if (!is_null($incotermsName) && !is_string($incotermsName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incotermsName, true), gettype($incotermsName)), __LINE__);
        }
        $this->IncotermsName = $incotermsName;
        return $this;
    }

    /**
     * Get PaymentMethodDesc value
     * @return string|null
     */
    public function getPaymentMethodDesc()
    {
        return $this->PaymentMethodDesc;
    }

    /**
     * Set PaymentMethodDesc value
     * @param string $paymentMethodDesc
     * @return ReferralDetailInfo
     */
    public function setPaymentMethodDesc($paymentMethodDesc = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodDesc) && !is_string($paymentMethodDesc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodDesc, true), gettype($paymentMethodDesc)), __LINE__);
        }
        $this->PaymentMethodDesc = $paymentMethodDesc;
        return $this;
    }

    /**
     * Get ItemAddString01 value
     * @return string|null
     */
    public function getItemAddString01()
    {
        return $this->ItemAddString01;
    }

    /**
     * Set ItemAddString01 value
     * @param string $itemAddString01
     * @return ReferralDetailInfo
     */
    public function setItemAddString01($itemAddString01 = null)
    {
        // validation for constraint: string
        if (!is_null($itemAddString01) && !is_string($itemAddString01)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemAddString01, true), gettype($itemAddString01)), __LINE__);
        }
        $this->ItemAddString01 = $itemAddString01;
        return $this;
    }

    /**
     * Get TempCoDocTraCodeWaybill value
     * @return string|null
     */
    public function getTempCoDocTraCodeWaybill()
    {
        return $this->TempCoDocTraCodeWaybill;
    }

    /**
     * Set TempCoDocTraCodeWaybill value
     * @param string $tempCoDocTraCodeWaybill
     * @return ReferralDetailInfo
     */
    public function setTempCoDocTraCodeWaybill($tempCoDocTraCodeWaybill = null)
    {
        // validation for constraint: string
        if (!is_null($tempCoDocTraCodeWaybill) && !is_string($tempCoDocTraCodeWaybill)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tempCoDocTraCodeWaybill, true), gettype($tempCoDocTraCodeWaybill)), __LINE__);
        }
        $this->TempCoDocTraCodeWaybill = $tempCoDocTraCodeWaybill;
        return $this;
    }
}
