<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;

/**
 * This class stands for OfferDetailDef StructType
 * @subpackage Structs
 */
class OfferDetailDef extends TransactionalDetailFields
{
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The ExpenseId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ExpenseId;

    /**
     * Constructor method for OfferDetailDef
     * @param int $itemId
     * @param int $expenseId
     * @uses OfferDetailDef::setItemId()
     * @uses OfferDetailDef::setExpenseId()
     */
    public function __construct($itemId = null, $expenseId = null)
    {
        parent::__construct();
        $this
            ->setItemId($itemId)
            ->setExpenseId($expenseId);
    }

    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }

    /**
     * Set ItemId value
     * @param int $itemId
     * @return OfferDetailDef
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }

    /**
     * Get ExpenseId value
     * @return int
     */
    public function getExpenseId()
    {
        return $this->ExpenseId;
    }

    /**
     * Set ExpenseId value
     * @param int $expenseId
     * @return OfferDetailDef
     */
    public function setExpenseId($expenseId = null)
    {
        // validation for constraint: int
        if (!is_null($expenseId) && !(is_int($expenseId) || ctype_digit($expenseId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expenseId, true), gettype($expenseId)), __LINE__);
        }
        $this->ExpenseId = $expenseId;
        return $this;
    }
}
