<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewGenerationPaymentRecorderInformation StructType
 * @subpackage Structs
 */
class NewGenerationPaymentRecorderInformation extends AbstractStructBase
{
    /**
     * The PaperDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PaperDate;
    /**
     * The PaperNumber
     * @var string
     */
    public $PaperNumber;
    /**
     * The SerialNumber
     * @var string
     */
    public $SerialNumber;
    /**
     * The ZNumber
     * @var string
     */
    public $ZNumber;

    /**
     * Constructor method for NewGenerationPaymentRecorderInformation
     * @param string|GekDateTime $paperDate
     * @param string $paperNumber
     * @param string $serialNumber
     * @param string $zNumber
     * @uses NewGenerationPaymentRecorderInformation::setPaperDate()
     * @uses NewGenerationPaymentRecorderInformation::setPaperNumber()
     * @uses NewGenerationPaymentRecorderInformation::setSerialNumber()
     * @uses NewGenerationPaymentRecorderInformation::setZNumber()
     */
    public function __construct($paperDate = null, $paperNumber = null, $serialNumber = null, $zNumber = null)
    {
        $this
            ->setPaperDate($paperDate)
            ->setPaperNumber($paperNumber)
            ->setSerialNumber($serialNumber)
            ->setZNumber($zNumber);
    }

    /**
     * Get PaperDate value
     * @return string
     */
    public function getPaperDate()
    {
        return $this->PaperDate;
    }

    /**
     * Set PaperDate value
     * @param string|GekDateTime $paperDate
     * @return NewGenerationPaymentRecorderInformation
     */
    public function setPaperDate($paperDate = null)
    {
        // validation for constraint: string
        if (!is_null($paperDate) && !is_string($paperDate) && !($paperDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paperDate, true), gettype($paperDate)), __LINE__);
        }
        if ($paperDate instanceof GekDateTime) {
            $paperDate = $paperDate->toServiceString();
        }
        $this->PaperDate = $paperDate;
        return $this;
    }

    /**
     * Get PaperNumber value
     * @return string|null
     */
    public function getPaperNumber()
    {
        return $this->PaperNumber;
    }

    /**
     * Set PaperNumber value
     * @param string $paperNumber
     * @return NewGenerationPaymentRecorderInformation
     */
    public function setPaperNumber($paperNumber = null)
    {
        // validation for constraint: string
        if (!is_null($paperNumber) && !is_string($paperNumber)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paperNumber, true), gettype($paperNumber)), __LINE__);
        }
        $this->PaperNumber = $paperNumber;
        return $this;
    }

    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }

    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return NewGenerationPaymentRecorderInformation
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }

    /**
     * Get ZNumber value
     * @return string|null
     */
    public function getZNumber()
    {
        return $this->ZNumber;
    }

    /**
     * Set ZNumber value
     * @param string $zNumber
     * @return NewGenerationPaymentRecorderInformation
     */
    public function setZNumber($zNumber = null)
    {
        // validation for constraint: string
        if (!is_null($zNumber) && !is_string($zNumber)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zNumber, true), gettype($zNumber)), __LINE__);
        }
        $this->ZNumber = $zNumber;
        return $this;
    }
}
