<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\EnumType\PurchaseSales;
use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemTaxCardDef StructType
 * @subpackage Structs
 */
class ItemTaxCardDef extends AbstractStructBase
{
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CountryId;
    /**
     * The TaxId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TaxId;
    /**
     * The PurchaseSales
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PurchaseSales;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The IsoCountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IsoCountryCode;
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxCode;

    /**
     * Constructor method for ItemTaxCardDef
     * @param int $countryId
     * @param int $taxId
     * @param string $purchaseSales
     * @param string|GekDateTime $startDate
     * @param string|GekDateTime $endDate
     * @param string $countryCode
     * @param string $isoCountryCode
     * @param string $taxCode
     * @uses ItemTaxCardDef::setCountryId()
     * @uses ItemTaxCardDef::setTaxId()
     * @uses ItemTaxCardDef::setPurchaseSales()
     * @uses ItemTaxCardDef::setStartDate()
     * @uses ItemTaxCardDef::setEndDate()
     * @uses ItemTaxCardDef::setCountryCode()
     * @uses ItemTaxCardDef::setIsoCountryCode()
     * @uses ItemTaxCardDef::setTaxCode()
     */
    public function __construct($countryId = null, $taxId = null, $purchaseSales = null, $startDate = null, $endDate = null, $countryCode = null, $isoCountryCode = null, $taxCode = null)
    {
        $this
            ->setCountryId($countryId)
            ->setTaxId($taxId)
            ->setPurchaseSales($purchaseSales)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setCountryCode($countryCode)
            ->setIsoCountryCode($isoCountryCode)
            ->setTaxCode($taxCode);
    }

    /**
     * Get CountryId value
     * @return int
     */
    public function getCountryId()
    {
        return $this->CountryId;
    }

    /**
     * Set CountryId value
     * @param int $countryId
     * @return ItemTaxCardDef
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: int
        if (!is_null($countryId) && !(is_int($countryId) || ctype_digit($countryId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        $this->CountryId = $countryId;
        return $this;
    }

    /**
     * Get TaxId value
     * @return int
     */
    public function getTaxId()
    {
        return $this->TaxId;
    }

    /**
     * Set TaxId value
     * @param int $taxId
     * @return ItemTaxCardDef
     */
    public function setTaxId($taxId = null)
    {
        // validation for constraint: int
        if (!is_null($taxId) && !(is_int($taxId) || ctype_digit($taxId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxId, true), gettype($taxId)), __LINE__);
        }
        $this->TaxId = $taxId;
        return $this;
    }

    /**
     * Get PurchaseSales value
     * @return string
     */
    public function getPurchaseSales()
    {
        return $this->PurchaseSales;
    }

    /**
     * Set PurchaseSales value
     * @param string $purchaseSales
     * @return ItemTaxCardDef
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\PurchaseSales::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\PurchaseSales::valueIsValid()
     */
    public function setPurchaseSales($purchaseSales = null)
    {
        // validation for constraint: enumeration
        if (!PurchaseSales::valueIsValid($purchaseSales)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\PurchaseSales', is_array($purchaseSales) ? implode(', ', $purchaseSales) : var_export($purchaseSales, true), implode(', ', PurchaseSales::getValidValues())), __LINE__);
        }
        $this->PurchaseSales = $purchaseSales;
        return $this;
    }

    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }

    /**
     * Set StartDate value
     * @param string|GekDateTime $startDate
     * @return ItemTaxCardDef
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate) && !($startDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if ($startDate instanceof GekDateTime) {
            $startDate = $startDate->toServiceString();
        }
        $this->StartDate = $startDate;
        return $this;
    }

    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }

    /**
     * Set EndDate value
     * @param string|GekDateTime $endDate
     * @return ItemTaxCardDef
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate) && !($endDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if ($endDate instanceof GekDateTime) {
            $endDate = $endDate->toServiceString();
        }
        $this->EndDate = $endDate;
        return $this;
    }

    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }

    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return ItemTaxCardDef
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }

    /**
     * Get IsoCountryCode value
     * @return string|null
     */
    public function getIsoCountryCode()
    {
        return $this->IsoCountryCode;
    }

    /**
     * Set IsoCountryCode value
     * @param string $isoCountryCode
     * @return ItemTaxCardDef
     */
    public function setIsoCountryCode($isoCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($isoCountryCode) && !is_string($isoCountryCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isoCountryCode, true), gettype($isoCountryCode)), __LINE__);
        }
        $this->IsoCountryCode = $isoCountryCode;
        return $this;
    }

    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }

    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return ItemTaxCardDef
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
}
