<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\ArrayType\ArrayOfItemDetailDef;
use Gek\UyumBahce\EnumType\InvoiceStatus;
use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;

/**
 * This class stands for ItemDef StructType
 * @subpackage Structs
 */
class ItemDef extends TransactionalMasterFields
{
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EntityId;
    /**
     * The WhouseId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WhouseId;
    /**
     * The WhouseId2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WhouseId2;
    /**
     * The ProjectMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ProjectMId;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Longitude;
    /**
     * The Disc0Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Disc0Id;
    /**
     * The Disc0Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Disc0Rate;
    /**
     * The InvoiceStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InvoiceStatus;
    /**
     * The ReceiptDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReceiptDate;
    /**
     * The IsWaybil
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsWaybil;
    /**
     * The DontControlnegative
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $DontControlnegative;
    /**
     * The RiskControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RiskControl;
    /**
     * The VehicleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $VehicleId;
    /**
     * The ActualDespatchDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ActualDespatchDate;
    /**
     * The ForTransfer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ForTransfer;
    /**
     * The EntityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityCode;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardCode;
    /**
     * The VoucherNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherNo;
    /**
     * The VoucherSerial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherSerial;
    /**
     * The WhouseCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WhouseCode;
    /**
     * The WhouseCode2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WhouseCode2;
    /**
     * The SourceGuid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceGuid;
    /**
     * The VehicleCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleCode;
    /**
     * The DriverIdentifyNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverIdentifyNo;
    /**
     * The LicensePlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The DriverIdentityNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverIdentityNo;
    /**
     * The DriverName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverName;
    /**
     * The DriverFamilyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverFamilyName;
    /**
     * The DriverGsmNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverGsmNo;
    /**
     * The DriverNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverNote;
    /**
     * The TrailerPlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrailerPlate;
    /**
     * The StartTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartTime;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfItemDetailDef
     */
    public $Details;
    /**
     * The ETTN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ETTN;
    /**
     * The TransportEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransportEquipment;
    /**
     * The ShippingDesc1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingDesc1;

    /**
     * Constructor method for ItemDef
     * @param int $entityId
     * @param int $whouseId
     * @param int $whouseId2
     * @param int $projectMId
     * @param float $latitude
     * @param float $longitude
     * @param int $disc0Id
     * @param float $disc0Rate
     * @param string $invoiceStatus
     * @param string|GekDateTime $receiptDate
     * @param bool $isWaybil
     * @param bool $dontControlnegative
     * @param bool $riskControl
     * @param int $vehicleId
     * @param string|GekDateTime $actualDespatchDate
     * @param bool $forTransfer
     * @param string $entityCode
     * @param string $cardCode
     * @param string $voucherNo
     * @param string $voucherSerial
     * @param string $whouseCode
     * @param string $whouseCode2
     * @param string $sourceGuid
     * @param string $vehicleCode
     * @param string $driverIdentifyNo
     * @param string $licensePlate
     * @param string $driverIdentityNo
     * @param string $driverName
     * @param string $driverFamilyName
     * @param string $driverGsmNo
     * @param string $driverNote
     * @param string $trailerPlate
     * @param string $startTime
     * @param ArrayOfItemDetailDef $details
     * @param string $eTTN
     * @param string $transportEquipment
     * @param string $shippingDesc1
     * @uses ItemDef::setEntityId()
     * @uses ItemDef::setWhouseId()
     * @uses ItemDef::setWhouseId2()
     * @uses ItemDef::setProjectMId()
     * @uses ItemDef::setLatitude()
     * @uses ItemDef::setLongitude()
     * @uses ItemDef::setDisc0Id()
     * @uses ItemDef::setDisc0Rate()
     * @uses ItemDef::setInvoiceStatus()
     * @uses ItemDef::setReceiptDate()
     * @uses ItemDef::setIsWaybil()
     * @uses ItemDef::setDontControlnegative()
     * @uses ItemDef::setRiskControl()
     * @uses ItemDef::setVehicleId()
     * @uses ItemDef::setActualDespatchDate()
     * @uses ItemDef::setForTransfer()
     * @uses ItemDef::setEntityCode()
     * @uses ItemDef::setCardCode()
     * @uses ItemDef::setVoucherNo()
     * @uses ItemDef::setVoucherSerial()
     * @uses ItemDef::setWhouseCode()
     * @uses ItemDef::setWhouseCode2()
     * @uses ItemDef::setSourceGuid()
     * @uses ItemDef::setVehicleCode()
     * @uses ItemDef::setDriverIdentifyNo()
     * @uses ItemDef::setLicensePlate()
     * @uses ItemDef::setDriverIdentityNo()
     * @uses ItemDef::setDriverName()
     * @uses ItemDef::setDriverFamilyName()
     * @uses ItemDef::setDriverGsmNo()
     * @uses ItemDef::setDriverNote()
     * @uses ItemDef::setTrailerPlate()
     * @uses ItemDef::setStartTime()
     * @uses ItemDef::setDetails()
     * @uses ItemDef::setETTN()
     * @uses ItemDef::setTransportEquipment()
     * @uses ItemDef::setShippingDesc1()
     */
    public function __construct($entityId = null, $whouseId = null, $whouseId2 = null, $projectMId = null, $latitude = null, $longitude = null, $disc0Id = null, $disc0Rate = null, $invoiceStatus = null, $receiptDate = null, $isWaybil = null, $dontControlnegative = null, $riskControl = null, $vehicleId = null, $actualDespatchDate = null, $forTransfer = null, $entityCode = null, $cardCode = null, $voucherNo = null, $voucherSerial = null, $whouseCode = null, $whouseCode2 = null, $sourceGuid = null, $vehicleCode = null, $driverIdentifyNo = null, $licensePlate = null, $driverIdentityNo = null, $driverName = null, $driverFamilyName = null, $driverGsmNo = null, $driverNote = null, $trailerPlate = null, $startTime = null, ArrayOfItemDetailDef $details = null, $eTTN = null, $transportEquipment = null, $shippingDesc1 = null)
    {
        $this
            ->setEntityId($entityId)
            ->setWhouseId($whouseId)
            ->setWhouseId2($whouseId2)
            ->setProjectMId($projectMId)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setDisc0Id($disc0Id)
            ->setDisc0Rate($disc0Rate)
            ->setInvoiceStatus($invoiceStatus)
            ->setReceiptDate($receiptDate)
            ->setIsWaybil($isWaybil)
            ->setDontControlnegative($dontControlnegative)
            ->setRiskControl($riskControl)
            ->setVehicleId($vehicleId)
            ->setActualDespatchDate($actualDespatchDate)
            ->setForTransfer($forTransfer)
            ->setEntityCode($entityCode)
            ->setCardCode($cardCode)
            ->setVoucherNo($voucherNo)
            ->setVoucherSerial($voucherSerial)
            ->setWhouseCode($whouseCode)
            ->setWhouseCode2($whouseCode2)
            ->setSourceGuid($sourceGuid)
            ->setVehicleCode($vehicleCode)
            ->setDriverIdentifyNo($driverIdentifyNo)
            ->setLicensePlate($licensePlate)
            ->setDriverIdentityNo($driverIdentityNo)
            ->setDriverName($driverName)
            ->setDriverFamilyName($driverFamilyName)
            ->setDriverGsmNo($driverGsmNo)
            ->setDriverNote($driverNote)
            ->setTrailerPlate($trailerPlate)
            ->setStartTime($startTime)
            ->setDetails($details)
            ->setETTN($eTTN)
            ->setTransportEquipment($transportEquipment)
            ->setShippingDesc1($shippingDesc1);
    }

    /**
     * Get EntityId value
     * @return int
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }

    /**
     * Set EntityId value
     * @param int $entityId
     * @return ItemDef
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }

    /**
     * Get WhouseId value
     * @return int
     */
    public function getWhouseId()
    {
        return $this->WhouseId;
    }

    /**
     * Set WhouseId value
     * @param int $whouseId
     * @return ItemDef
     */
    public function setWhouseId($whouseId = null)
    {
        // validation for constraint: int
        if (!is_null($whouseId) && !(is_int($whouseId) || ctype_digit($whouseId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($whouseId, true), gettype($whouseId)), __LINE__);
        }
        $this->WhouseId = $whouseId;
        return $this;
    }

    /**
     * Get WhouseId2 value
     * @return int
     */
    public function getWhouseId2()
    {
        return $this->WhouseId2;
    }

    /**
     * Set WhouseId2 value
     * @param int $whouseId2
     * @return ItemDef
     */
    public function setWhouseId2($whouseId2 = null)
    {
        // validation for constraint: int
        if (!is_null($whouseId2) && !(is_int($whouseId2) || ctype_digit($whouseId2))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($whouseId2, true), gettype($whouseId2)), __LINE__);
        }
        $this->WhouseId2 = $whouseId2;
        return $this;
    }

    /**
     * Get ProjectMId value
     * @return int
     */
    public function getProjectMId()
    {
        return $this->ProjectMId;
    }

    /**
     * Set ProjectMId value
     * @param int $projectMId
     * @return ItemDef
     */
    public function setProjectMId($projectMId = null)
    {
        // validation for constraint: int
        if (!is_null($projectMId) && !(is_int($projectMId) || ctype_digit($projectMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($projectMId, true), gettype($projectMId)), __LINE__);
        }
        $this->ProjectMId = $projectMId;
        return $this;
    }

    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }

    /**
     * Set Latitude value
     * @param float $latitude
     * @return ItemDef
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }

    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }

    /**
     * Set Longitude value
     * @param float $longitude
     * @return ItemDef
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }

    /**
     * Get Disc0Id value
     * @return int
     */
    public function getDisc0Id()
    {
        return $this->Disc0Id;
    }

    /**
     * Set Disc0Id value
     * @param int $disc0Id
     * @return ItemDef
     */
    public function setDisc0Id($disc0Id = null)
    {
        // validation for constraint: int
        if (!is_null($disc0Id) && !(is_int($disc0Id) || ctype_digit($disc0Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($disc0Id, true), gettype($disc0Id)), __LINE__);
        }
        $this->Disc0Id = $disc0Id;
        return $this;
    }

    /**
     * Get Disc0Rate value
     * @return float
     */
    public function getDisc0Rate()
    {
        return $this->Disc0Rate;
    }

    /**
     * Set Disc0Rate value
     * @param float $disc0Rate
     * @return ItemDef
     */
    public function setDisc0Rate($disc0Rate = null)
    {
        // validation for constraint: float
        if (!is_null($disc0Rate) && !(is_float($disc0Rate) || is_numeric($disc0Rate))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disc0Rate, true), gettype($disc0Rate)), __LINE__);
        }
        $this->Disc0Rate = $disc0Rate;
        return $this;
    }

    /**
     * Get InvoiceStatus value
     * @return string
     */
    public function getInvoiceStatus()
    {
        return $this->InvoiceStatus;
    }

    /**
     * Set InvoiceStatus value
     * @param string $invoiceStatus
     * @return ItemDef
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\InvoiceStatus::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\InvoiceStatus::valueIsValid()
     */
    public function setInvoiceStatus($invoiceStatus = null)
    {
        // validation for constraint: enumeration
        if (!InvoiceStatus::valueIsValid($invoiceStatus)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\InvoiceStatus', is_array($invoiceStatus) ? implode(', ', $invoiceStatus) : var_export($invoiceStatus, true), implode(', ', InvoiceStatus::getValidValues())), __LINE__);
        }
        $this->InvoiceStatus = $invoiceStatus;
        return $this;
    }

    /**
     * Get ReceiptDate value
     * @return string
     */
    public function getReceiptDate()
    {
        return $this->ReceiptDate;
    }

    /**
     * Set ReceiptDate value
     * @param string|GekDateTime $receiptDate
     * @return ItemDef
     */
    public function setReceiptDate($receiptDate = null)
    {
        // validation for constraint: string
        if (!is_null($receiptDate) && !is_string($receiptDate) && !($receiptDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptDate, true), gettype($receiptDate)), __LINE__);
        }
        if ($receiptDate instanceof GekDateTime) {
            $receiptDate = $receiptDate->toServiceString();
        }
        $this->ReceiptDate = $receiptDate;
        return $this;
    }

    /**
     * Get IsWaybil value
     * @return bool
     */
    public function getIsWaybil()
    {
        return $this->IsWaybil;
    }

    /**
     * Set IsWaybil value
     * @param bool $isWaybil
     * @return ItemDef
     */
    public function setIsWaybil($isWaybil = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWaybil) && !is_bool($isWaybil)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWaybil, true), gettype($isWaybil)), __LINE__);
        }
        $this->IsWaybil = $isWaybil;
        return $this;
    }

    /**
     * Get DontControlnegative value
     * @return bool
     */
    public function getDontControlnegative()
    {
        return $this->DontControlnegative;
    }

    /**
     * Set DontControlnegative value
     * @param bool $dontControlnegative
     * @return ItemDef
     */
    public function setDontControlnegative($dontControlnegative = null)
    {
        // validation for constraint: boolean
        if (!is_null($dontControlnegative) && !is_bool($dontControlnegative)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dontControlnegative, true), gettype($dontControlnegative)), __LINE__);
        }
        $this->DontControlnegative = $dontControlnegative;
        return $this;
    }

    /**
     * Get RiskControl value
     * @return bool
     */
    public function getRiskControl()
    {
        return $this->RiskControl;
    }

    /**
     * Set RiskControl value
     * @param bool $riskControl
     * @return ItemDef
     */
    public function setRiskControl($riskControl = null)
    {
        // validation for constraint: boolean
        if (!is_null($riskControl) && !is_bool($riskControl)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($riskControl, true), gettype($riskControl)), __LINE__);
        }
        $this->RiskControl = $riskControl;
        return $this;
    }

    /**
     * Get VehicleId value
     * @return int
     */
    public function getVehicleId()
    {
        return $this->VehicleId;
    }

    /**
     * Set VehicleId value
     * @param int $vehicleId
     * @return ItemDef
     */
    public function setVehicleId($vehicleId = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleId) && !(is_int($vehicleId) || ctype_digit($vehicleId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleId, true), gettype($vehicleId)), __LINE__);
        }
        $this->VehicleId = $vehicleId;
        return $this;
    }

    /**
     * Get ActualDespatchDate value
     * @return string
     */
    public function getActualDespatchDate()
    {
        return $this->ActualDespatchDate;
    }

    /**
     * Set ActualDespatchDate value
     * @param string|GekDateTime $actualDespatchDate
     * @return ItemDef
     */
    public function setActualDespatchDate($actualDespatchDate = null)
    {
        // validation for constraint: string
        if (!is_null($actualDespatchDate) && !is_string($actualDespatchDate) && !($actualDespatchDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualDespatchDate, true), gettype($actualDespatchDate)), __LINE__);
        }
        if ($actualDespatchDate instanceof GekDateTime) {
            $actualDespatchDate = $actualDespatchDate->toServiceString();
        }
        $this->ActualDespatchDate = $actualDespatchDate;
        return $this;
    }

    /**
     * Get ForTransfer value
     * @return bool
     */
    public function getForTransfer()
    {
        return $this->ForTransfer;
    }

    /**
     * Set ForTransfer value
     * @param bool $forTransfer
     * @return ItemDef
     */
    public function setForTransfer($forTransfer = null)
    {
        // validation for constraint: boolean
        if (!is_null($forTransfer) && !is_bool($forTransfer)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forTransfer, true), gettype($forTransfer)), __LINE__);
        }
        $this->ForTransfer = $forTransfer;
        return $this;
    }

    /**
     * Get EntityCode value
     * @return string|null
     */
    public function getEntityCode()
    {
        return $this->EntityCode;
    }

    /**
     * Set EntityCode value
     * @param string $entityCode
     * @return ItemDef
     */
    public function setEntityCode($entityCode = null)
    {
        // validation for constraint: string
        if (!is_null($entityCode) && !is_string($entityCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityCode, true), gettype($entityCode)), __LINE__);
        }
        $this->EntityCode = $entityCode;
        return $this;
    }

    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }

    /**
     * Set CardCode value
     * @param string $cardCode
     * @return ItemDef
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }

    /**
     * Get VoucherNo value
     * @return string|null
     */
    public function getVoucherNo()
    {
        return $this->VoucherNo;
    }

    /**
     * Set VoucherNo value
     * @param string $voucherNo
     * @return ItemDef
     */
    public function setVoucherNo($voucherNo = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNo) && !is_string($voucherNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNo, true), gettype($voucherNo)), __LINE__);
        }
        $this->VoucherNo = $voucherNo;
        return $this;
    }

    /**
     * Get VoucherSerial value
     * @return string|null
     */
    public function getVoucherSerial()
    {
        return $this->VoucherSerial;
    }

    /**
     * Set VoucherSerial value
     * @param string $voucherSerial
     * @return ItemDef
     */
    public function setVoucherSerial($voucherSerial = null)
    {
        // validation for constraint: string
        if (!is_null($voucherSerial) && !is_string($voucherSerial)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherSerial, true), gettype($voucherSerial)), __LINE__);
        }
        $this->VoucherSerial = $voucherSerial;
        return $this;
    }

    /**
     * Get WhouseCode value
     * @return string|null
     */
    public function getWhouseCode()
    {
        return $this->WhouseCode;
    }

    /**
     * Set WhouseCode value
     * @param string $whouseCode
     * @return ItemDef
     */
    public function setWhouseCode($whouseCode = null)
    {
        // validation for constraint: string
        if (!is_null($whouseCode) && !is_string($whouseCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whouseCode, true), gettype($whouseCode)), __LINE__);
        }
        $this->WhouseCode = $whouseCode;
        return $this;
    }

    /**
     * Get WhouseCode2 value
     * @return string|null
     */
    public function getWhouseCode2()
    {
        return $this->WhouseCode2;
    }

    /**
     * Set WhouseCode2 value
     * @param string $whouseCode2
     * @return ItemDef
     */
    public function setWhouseCode2($whouseCode2 = null)
    {
        // validation for constraint: string
        if (!is_null($whouseCode2) && !is_string($whouseCode2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whouseCode2, true), gettype($whouseCode2)), __LINE__);
        }
        $this->WhouseCode2 = $whouseCode2;
        return $this;
    }

    /**
     * Get SourceGuid value
     * @return string|null
     */
    public function getSourceGuid()
    {
        return $this->SourceGuid;
    }

    /**
     * Set SourceGuid value
     * @param string $sourceGuid
     * @return ItemDef
     */
    public function setSourceGuid($sourceGuid = null)
    {
        // validation for constraint: string
        if (!is_null($sourceGuid) && !is_string($sourceGuid)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceGuid, true), gettype($sourceGuid)), __LINE__);
        }
        $this->SourceGuid = $sourceGuid;
        return $this;
    }

    /**
     * Get VehicleCode value
     * @return string|null
     */
    public function getVehicleCode()
    {
        return $this->VehicleCode;
    }

    /**
     * Set VehicleCode value
     * @param string $vehicleCode
     * @return ItemDef
     */
    public function setVehicleCode($vehicleCode = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleCode) && !is_string($vehicleCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleCode, true), gettype($vehicleCode)), __LINE__);
        }
        $this->VehicleCode = $vehicleCode;
        return $this;
    }

    /**
     * Get DriverIdentifyNo value
     * @return string|null
     */
    public function getDriverIdentifyNo()
    {
        return $this->DriverIdentifyNo;
    }

    /**
     * Set DriverIdentifyNo value
     * @param string $driverIdentifyNo
     * @return ItemDef
     */
    public function setDriverIdentifyNo($driverIdentifyNo = null)
    {
        // validation for constraint: string
        if (!is_null($driverIdentifyNo) && !is_string($driverIdentifyNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverIdentifyNo, true), gettype($driverIdentifyNo)), __LINE__);
        }
        $this->DriverIdentifyNo = $driverIdentifyNo;
        return $this;
    }

    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }

    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return ItemDef
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlate, true), gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }

    /**
     * Get DriverIdentityNo value
     * @return string|null
     */
    public function getDriverIdentityNo()
    {
        return $this->DriverIdentityNo;
    }

    /**
     * Set DriverIdentityNo value
     * @param string $driverIdentityNo
     * @return ItemDef
     */
    public function setDriverIdentityNo($driverIdentityNo = null)
    {
        // validation for constraint: string
        if (!is_null($driverIdentityNo) && !is_string($driverIdentityNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverIdentityNo, true), gettype($driverIdentityNo)), __LINE__);
        }
        $this->DriverIdentityNo = $driverIdentityNo;
        return $this;
    }

    /**
     * Get DriverName value
     * @return string|null
     */
    public function getDriverName()
    {
        return $this->DriverName;
    }

    /**
     * Set DriverName value
     * @param string $driverName
     * @return ItemDef
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverName, true), gettype($driverName)), __LINE__);
        }
        $this->DriverName = $driverName;
        return $this;
    }

    /**
     * Get DriverFamilyName value
     * @return string|null
     */
    public function getDriverFamilyName()
    {
        return $this->DriverFamilyName;
    }

    /**
     * Set DriverFamilyName value
     * @param string $driverFamilyName
     * @return ItemDef
     */
    public function setDriverFamilyName($driverFamilyName = null)
    {
        // validation for constraint: string
        if (!is_null($driverFamilyName) && !is_string($driverFamilyName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverFamilyName, true), gettype($driverFamilyName)), __LINE__);
        }
        $this->DriverFamilyName = $driverFamilyName;
        return $this;
    }

    /**
     * Get DriverGsmNo value
     * @return string|null
     */
    public function getDriverGsmNo()
    {
        return $this->DriverGsmNo;
    }

    /**
     * Set DriverGsmNo value
     * @param string $driverGsmNo
     * @return ItemDef
     */
    public function setDriverGsmNo($driverGsmNo = null)
    {
        // validation for constraint: string
        if (!is_null($driverGsmNo) && !is_string($driverGsmNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverGsmNo, true), gettype($driverGsmNo)), __LINE__);
        }
        $this->DriverGsmNo = $driverGsmNo;
        return $this;
    }

    /**
     * Get DriverNote value
     * @return string|null
     */
    public function getDriverNote()
    {
        return $this->DriverNote;
    }

    /**
     * Set DriverNote value
     * @param string $driverNote
     * @return ItemDef
     */
    public function setDriverNote($driverNote = null)
    {
        // validation for constraint: string
        if (!is_null($driverNote) && !is_string($driverNote)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverNote, true), gettype($driverNote)), __LINE__);
        }
        $this->DriverNote = $driverNote;
        return $this;
    }

    /**
     * Get TrailerPlate value
     * @return string|null
     */
    public function getTrailerPlate()
    {
        return $this->TrailerPlate;
    }

    /**
     * Set TrailerPlate value
     * @param string $trailerPlate
     * @return ItemDef
     */
    public function setTrailerPlate($trailerPlate = null)
    {
        // validation for constraint: string
        if (!is_null($trailerPlate) && !is_string($trailerPlate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailerPlate, true), gettype($trailerPlate)), __LINE__);
        }
        $this->TrailerPlate = $trailerPlate;
        return $this;
    }

    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }

    /**
     * Set StartTime value
     * @param string $startTime
     * @return ItemDef
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }

    /**
     * Get Details value
     * @return ArrayOfItemDetailDef|null
     */
    public function getDetails()
    {
        return $this->Details;
    }

    /**
     * Set Details value
     * @param ArrayOfItemDetailDef $details
     * @return ItemDef
     */
    public function setDetails(ArrayOfItemDetailDef $details = null)
    {
        $this->Details = $details;
        return $this;
    }

    /**
     * Get ETTN value
     * @return string|null
     */
    public function getETTN()
    {
        return $this->ETTN;
    }

    /**
     * Set ETTN value
     * @param string $eTTN
     * @return ItemDef
     */
    public function setETTN($eTTN = null)
    {
        // validation for constraint: string
        if (!is_null($eTTN) && !is_string($eTTN)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eTTN, true), gettype($eTTN)), __LINE__);
        }
        $this->ETTN = $eTTN;
        return $this;
    }

    /**
     * Get TransportEquipment value
     * @return string|null
     */
    public function getTransportEquipment()
    {
        return $this->TransportEquipment;
    }

    /**
     * Set TransportEquipment value
     * @param string $transportEquipment
     * @return ItemDef
     */
    public function setTransportEquipment($transportEquipment = null)
    {
        // validation for constraint: string
        if (!is_null($transportEquipment) && !is_string($transportEquipment)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportEquipment, true), gettype($transportEquipment)), __LINE__);
        }
        $this->TransportEquipment = $transportEquipment;
        return $this;
    }

    /**
     * Get ShippingDesc1 value
     * @return string|null
     */
    public function getShippingDesc1()
    {
        return $this->ShippingDesc1;
    }

    /**
     * Set ShippingDesc1 value
     * @param string $shippingDesc1
     * @return ItemDef
     */
    public function setShippingDesc1($shippingDesc1 = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDesc1) && !is_string($shippingDesc1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingDesc1, true), gettype($shippingDesc1)), __LINE__);
        }
        $this->ShippingDesc1 = $shippingDesc1;
        return $this;
    }
}
