<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\EnumType\PurchaseSales;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseTaxCardDef StructType
 * @subpackage Structs
 */
class ExpenseTaxCardDef extends AbstractStructBase
{
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CountryId;
    /**
     * The TaxId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TaxId;
    /**
     * The PurchaseSales
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PurchaseSales;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxCode;
    /**
     * The Note1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note1;

    /**
     * Constructor method for ExpenseTaxCardDef
     * @param int $countryId
     * @param int $taxId
     * @param string $purchaseSales
     * @param string $startDate
     * @param string $endDate
     * @param string $countryCode
     * @param string $taxCode
     * @param string $note1
     * @uses ExpenseTaxCardDef::setCountryId()
     * @uses ExpenseTaxCardDef::setTaxId()
     * @uses ExpenseTaxCardDef::setPurchaseSales()
     * @uses ExpenseTaxCardDef::setStartDate()
     * @uses ExpenseTaxCardDef::setEndDate()
     * @uses ExpenseTaxCardDef::setCountryCode()
     * @uses ExpenseTaxCardDef::setTaxCode()
     * @uses ExpenseTaxCardDef::setNote1()
     */
    public function __construct($countryId = null, $taxId = null, $purchaseSales = null, $startDate = null, $endDate = null, $countryCode = null, $taxCode = null, $note1 = null)
    {
        $this
            ->setCountryId($countryId)
            ->setTaxId($taxId)
            ->setPurchaseSales($purchaseSales)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setCountryCode($countryCode)
            ->setTaxCode($taxCode)
            ->setNote1($note1);
    }

    /**
     * Get CountryId value
     * @return int
     */
    public function getCountryId()
    {
        return $this->CountryId;
    }

    /**
     * Set CountryId value
     * @param int $countryId
     * @return ExpenseTaxCardDef
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: int
        if (!is_null($countryId) && !(is_int($countryId) || ctype_digit($countryId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        $this->CountryId = $countryId;
        return $this;
    }

    /**
     * Get TaxId value
     * @return int
     */
    public function getTaxId()
    {
        return $this->TaxId;
    }

    /**
     * Set TaxId value
     * @param int $taxId
     * @return ExpenseTaxCardDef
     */
    public function setTaxId($taxId = null)
    {
        // validation for constraint: int
        if (!is_null($taxId) && !(is_int($taxId) || ctype_digit($taxId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxId, true), gettype($taxId)), __LINE__);
        }
        $this->TaxId = $taxId;
        return $this;
    }

    /**
     * Get PurchaseSales value
     * @return string
     */
    public function getPurchaseSales()
    {
        return $this->PurchaseSales;
    }

    /**
     * Set PurchaseSales value
     * @param string $purchaseSales
     * @return ExpenseTaxCardDef
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\PurchaseSales::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\PurchaseSales::valueIsValid()
     */
    public function setPurchaseSales($purchaseSales = null)
    {
        // validation for constraint: enumeration
        if (!PurchaseSales::valueIsValid($purchaseSales)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\PurchaseSales', is_array($purchaseSales) ? implode(', ', $purchaseSales) : var_export($purchaseSales, true), implode(', ', PurchaseSales::getValidValues())), __LINE__);
        }
        $this->PurchaseSales = $purchaseSales;
        return $this;
    }

    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }

    /**
     * Set StartDate value
     * @param string $startDate
     * @return ExpenseTaxCardDef
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }

    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }

    /**
     * Set EndDate value
     * @param string $endDate
     * @return ExpenseTaxCardDef
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }

    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }

    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return ExpenseTaxCardDef
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }

    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }

    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return ExpenseTaxCardDef
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }

    /**
     * Get Note1 value
     * @return string|null
     */
    public function getNote1()
    {
        return $this->Note1;
    }

    /**
     * Set Note1 value
     * @param string $note1
     * @return ExpenseTaxCardDef
     */
    public function setNote1($note1 = null)
    {
        // validation for constraint: string
        if (!is_null($note1) && !is_string($note1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note1, true), gettype($note1)), __LINE__);
        }
        $this->Note1 = $note1;
        return $this;
    }
}
