<?php

namespace Gek\UyumBahce\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeRateType StructType
 * @subpackage Structs
 */
class ExchangeRateType extends AbstractStructBase
{
    /**
     * The SourceCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:SourceCurrencyCode
     * @var SourceCurrencyCodeType
     */
    public $SourceCurrencyCode;
    /**
     * The TargetCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TargetCurrencyCode
     * @var TargetCurrencyCodeType
     */
    public $TargetCurrencyCode;
    /**
     * The CalculationRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CalculationRate
     * @var CalculationRateType
     */
    public $CalculationRate;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Date
     * @var DateType
     */
    public $Date;

    /**
     * Constructor method for ExchangeRateType
     * @param SourceCurrencyCodeType $sourceCurrencyCode
     * @param TargetCurrencyCodeType $targetCurrencyCode
     * @param CalculationRateType $calculationRate
     * @param DateType $date
     * @uses ExchangeRateType::setSourceCurrencyCode()
     * @uses ExchangeRateType::setTargetCurrencyCode()
     * @uses ExchangeRateType::setCalculationRate()
     * @uses ExchangeRateType::setDate()
     */
    public function __construct(SourceCurrencyCodeType $sourceCurrencyCode = null, TargetCurrencyCodeType $targetCurrencyCode = null, CalculationRateType $calculationRate = null, DateType $date = null)
    {
        $this
            ->setSourceCurrencyCode($sourceCurrencyCode)
            ->setTargetCurrencyCode($targetCurrencyCode)
            ->setCalculationRate($calculationRate)
            ->setDate($date);
    }

    /**
     * Get SourceCurrencyCode value
     * @return SourceCurrencyCodeType|null
     */
    public function getSourceCurrencyCode()
    {
        return $this->SourceCurrencyCode;
    }

    /**
     * Set SourceCurrencyCode value
     * @param SourceCurrencyCodeType $sourceCurrencyCode
     * @return ExchangeRateType
     */
    public function setSourceCurrencyCode(SourceCurrencyCodeType $sourceCurrencyCode = null)
    {
        $this->SourceCurrencyCode = $sourceCurrencyCode;
        return $this;
    }

    /**
     * Get TargetCurrencyCode value
     * @return TargetCurrencyCodeType|null
     */
    public function getTargetCurrencyCode()
    {
        return $this->TargetCurrencyCode;
    }

    /**
     * Set TargetCurrencyCode value
     * @param TargetCurrencyCodeType $targetCurrencyCode
     * @return ExchangeRateType
     */
    public function setTargetCurrencyCode(TargetCurrencyCodeType $targetCurrencyCode = null)
    {
        $this->TargetCurrencyCode = $targetCurrencyCode;
        return $this;
    }

    /**
     * Get CalculationRate value
     * @return CalculationRateType|null
     */
    public function getCalculationRate()
    {
        return $this->CalculationRate;
    }

    /**
     * Set CalculationRate value
     * @param CalculationRateType $calculationRate
     * @return ExchangeRateType
     */
    public function setCalculationRate(CalculationRateType $calculationRate = null)
    {
        $this->CalculationRate = $calculationRate;
        return $this;
    }

    /**
     * Get Date value
     * @return DateType|null
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     * Set Date value
     * @param DateType $date
     * @return ExchangeRateType
     */
    public function setDate(DateType $date = null)
    {
        $this->Date = $date;
        return $this;
    }
}
