<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityBanks StructType
 * @subpackage Structs
 */
class EntityBanks extends AbstractStructBase
{
    /**
     * The BankId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BankId;
    /**
     * The BankBranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BankBranchId;
    /**
     * The CurTraId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurTraId;
    /**
     * The IbanNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IbanNo;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankCode;
    /**
     * The BankBranchCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankBranchCode;
    /**
     * The BankAccNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccNo;
    /**
     * The CurTraCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurTraCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;

    /**
     * Constructor method for EntityBanks
     * @param int $bankId
     * @param int $bankBranchId
     * @param int $curTraId
     * @param string $ibanNo
     * @param string $bankCode
     * @param string $bankBranchCode
     * @param string $bankAccNo
     * @param string $curTraCode
     * @param string $description
     * @uses EntityBanks::setBankId()
     * @uses EntityBanks::setBankBranchId()
     * @uses EntityBanks::setCurTraId()
     * @uses EntityBanks::setIbanNo()
     * @uses EntityBanks::setBankCode()
     * @uses EntityBanks::setBankBranchCode()
     * @uses EntityBanks::setBankAccNo()
     * @uses EntityBanks::setCurTraCode()
     * @uses EntityBanks::setDescription()
     */
    public function __construct($bankId = null, $bankBranchId = null, $curTraId = null, $ibanNo = null, $bankCode = null, $bankBranchCode = null, $bankAccNo = null, $curTraCode = null, $description = null)
    {
        $this
            ->setBankId($bankId)
            ->setBankBranchId($bankBranchId)
            ->setCurTraId($curTraId)
            ->setIbanNo($ibanNo)
            ->setBankCode($bankCode)
            ->setBankBranchCode($bankBranchCode)
            ->setBankAccNo($bankAccNo)
            ->setCurTraCode($curTraCode)
            ->setDescription($description);
    }

    /**
     * Get BankId value
     * @return int
     */
    public function getBankId()
    {
        return $this->BankId;
    }

    /**
     * Set BankId value
     * @param int $bankId
     * @return EntityBanks
     */
    public function setBankId($bankId = null)
    {
        // validation for constraint: int
        if (!is_null($bankId) && !(is_int($bankId) || ctype_digit($bankId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankId, true), gettype($bankId)), __LINE__);
        }
        $this->BankId = $bankId;
        return $this;
    }

    /**
     * Get BankBranchId value
     * @return int
     */
    public function getBankBranchId()
    {
        return $this->BankBranchId;
    }

    /**
     * Set BankBranchId value
     * @param int $bankBranchId
     * @return EntityBanks
     */
    public function setBankBranchId($bankBranchId = null)
    {
        // validation for constraint: int
        if (!is_null($bankBranchId) && !(is_int($bankBranchId) || ctype_digit($bankBranchId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankBranchId, true), gettype($bankBranchId)), __LINE__);
        }
        $this->BankBranchId = $bankBranchId;
        return $this;
    }

    /**
     * Get CurTraId value
     * @return int
     */
    public function getCurTraId()
    {
        return $this->CurTraId;
    }

    /**
     * Set CurTraId value
     * @param int $curTraId
     * @return EntityBanks
     */
    public function setCurTraId($curTraId = null)
    {
        // validation for constraint: int
        if (!is_null($curTraId) && !(is_int($curTraId) || ctype_digit($curTraId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($curTraId, true), gettype($curTraId)), __LINE__);
        }
        $this->CurTraId = $curTraId;
        return $this;
    }

    /**
     * Get IbanNo value
     * @return string|null
     */
    public function getIbanNo()
    {
        return $this->IbanNo;
    }

    /**
     * Set IbanNo value
     * @param string $ibanNo
     * @return EntityBanks
     */
    public function setIbanNo($ibanNo = null)
    {
        // validation for constraint: string
        if (!is_null($ibanNo) && !is_string($ibanNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ibanNo, true), gettype($ibanNo)), __LINE__);
        }
        $this->IbanNo = $ibanNo;
        return $this;
    }

    /**
     * Get BankCode value
     * @return string|null
     */
    public function getBankCode()
    {
        return $this->BankCode;
    }

    /**
     * Set BankCode value
     * @param string $bankCode
     * @return EntityBanks
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        $this->BankCode = $bankCode;
        return $this;
    }

    /**
     * Get BankBranchCode value
     * @return string|null
     */
    public function getBankBranchCode()
    {
        return $this->BankBranchCode;
    }

    /**
     * Set BankBranchCode value
     * @param string $bankBranchCode
     * @return EntityBanks
     */
    public function setBankBranchCode($bankBranchCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankBranchCode) && !is_string($bankBranchCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankBranchCode, true), gettype($bankBranchCode)), __LINE__);
        }
        $this->BankBranchCode = $bankBranchCode;
        return $this;
    }

    /**
     * Get BankAccNo value
     * @return string|null
     */
    public function getBankAccNo()
    {
        return $this->BankAccNo;
    }

    /**
     * Set BankAccNo value
     * @param string $bankAccNo
     * @return EntityBanks
     */
    public function setBankAccNo($bankAccNo = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccNo) && !is_string($bankAccNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccNo, true), gettype($bankAccNo)), __LINE__);
        }
        $this->BankAccNo = $bankAccNo;
        return $this;
    }

    /**
     * Get CurTraCode value
     * @return string|null
     */
    public function getCurTraCode()
    {
        return $this->CurTraCode;
    }

    /**
     * Set CurTraCode value
     * @param string $curTraCode
     * @return EntityBanks
     */
    public function setCurTraCode($curTraCode = null)
    {
        // validation for constraint: string
        if (!is_null($curTraCode) && !is_string($curTraCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($curTraCode, true), gettype($curTraCode)), __LINE__);
        }
        $this->CurTraCode = $curTraCode;
        return $this;
    }

    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * Set Description value
     * @param string $description
     * @return EntityBanks
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
