<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\ArrayType\ArrayOfCrmPriceListDetailDef;
use Gek\UyumBahce\EnumType\PurchaseSalesType;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrmPriceListDef StructType
 * @subpackage Structs
 */
class CrmPriceListDef extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The CoId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CoId;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BranchId;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EntityId;
    /**
     * The PriceListId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PriceListId;
    /**
     * The PurchaseSales
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PurchaseSales;
    /**
     * The Ispassive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Ispassive;
    /**
     * The CoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CoCode;
    /**
     * The BranchCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchCode;
    /**
     * The EntityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityCode;
    /**
     * The PriceListCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceListCode;
    /**
     * The PriceListDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceListDesc;
    /**
     * The Description1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description1;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfCrmPriceListDetailDef
     */
    public $Details;

    /**
     * Constructor method for CrmPriceListDef
     * @param int $id
     * @param int $coId
     * @param int $branchId
     * @param int $entityId
     * @param int $priceListId
     * @param string $purchaseSales
     * @param bool $ispassive
     * @param string $coCode
     * @param string $branchCode
     * @param string $entityCode
     * @param string $priceListCode
     * @param string $priceListDesc
     * @param string $description1
     * @param ArrayOfCrmPriceListDetailDef $details
     * @uses CrmPriceListDef::setId()
     * @uses CrmPriceListDef::setCoId()
     * @uses CrmPriceListDef::setBranchId()
     * @uses CrmPriceListDef::setEntityId()
     * @uses CrmPriceListDef::setPriceListId()
     * @uses CrmPriceListDef::setPurchaseSales()
     * @uses CrmPriceListDef::setIspassive()
     * @uses CrmPriceListDef::setCoCode()
     * @uses CrmPriceListDef::setBranchCode()
     * @uses CrmPriceListDef::setEntityCode()
     * @uses CrmPriceListDef::setPriceListCode()
     * @uses CrmPriceListDef::setPriceListDesc()
     * @uses CrmPriceListDef::setDescription1()
     * @uses CrmPriceListDef::setDetails()
     */
    public function __construct($id = null, $coId = null, $branchId = null, $entityId = null, $priceListId = null, $purchaseSales = null, $ispassive = null, $coCode = null, $branchCode = null, $entityCode = null, $priceListCode = null, $priceListDesc = null, $description1 = null, ArrayOfCrmPriceListDetailDef $details = null)
    {
        $this
            ->setId($id)
            ->setCoId($coId)
            ->setBranchId($branchId)
            ->setEntityId($entityId)
            ->setPriceListId($priceListId)
            ->setPurchaseSales($purchaseSales)
            ->setIspassive($ispassive)
            ->setCoCode($coCode)
            ->setBranchCode($branchCode)
            ->setEntityCode($entityCode)
            ->setPriceListCode($priceListCode)
            ->setPriceListDesc($priceListDesc)
            ->setDescription1($description1)
            ->setDetails($details);
    }

    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param int $id
     * @return CrmPriceListDef
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }

    /**
     * Get CoId value
     * @return int
     */
    public function getCoId()
    {
        return $this->CoId;
    }

    /**
     * Set CoId value
     * @param int $coId
     * @return CrmPriceListDef
     */
    public function setCoId($coId = null)
    {
        // validation for constraint: int
        if (!is_null($coId) && !(is_int($coId) || ctype_digit($coId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coId, true), gettype($coId)), __LINE__);
        }
        $this->CoId = $coId;
        return $this;
    }

    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }

    /**
     * Set BranchId value
     * @param int $branchId
     * @return CrmPriceListDef
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }

    /**
     * Get EntityId value
     * @return int
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }

    /**
     * Set EntityId value
     * @param int $entityId
     * @return CrmPriceListDef
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }

    /**
     * Get PriceListId value
     * @return int
     */
    public function getPriceListId()
    {
        return $this->PriceListId;
    }

    /**
     * Set PriceListId value
     * @param int $priceListId
     * @return CrmPriceListDef
     */
    public function setPriceListId($priceListId = null)
    {
        // validation for constraint: int
        if (!is_null($priceListId) && !(is_int($priceListId) || ctype_digit($priceListId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceListId, true), gettype($priceListId)), __LINE__);
        }
        $this->PriceListId = $priceListId;
        return $this;
    }

    /**
     * Get PurchaseSales value
     * @return string
     */
    public function getPurchaseSales()
    {
        return $this->PurchaseSales;
    }

    /**
     * Set PurchaseSales value
     * @param string $purchaseSales
     * @return CrmPriceListDef
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\PurchaseSalesType::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\PurchaseSalesType::valueIsValid()
     */
    public function setPurchaseSales($purchaseSales = null)
    {
        // validation for constraint: enumeration
        if (!PurchaseSalesType::valueIsValid($purchaseSales)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\PurchaseSalesType', is_array($purchaseSales) ? implode(', ', $purchaseSales) : var_export($purchaseSales, true), implode(', ', PurchaseSalesType::getValidValues())), __LINE__);
        }
        $this->PurchaseSales = $purchaseSales;
        return $this;
    }

    /**
     * Get Ispassive value
     * @return bool
     */
    public function getIspassive()
    {
        return $this->Ispassive;
    }

    /**
     * Set Ispassive value
     * @param bool $ispassive
     * @return CrmPriceListDef
     */
    public function setIspassive($ispassive = null)
    {
        // validation for constraint: boolean
        if (!is_null($ispassive) && !is_bool($ispassive)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ispassive, true), gettype($ispassive)), __LINE__);
        }
        $this->Ispassive = $ispassive;
        return $this;
    }

    /**
     * Get CoCode value
     * @return string|null
     */
    public function getCoCode()
    {
        return $this->CoCode;
    }

    /**
     * Set CoCode value
     * @param string $coCode
     * @return CrmPriceListDef
     */
    public function setCoCode($coCode = null)
    {
        // validation for constraint: string
        if (!is_null($coCode) && !is_string($coCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coCode, true), gettype($coCode)), __LINE__);
        }
        $this->CoCode = $coCode;
        return $this;
    }

    /**
     * Get BranchCode value
     * @return string|null
     */
    public function getBranchCode()
    {
        return $this->BranchCode;
    }

    /**
     * Set BranchCode value
     * @param string $branchCode
     * @return CrmPriceListDef
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchCode, true), gettype($branchCode)), __LINE__);
        }
        $this->BranchCode = $branchCode;
        return $this;
    }

    /**
     * Get EntityCode value
     * @return string|null
     */
    public function getEntityCode()
    {
        return $this->EntityCode;
    }

    /**
     * Set EntityCode value
     * @param string $entityCode
     * @return CrmPriceListDef
     */
    public function setEntityCode($entityCode = null)
    {
        // validation for constraint: string
        if (!is_null($entityCode) && !is_string($entityCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityCode, true), gettype($entityCode)), __LINE__);
        }
        $this->EntityCode = $entityCode;
        return $this;
    }

    /**
     * Get PriceListCode value
     * @return string|null
     */
    public function getPriceListCode()
    {
        return $this->PriceListCode;
    }

    /**
     * Set PriceListCode value
     * @param string $priceListCode
     * @return CrmPriceListDef
     */
    public function setPriceListCode($priceListCode = null)
    {
        // validation for constraint: string
        if (!is_null($priceListCode) && !is_string($priceListCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListCode, true), gettype($priceListCode)), __LINE__);
        }
        $this->PriceListCode = $priceListCode;
        return $this;
    }

    /**
     * Get PriceListDesc value
     * @return string|null
     */
    public function getPriceListDesc()
    {
        return $this->PriceListDesc;
    }

    /**
     * Set PriceListDesc value
     * @param string $priceListDesc
     * @return CrmPriceListDef
     */
    public function setPriceListDesc($priceListDesc = null)
    {
        // validation for constraint: string
        if (!is_null($priceListDesc) && !is_string($priceListDesc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListDesc, true), gettype($priceListDesc)), __LINE__);
        }
        $this->PriceListDesc = $priceListDesc;
        return $this;
    }

    /**
     * Get Description1 value
     * @return string|null
     */
    public function getDescription1()
    {
        return $this->Description1;
    }

    /**
     * Set Description1 value
     * @param string $description1
     * @return CrmPriceListDef
     */
    public function setDescription1($description1 = null)
    {
        // validation for constraint: string
        if (!is_null($description1) && !is_string($description1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description1, true), gettype($description1)), __LINE__);
        }
        $this->Description1 = $description1;
        return $this;
    }

    /**
     * Get Details value
     * @return ArrayOfCrmPriceListDetailDef|null
     */
    public function getDetails()
    {
        return $this->Details;
    }

    /**
     * Set Details value
     * @param ArrayOfCrmPriceListDetailDef $details
     * @return CrmPriceListDef
     */
    public function setDetails(ArrayOfCrmPriceListDetailDef $details = null)
    {
        $this->Details = $details;
        return $this;
    }
}
