<?php

namespace Gek\UyumBahce\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoEntityIntegration StructType
 * @subpackage Structs
 */
class CoEntityIntegration extends AbstractStructBase
{
    /**
     * The CardIntgCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardIntgCode;
    /**
     * The AccCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccCode;
    /**
     * The Note1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note1;

    /**
     * Constructor method for CoEntityIntegration
     * @param string $cardIntgCode
     * @param string $accCode
     * @param string $note1
     * @uses CoEntityIntegration::setCardIntgCode()
     * @uses CoEntityIntegration::setAccCode()
     * @uses CoEntityIntegration::setNote1()
     */
    public function __construct($cardIntgCode = null, $accCode = null, $note1 = null)
    {
        $this
            ->setCardIntgCode($cardIntgCode)
            ->setAccCode($accCode)
            ->setNote1($note1);
    }

    /**
     * Get CardIntgCode value
     * @return string|null
     */
    public function getCardIntgCode()
    {
        return $this->CardIntgCode;
    }

    /**
     * Set CardIntgCode value
     * @param string $cardIntgCode
     * @return CoEntityIntegration
     */
    public function setCardIntgCode($cardIntgCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardIntgCode) && !is_string($cardIntgCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIntgCode, true), gettype($cardIntgCode)), __LINE__);
        }
        $this->CardIntgCode = $cardIntgCode;
        return $this;
    }

    /**
     * Get AccCode value
     * @return string|null
     */
    public function getAccCode()
    {
        return $this->AccCode;
    }

    /**
     * Set AccCode value
     * @param string $accCode
     * @return CoEntityIntegration
     */
    public function setAccCode($accCode = null)
    {
        // validation for constraint: string
        if (!is_null($accCode) && !is_string($accCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accCode, true), gettype($accCode)), __LINE__);
        }
        $this->AccCode = $accCode;
        return $this;
    }

    /**
     * Get Note1 value
     * @return string|null
     */
    public function getNote1()
    {
        return $this->Note1;
    }

    /**
     * Set Note1 value
     * @param string $note1
     * @return CoEntityIntegration
     */
    public function setNote1($note1 = null)
    {
        // validation for constraint: string
        if (!is_null($note1) && !is_string($note1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note1, true), gettype($note1)), __LINE__);
        }
        $this->Note1 = $note1;
        return $this;
    }
}
