<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\ArrayType\ArrayOfAccDetailDef;
use Gek\UyumBahce\EnumType\AccReceipt;
use InvalidArgumentException;

/**
 * This class stands for AccDef StructType
 * @subpackage Structs
 */
class AccDef extends MasterFields
{
    /**
     * The AccMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AccMId;
    /**
     * The AccReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AccReceipt;
    /**
     * The AmtCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmtCredit;
    /**
     * The AmtDebit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmtDebit;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfAccDetailDef
     */
    public $Details;

    /**
     * Constructor method for AccDef
     * @param int $accMId
     * @param string $accReceipt
     * @param float $amtCredit
     * @param float $amtDebit
     * @param ArrayOfAccDetailDef $details
     * @uses AccDef::setAccMId()
     * @uses AccDef::setAccReceipt()
     * @uses AccDef::setAmtCredit()
     * @uses AccDef::setAmtDebit()
     * @uses AccDef::setDetails()
     */
    public function __construct($accMId = null, $accReceipt = null, $amtCredit = null, $amtDebit = null, ArrayOfAccDetailDef $details = null)
    {
        parent::__construct();
        $this
            ->setAccMId($accMId)
            ->setAccReceipt($accReceipt)
            ->setAmtCredit($amtCredit)
            ->setAmtDebit($amtDebit)
            ->setDetails($details);
    }

    /**
     * Get AccMId value
     * @return int
     */
    public function getAccMId()
    {
        return $this->AccMId;
    }

    /**
     * Set AccMId value
     * @param int $accMId
     * @return AccDef
     */
    public function setAccMId($accMId = null)
    {
        // validation for constraint: int
        if (!is_null($accMId) && !(is_int($accMId) || ctype_digit($accMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accMId, true), gettype($accMId)), __LINE__);
        }
        $this->AccMId = $accMId;
        return $this;
    }

    /**
     * Get AccReceipt value
     * @return string
     */
    public function getAccReceipt()
    {
        return $this->AccReceipt;
    }

    /**
     * Set AccReceipt value
     * @param string $accReceipt
     * @return AccDef
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\AccReceipt::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\AccReceipt::valueIsValid()
     */
    public function setAccReceipt($accReceipt = null)
    {
        // validation for constraint: enumeration
        if (!AccReceipt::valueIsValid($accReceipt)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\AccReceipt', is_array($accReceipt) ? implode(', ', $accReceipt) : var_export($accReceipt, true), implode(', ', AccReceipt::getValidValues())), __LINE__);
        }
        $this->AccReceipt = $accReceipt;
        return $this;
    }

    /**
     * Get AmtCredit value
     * @return float
     */
    public function getAmtCredit()
    {
        return $this->AmtCredit;
    }

    /**
     * Set AmtCredit value
     * @param float $amtCredit
     * @return AccDef
     */
    public function setAmtCredit($amtCredit = null)
    {
        // validation for constraint: float
        if (!is_null($amtCredit) && !(is_float($amtCredit) || is_numeric($amtCredit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtCredit, true), gettype($amtCredit)), __LINE__);
        }
        $this->AmtCredit = $amtCredit;
        return $this;
    }

    /**
     * Get AmtDebit value
     * @return float
     */
    public function getAmtDebit()
    {
        return $this->AmtDebit;
    }

    /**
     * Set AmtDebit value
     * @param float $amtDebit
     * @return AccDef
     */
    public function setAmtDebit($amtDebit = null)
    {
        // validation for constraint: float
        if (!is_null($amtDebit) && !(is_float($amtDebit) || is_numeric($amtDebit))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDebit, true), gettype($amtDebit)), __LINE__);
        }
        $this->AmtDebit = $amtDebit;
        return $this;
    }

    /**
     * Get Details value
     * @return ArrayOfAccDetailDef|null
     */
    public function getDetails()
    {
        return $this->Details;
    }

    /**
     * Set Details value
     * @param ArrayOfAccDetailDef $details
     * @return AccDef
     */
    public function setDetails(ArrayOfAccDetailDef $details = null)
    {
        $this->Details = $details;
        return $this;
    }
}
