<?php

namespace Gek\UyumBahce\ServiceType;

use Gek\UyumBahce\StructType\SendEDespatch;
use Gek\UyumBahce\StructType\SendEDespatchResponse;
use Gek\UyumBahce\StructType\SendEInvoice;
use Gek\UyumBahce\StructType\SendEInvoiceResponse;
use SoapFault;
use WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendEInvoice
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen ETTN numarasına ait Fatura Kaydını Gib ortamına gönderir.
     * @param SendEInvoice $parameters
     * @return SendEInvoiceResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function SendEInvoice(SendEInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SendEInvoice', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Method to call the operation originally named SendEDespatch
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen ETTN numarasına ait İrsaliye Kaydını Gib ortamına gönderir.
     * @param SendEDespatch $parameters
     * @return SendEDespatchResponse|bool
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     */
    public function SendEDespatch(SendEDespatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SendEDespatch', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }

    /**
     * Returns the result
     * @return SendEDespatchResponse|SendEInvoiceResponse
     * @see AbstractSoapClientBase::getResult()
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
