<?php

namespace Gek\UyumBahce\ArrayType;

use Gek\UyumBahce\StructType\TransformType;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransformType ArrayType
 * @subpackage Arrays
 */
class ArrayOfTransformType extends AbstractStructArrayBase
{
    /**
     * The Transform
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TransformType[]
     */
    public $Transform;

    /**
     * Constructor method for ArrayOfTransformType
     * @param TransformType[] $transform
     * @uses ArrayOfTransformType::setTransform()
     */
    public function __construct(array $transform = array())
    {
        $this
            ->setTransform($transform);
    }

    /**
     * Get Transform value
     * @return TransformType[]|null
     */
    public function getTransform()
    {
        return $this->Transform;
    }

    /**
     * This method is responsible for validating the values passed to the setTransform method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransform method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransformForArrayConstraintsFromSetTransform(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTransformTypeTransformItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransformTypeTransformItem instanceof TransformType) {
                $invalidValues[] = is_object($arrayOfTransformTypeTransformItem) ? get_class($arrayOfTransformTypeTransformItem) : sprintf('%s(%s)', gettype($arrayOfTransformTypeTransformItem), var_export($arrayOfTransformTypeTransformItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transform property can only contain items of type \Gek\UyumBahce\StructType\TransformType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Transform value
     * @param TransformType[] $transform
     * @return ArrayOfTransformType
     * @throws InvalidArgumentException
     */
    public function setTransform(array $transform = array())
    {
        // validation for constraint: array
        if ('' !== ($transformArrayErrorMessage = self::validateTransformForArrayConstraintsFromSetTransform($transform))) {
            throw new InvalidArgumentException($transformArrayErrorMessage, __LINE__);
        }
        $this->Transform = $transform;
        return $this;
    }

    /**
     * Add item to Transform value
     * @param TransformType $item
     * @return ArrayOfTransformType
     * @throws InvalidArgumentException
     */
    public function addToTransform(TransformType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TransformType) {
            throw new InvalidArgumentException(sprintf('The Transform property can only contain items of type \Gek\UyumBahce\StructType\TransformType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transform[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return TransformType|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return TransformType|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return TransformType|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return TransformType|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return TransformType|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string Transform
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'Transform';
    }
}
