<?php

namespace Gek\UyumBahce\ArrayType;

use Gek\UyumBahce\StructType\OrderDetailInfo;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderDetailInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderDetailInfo extends AbstractStructArrayBase
{
    /**
     * The OrderDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var OrderDetailInfo[]
     */
    public $OrderDetailInfo;

    /**
     * Constructor method for ArrayOfOrderDetailInfo
     * @param OrderDetailInfo[] $orderDetailInfo
     * @uses ArrayOfOrderDetailInfo::setOrderDetailInfo()
     */
    public function __construct(array $orderDetailInfo = array())
    {
        $this
            ->setOrderDetailInfo($orderDetailInfo);
    }

    /**
     * Get OrderDetailInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return OrderDetailInfo[]|null
     */
    public function getOrderDetailInfo()
    {
        return isset($this->OrderDetailInfo) ? $this->OrderDetailInfo : null;
    }

    /**
     * This method is responsible for validating the values passed to the setOrderDetailInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderDetailInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderDetailInfoForArrayConstraintsFromSetOrderDetailInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderDetailInfoOrderDetailInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderDetailInfoOrderDetailInfoItem instanceof OrderDetailInfo) {
                $invalidValues[] = is_object($arrayOfOrderDetailInfoOrderDetailInfoItem) ? get_class($arrayOfOrderDetailInfoOrderDetailInfoItem) : sprintf('%s(%s)', gettype($arrayOfOrderDetailInfoOrderDetailInfoItem), var_export($arrayOfOrderDetailInfoOrderDetailInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderDetailInfo property can only contain items of type \Gek\UyumBahce\StructType\OrderDetailInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set OrderDetailInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param OrderDetailInfo[] $orderDetailInfo
     * @return ArrayOfOrderDetailInfo
     * @throws InvalidArgumentException
     */
    public function setOrderDetailInfo(array $orderDetailInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($orderDetailInfoArrayErrorMessage = self::validateOrderDetailInfoForArrayConstraintsFromSetOrderDetailInfo($orderDetailInfo))) {
            throw new InvalidArgumentException($orderDetailInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($orderDetailInfo) || (is_array($orderDetailInfo) && empty($orderDetailInfo))) {
            unset($this->OrderDetailInfo);
        } else {
            $this->OrderDetailInfo = $orderDetailInfo;
        }
        return $this;
    }

    /**
     * Add item to OrderDetailInfo value
     * @param OrderDetailInfo $item
     * @return ArrayOfOrderDetailInfo
     * @throws InvalidArgumentException
     */
    public function addToOrderDetailInfo(OrderDetailInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof OrderDetailInfo) {
            throw new InvalidArgumentException(sprintf('The OrderDetailInfo property can only contain items of type \Gek\UyumBahce\StructType\OrderDetailInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderDetailInfo[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return OrderDetailInfo|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return OrderDetailInfo|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return OrderDetailInfo|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return OrderDetailInfo|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return OrderDetailInfo|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string OrderDetailInfo
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'OrderDetailInfo';
    }
}
