<?php

namespace Gek\UyumBahce\ArrayType;

use Gek\UyumBahce\StructType\EntityBanks;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEntityBanks ArrayType
 * @subpackage Arrays
 */
class ArrayOfEntityBanks extends AbstractStructArrayBase
{
    /**
     * The EntityBanks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var EntityBanks[]
     */
    public $EntityBanks;

    /**
     * Constructor method for ArrayOfEntityBanks
     * @param EntityBanks[] $entityBanks
     * @uses ArrayOfEntityBanks::setEntityBanks()
     */
    public function __construct(array $entityBanks = array())
    {
        $this
            ->setEntityBanks($entityBanks);
    }

    /**
     * Get EntityBanks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return EntityBanks[]|null
     */
    public function getEntityBanks()
    {
        return isset($this->EntityBanks) ? $this->EntityBanks : null;
    }

    /**
     * This method is responsible for validating the values passed to the setEntityBanks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEntityBanks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEntityBanksForArrayConstraintsFromSetEntityBanks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEntityBanksEntityBanksItem) {
            // validation for constraint: itemType
            if (!$arrayOfEntityBanksEntityBanksItem instanceof EntityBanks) {
                $invalidValues[] = is_object($arrayOfEntityBanksEntityBanksItem) ? get_class($arrayOfEntityBanksEntityBanksItem) : sprintf('%s(%s)', gettype($arrayOfEntityBanksEntityBanksItem), var_export($arrayOfEntityBanksEntityBanksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EntityBanks property can only contain items of type \Gek\UyumBahce\StructType\EntityBanks, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set EntityBanks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param EntityBanks[] $entityBanks
     * @return ArrayOfEntityBanks
     * @throws InvalidArgumentException
     */
    public function setEntityBanks(array $entityBanks = array())
    {
        // validation for constraint: array
        if ('' !== ($entityBanksArrayErrorMessage = self::validateEntityBanksForArrayConstraintsFromSetEntityBanks($entityBanks))) {
            throw new InvalidArgumentException($entityBanksArrayErrorMessage, __LINE__);
        }
        if (is_null($entityBanks) || (is_array($entityBanks) && empty($entityBanks))) {
            unset($this->EntityBanks);
        } else {
            $this->EntityBanks = $entityBanks;
        }
        return $this;
    }

    /**
     * Add item to EntityBanks value
     * @param EntityBanks $item
     * @return ArrayOfEntityBanks
     * @throws InvalidArgumentException
     */
    public function addToEntityBanks(EntityBanks $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof EntityBanks) {
            throw new InvalidArgumentException(sprintf('The EntityBanks property can only contain items of type \Gek\UyumBahce\StructType\EntityBanks, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EntityBanks[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return EntityBanks|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return EntityBanks|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return EntityBanks|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return EntityBanks|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return EntityBanks|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string EntityBanks
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'EntityBanks';
    }
}
