<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportHandlingUnitType StructType
 * @subpackage Structs
 */
class TransportHandlingUnitType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var \Gek\UyumBahce\StructType\IDType
     */
    public $ID;
    /**
     * The TransportHandlingUnitTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransportHandlingUnitTypeCode
     * @var \Gek\UyumBahce\StructType\TransportHandlingUnitTypeCodeType
     */
    public $TransportHandlingUnitTypeCode;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HandlingCode
     * @var \Gek\UyumBahce\StructType\HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HandlingInstructions
     * @var \Gek\UyumBahce\StructType\HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HazardousRiskIndicator
     * @var \Gek\UyumBahce\StructType\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TotalGoodsItemQuantity
     * @var \Gek\UyumBahce\StructType\TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalPackageQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TotalPackageQuantity
     * @var \Gek\UyumBahce\StructType\TotalPackageQuantityType
     */
    public $TotalPackageQuantity;
    /**
     * The DamageRemarks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:DamageRemarks
     * @var \Gek\UyumBahce\StructType\DamageRemarksType[]
     */
    public $DamageRemarks;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TraceID
     * @var \Gek\UyumBahce\StructType\TraceIDType
     */
    public $TraceID;
    /**
     * The ActualPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PackageType[]
     */
    public $ActualPackage;
    /**
     * The TransportEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\TransportEquipmentType[]
     */
    public $TransportEquipment;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\TransportMeansType[]
     */
    public $TransportMeans;
    /**
     * The HazardousGoodsTransit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\HazardousGoodsTransitType[]
     */
    public $HazardousGoodsTransit;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\TemperatureType
     */
    public $MinimumTemperature;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The FloorSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DimensionType
     */
    public $FloorSpaceMeasurementDimension;
    /**
     * The PalletSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DimensionType
     */
    public $PalletSpaceMeasurementDimension;
    /**
     * The ShipmentDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DocumentReferenceType[]
     */
    public $ShipmentDocumentReference;
    /**
     * The CustomsDeclaration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\CustomsDeclarationType[]
     */
    public $CustomsDeclaration;
    /**
     * Constructor method for TransportHandlingUnitType
     * @uses TransportHandlingUnitType::setID()
     * @uses TransportHandlingUnitType::setTransportHandlingUnitTypeCode()
     * @uses TransportHandlingUnitType::setHandlingCode()
     * @uses TransportHandlingUnitType::setHandlingInstructions()
     * @uses TransportHandlingUnitType::setHazardousRiskIndicator()
     * @uses TransportHandlingUnitType::setTotalGoodsItemQuantity()
     * @uses TransportHandlingUnitType::setTotalPackageQuantity()
     * @uses TransportHandlingUnitType::setDamageRemarks()
     * @uses TransportHandlingUnitType::setTraceID()
     * @uses TransportHandlingUnitType::setActualPackage()
     * @uses TransportHandlingUnitType::setTransportEquipment()
     * @uses TransportHandlingUnitType::setTransportMeans()
     * @uses TransportHandlingUnitType::setHazardousGoodsTransit()
     * @uses TransportHandlingUnitType::setMeasurementDimension()
     * @uses TransportHandlingUnitType::setMinimumTemperature()
     * @uses TransportHandlingUnitType::setMaximumTemperature()
     * @uses TransportHandlingUnitType::setFloorSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setPalletSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setShipmentDocumentReference()
     * @uses TransportHandlingUnitType::setCustomsDeclaration()
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @param \Gek\UyumBahce\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @param \Gek\UyumBahce\StructType\HandlingCodeType $handlingCode
     * @param \Gek\UyumBahce\StructType\HandlingInstructionsType $handlingInstructions
     * @param \Gek\UyumBahce\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param \Gek\UyumBahce\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param \Gek\UyumBahce\StructType\TotalPackageQuantityType $totalPackageQuantity
     * @param \Gek\UyumBahce\StructType\DamageRemarksType[] $damageRemarks
     * @param \Gek\UyumBahce\StructType\TraceIDType $traceID
     * @param \Gek\UyumBahce\StructType\PackageType[] $actualPackage
     * @param \Gek\UyumBahce\StructType\TransportEquipmentType[] $transportEquipment
     * @param \Gek\UyumBahce\StructType\TransportMeansType[] $transportMeans
     * @param \Gek\UyumBahce\StructType\HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @param \Gek\UyumBahce\StructType\DimensionType[] $measurementDimension
     * @param \Gek\UyumBahce\StructType\TemperatureType $minimumTemperature
     * @param \Gek\UyumBahce\StructType\TemperatureType $maximumTemperature
     * @param \Gek\UyumBahce\StructType\DimensionType $floorSpaceMeasurementDimension
     * @param \Gek\UyumBahce\StructType\DimensionType $palletSpaceMeasurementDimension
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $shipmentDocumentReference
     * @param \Gek\UyumBahce\StructType\CustomsDeclarationType[] $customsDeclaration
     */
    public function __construct(\Gek\UyumBahce\StructType\IDType $iD = null, \Gek\UyumBahce\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null, \Gek\UyumBahce\StructType\HandlingCodeType $handlingCode = null, \Gek\UyumBahce\StructType\HandlingInstructionsType $handlingInstructions = null, \Gek\UyumBahce\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null, \Gek\UyumBahce\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, \Gek\UyumBahce\StructType\TotalPackageQuantityType $totalPackageQuantity = null, array $damageRemarks = array(), \Gek\UyumBahce\StructType\TraceIDType $traceID = null, array $actualPackage = array(), array $transportEquipment = array(), array $transportMeans = array(), array $hazardousGoodsTransit = array(), array $measurementDimension = array(), \Gek\UyumBahce\StructType\TemperatureType $minimumTemperature = null, \Gek\UyumBahce\StructType\TemperatureType $maximumTemperature = null, \Gek\UyumBahce\StructType\DimensionType $floorSpaceMeasurementDimension = null, \Gek\UyumBahce\StructType\DimensionType $palletSpaceMeasurementDimension = null, array $shipmentDocumentReference = array(), array $customsDeclaration = array())
    {
        $this
            ->setID($iD)
            ->setTransportHandlingUnitTypeCode($transportHandlingUnitTypeCode)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalPackageQuantity($totalPackageQuantity)
            ->setDamageRemarks($damageRemarks)
            ->setTraceID($traceID)
            ->setActualPackage($actualPackage)
            ->setTransportEquipment($transportEquipment)
            ->setTransportMeans($transportMeans)
            ->setHazardousGoodsTransit($hazardousGoodsTransit)
            ->setMeasurementDimension($measurementDimension)
            ->setMinimumTemperature($minimumTemperature)
            ->setMaximumTemperature($maximumTemperature)
            ->setFloorSpaceMeasurementDimension($floorSpaceMeasurementDimension)
            ->setPalletSpaceMeasurementDimension($palletSpaceMeasurementDimension)
            ->setShipmentDocumentReference($shipmentDocumentReference)
            ->setCustomsDeclaration($customsDeclaration);
    }
    /**
     * Get ID value
     * @return \Gek\UyumBahce\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setID(\Gek\UyumBahce\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TransportHandlingUnitTypeCode value
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitTypeCodeType|null
     */
    public function getTransportHandlingUnitTypeCode()
    {
        return $this->TransportHandlingUnitTypeCode;
    }
    /**
     * Set TransportHandlingUnitTypeCode value
     * @param \Gek\UyumBahce\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setTransportHandlingUnitTypeCode(\Gek\UyumBahce\StructType\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null)
    {
        $this->TransportHandlingUnitTypeCode = $transportHandlingUnitTypeCode;
        return $this;
    }
    /**
     * Get HandlingCode value
     * @return \Gek\UyumBahce\StructType\HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }
    /**
     * Set HandlingCode value
     * @param \Gek\UyumBahce\StructType\HandlingCodeType $handlingCode
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setHandlingCode(\Gek\UyumBahce\StructType\HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * @return \Gek\UyumBahce\StructType\HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }
    /**
     * Set HandlingInstructions value
     * @param \Gek\UyumBahce\StructType\HandlingInstructionsType $handlingInstructions
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setHandlingInstructions(\Gek\UyumBahce\StructType\HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \Gek\UyumBahce\StructType\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \Gek\UyumBahce\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setHazardousRiskIndicator(\Gek\UyumBahce\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return \Gek\UyumBahce\StructType\TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param \Gek\UyumBahce\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setTotalGoodsItemQuantity(\Gek\UyumBahce\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalPackageQuantity value
     * @return \Gek\UyumBahce\StructType\TotalPackageQuantityType|null
     */
    public function getTotalPackageQuantity()
    {
        return $this->TotalPackageQuantity;
    }
    /**
     * Set TotalPackageQuantity value
     * @param \Gek\UyumBahce\StructType\TotalPackageQuantityType $totalPackageQuantity
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setTotalPackageQuantity(\Gek\UyumBahce\StructType\TotalPackageQuantityType $totalPackageQuantity = null)
    {
        $this->TotalPackageQuantity = $totalPackageQuantity;
        return $this;
    }
    /**
     * Get DamageRemarks value
     * @return \Gek\UyumBahce\StructType\DamageRemarksType[]|null
     */
    public function getDamageRemarks()
    {
        return $this->DamageRemarks;
    }
    /**
     * This method is responsible for validating the values passed to the setDamageRemarks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDamageRemarks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDamageRemarksForArrayConstraintsFromSetDamageRemarks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeDamageRemarksItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeDamageRemarksItem instanceof \Gek\UyumBahce\StructType\DamageRemarksType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeDamageRemarksItem) ? get_class($transportHandlingUnitTypeDamageRemarksItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeDamageRemarksItem), var_export($transportHandlingUnitTypeDamageRemarksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DamageRemarks property can only contain items of type \Gek\UyumBahce\StructType\DamageRemarksType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DamageRemarks value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DamageRemarksType[] $damageRemarks
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setDamageRemarks(array $damageRemarks = array())
    {
        // validation for constraint: array
        if ('' !== ($damageRemarksArrayErrorMessage = self::validateDamageRemarksForArrayConstraintsFromSetDamageRemarks($damageRemarks))) {
            throw new \InvalidArgumentException($damageRemarksArrayErrorMessage, __LINE__);
        }
        $this->DamageRemarks = $damageRemarks;
        return $this;
    }
    /**
     * Add item to DamageRemarks value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DamageRemarksType $item
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function addToDamageRemarks(\Gek\UyumBahce\StructType\DamageRemarksType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DamageRemarksType) {
            throw new \InvalidArgumentException(sprintf('The DamageRemarks property can only contain items of type \Gek\UyumBahce\StructType\DamageRemarksType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DamageRemarks[] = $item;
        return $this;
    }
    /**
     * Get TraceID value
     * @return \Gek\UyumBahce\StructType\TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }
    /**
     * Set TraceID value
     * @param \Gek\UyumBahce\StructType\TraceIDType $traceID
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setTraceID(\Gek\UyumBahce\StructType\TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }
    /**
     * Get ActualPackage value
     * @return \Gek\UyumBahce\StructType\PackageType[]|null
     */
    public function getActualPackage()
    {
        return $this->ActualPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setActualPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActualPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActualPackageForArrayConstraintsFromSetActualPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeActualPackageItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeActualPackageItem instanceof \Gek\UyumBahce\StructType\PackageType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeActualPackageItem) ? get_class($transportHandlingUnitTypeActualPackageItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeActualPackageItem), var_export($transportHandlingUnitTypeActualPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActualPackage property can only contain items of type \Gek\UyumBahce\StructType\PackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActualPackage value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PackageType[] $actualPackage
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setActualPackage(array $actualPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($actualPackageArrayErrorMessage = self::validateActualPackageForArrayConstraintsFromSetActualPackage($actualPackage))) {
            throw new \InvalidArgumentException($actualPackageArrayErrorMessage, __LINE__);
        }
        $this->ActualPackage = $actualPackage;
        return $this;
    }
    /**
     * Add item to ActualPackage value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PackageType $item
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function addToActualPackage(\Gek\UyumBahce\StructType\PackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\PackageType) {
            throw new \InvalidArgumentException(sprintf('The ActualPackage property can only contain items of type \Gek\UyumBahce\StructType\PackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActualPackage[] = $item;
        return $this;
    }
    /**
     * Get TransportEquipment value
     * @return \Gek\UyumBahce\StructType\TransportEquipmentType[]|null
     */
    public function getTransportEquipment()
    {
        return $this->TransportEquipment;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportEquipmentForArrayConstraintsFromSetTransportEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeTransportEquipmentItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeTransportEquipmentItem instanceof \Gek\UyumBahce\StructType\TransportEquipmentType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeTransportEquipmentItem) ? get_class($transportHandlingUnitTypeTransportEquipmentItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeTransportEquipmentItem), var_export($transportHandlingUnitTypeTransportEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportEquipment property can only contain items of type \Gek\UyumBahce\StructType\TransportEquipmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportEquipment value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TransportEquipmentType[] $transportEquipment
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setTransportEquipment(array $transportEquipment = array())
    {
        // validation for constraint: array
        if ('' !== ($transportEquipmentArrayErrorMessage = self::validateTransportEquipmentForArrayConstraintsFromSetTransportEquipment($transportEquipment))) {
            throw new \InvalidArgumentException($transportEquipmentArrayErrorMessage, __LINE__);
        }
        $this->TransportEquipment = $transportEquipment;
        return $this;
    }
    /**
     * Add item to TransportEquipment value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TransportEquipmentType $item
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function addToTransportEquipment(\Gek\UyumBahce\StructType\TransportEquipmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\TransportEquipmentType) {
            throw new \InvalidArgumentException(sprintf('The TransportEquipment property can only contain items of type \Gek\UyumBahce\StructType\TransportEquipmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportEquipment[] = $item;
        return $this;
    }
    /**
     * Get TransportMeans value
     * @return \Gek\UyumBahce\StructType\TransportMeansType[]|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportMeans method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportMeans method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportMeansForArrayConstraintsFromSetTransportMeans(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeTransportMeansItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeTransportMeansItem instanceof \Gek\UyumBahce\StructType\TransportMeansType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeTransportMeansItem) ? get_class($transportHandlingUnitTypeTransportMeansItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeTransportMeansItem), var_export($transportHandlingUnitTypeTransportMeansItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportMeans property can only contain items of type \Gek\UyumBahce\StructType\TransportMeansType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportMeans value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TransportMeansType[] $transportMeans
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setTransportMeans(array $transportMeans = array())
    {
        // validation for constraint: array
        if ('' !== ($transportMeansArrayErrorMessage = self::validateTransportMeansForArrayConstraintsFromSetTransportMeans($transportMeans))) {
            throw new \InvalidArgumentException($transportMeansArrayErrorMessage, __LINE__);
        }
        $this->TransportMeans = $transportMeans;
        return $this;
    }
    /**
     * Add item to TransportMeans value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TransportMeansType $item
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function addToTransportMeans(\Gek\UyumBahce\StructType\TransportMeansType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\TransportMeansType) {
            throw new \InvalidArgumentException(sprintf('The TransportMeans property can only contain items of type \Gek\UyumBahce\StructType\TransportMeansType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportMeans[] = $item;
        return $this;
    }
    /**
     * Get HazardousGoodsTransit value
     * @return \Gek\UyumBahce\StructType\HazardousGoodsTransitType[]|null
     */
    public function getHazardousGoodsTransit()
    {
        return $this->HazardousGoodsTransit;
    }
    /**
     * This method is responsible for validating the values passed to the setHazardousGoodsTransit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHazardousGoodsTransit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHazardousGoodsTransitForArrayConstraintsFromSetHazardousGoodsTransit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeHazardousGoodsTransitItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeHazardousGoodsTransitItem instanceof \Gek\UyumBahce\StructType\HazardousGoodsTransitType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeHazardousGoodsTransitItem) ? get_class($transportHandlingUnitTypeHazardousGoodsTransitItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeHazardousGoodsTransitItem), var_export($transportHandlingUnitTypeHazardousGoodsTransitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HazardousGoodsTransit property can only contain items of type \Gek\UyumBahce\StructType\HazardousGoodsTransitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HazardousGoodsTransit value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setHazardousGoodsTransit(array $hazardousGoodsTransit = array())
    {
        // validation for constraint: array
        if ('' !== ($hazardousGoodsTransitArrayErrorMessage = self::validateHazardousGoodsTransitForArrayConstraintsFromSetHazardousGoodsTransit($hazardousGoodsTransit))) {
            throw new \InvalidArgumentException($hazardousGoodsTransitArrayErrorMessage, __LINE__);
        }
        $this->HazardousGoodsTransit = $hazardousGoodsTransit;
        return $this;
    }
    /**
     * Add item to HazardousGoodsTransit value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\HazardousGoodsTransitType $item
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function addToHazardousGoodsTransit(\Gek\UyumBahce\StructType\HazardousGoodsTransitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\HazardousGoodsTransitType) {
            throw new \InvalidArgumentException(sprintf('The HazardousGoodsTransit property can only contain items of type \Gek\UyumBahce\StructType\HazardousGoodsTransitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HazardousGoodsTransit[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Gek\UyumBahce\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeMeasurementDimensionItem instanceof \Gek\UyumBahce\StructType\DimensionType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeMeasurementDimensionItem) ? get_class($transportHandlingUnitTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeMeasurementDimensionItem), var_export($transportHandlingUnitTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DimensionType[] $measurementDimension
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DimensionType $item
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function addToMeasurementDimension(\Gek\UyumBahce\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return \Gek\UyumBahce\StructType\TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param \Gek\UyumBahce\StructType\TemperatureType $minimumTemperature
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setMinimumTemperature(\Gek\UyumBahce\StructType\TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return \Gek\UyumBahce\StructType\TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param \Gek\UyumBahce\StructType\TemperatureType $maximumTemperature
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setMaximumTemperature(\Gek\UyumBahce\StructType\TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get FloorSpaceMeasurementDimension value
     * @return \Gek\UyumBahce\StructType\DimensionType|null
     */
    public function getFloorSpaceMeasurementDimension()
    {
        return $this->FloorSpaceMeasurementDimension;
    }
    /**
     * Set FloorSpaceMeasurementDimension value
     * @param \Gek\UyumBahce\StructType\DimensionType $floorSpaceMeasurementDimension
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setFloorSpaceMeasurementDimension(\Gek\UyumBahce\StructType\DimensionType $floorSpaceMeasurementDimension = null)
    {
        $this->FloorSpaceMeasurementDimension = $floorSpaceMeasurementDimension;
        return $this;
    }
    /**
     * Get PalletSpaceMeasurementDimension value
     * @return \Gek\UyumBahce\StructType\DimensionType|null
     */
    public function getPalletSpaceMeasurementDimension()
    {
        return $this->PalletSpaceMeasurementDimension;
    }
    /**
     * Set PalletSpaceMeasurementDimension value
     * @param \Gek\UyumBahce\StructType\DimensionType $palletSpaceMeasurementDimension
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setPalletSpaceMeasurementDimension(\Gek\UyumBahce\StructType\DimensionType $palletSpaceMeasurementDimension = null)
    {
        $this->PalletSpaceMeasurementDimension = $palletSpaceMeasurementDimension;
        return $this;
    }
    /**
     * Get ShipmentDocumentReference value
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType[]|null
     */
    public function getShipmentDocumentReference()
    {
        return $this->ShipmentDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentDocumentReferenceForArrayConstraintsFromSetShipmentDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeShipmentDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeShipmentDocumentReferenceItem instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeShipmentDocumentReferenceItem) ? get_class($transportHandlingUnitTypeShipmentDocumentReferenceItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeShipmentDocumentReferenceItem), var_export($transportHandlingUnitTypeShipmentDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $shipmentDocumentReference
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setShipmentDocumentReference(array $shipmentDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentDocumentReferenceArrayErrorMessage = self::validateShipmentDocumentReferenceForArrayConstraintsFromSetShipmentDocumentReference($shipmentDocumentReference))) {
            throw new \InvalidArgumentException($shipmentDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ShipmentDocumentReference = $shipmentDocumentReference;
        return $this;
    }
    /**
     * Add item to ShipmentDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType $item
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function addToShipmentDocumentReference(\Gek\UyumBahce\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get CustomsDeclaration value
     * @return \Gek\UyumBahce\StructType\CustomsDeclarationType[]|null
     */
    public function getCustomsDeclaration()
    {
        return $this->CustomsDeclaration;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomsDeclaration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomsDeclaration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsDeclarationForArrayConstraintsFromSetCustomsDeclaration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeCustomsDeclarationItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeCustomsDeclarationItem instanceof \Gek\UyumBahce\StructType\CustomsDeclarationType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeCustomsDeclarationItem) ? get_class($transportHandlingUnitTypeCustomsDeclarationItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeCustomsDeclarationItem), var_export($transportHandlingUnitTypeCustomsDeclarationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomsDeclaration property can only contain items of type \Gek\UyumBahce\StructType\CustomsDeclarationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomsDeclaration value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\CustomsDeclarationType[] $customsDeclaration
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function setCustomsDeclaration(array $customsDeclaration = array())
    {
        // validation for constraint: array
        if ('' !== ($customsDeclarationArrayErrorMessage = self::validateCustomsDeclarationForArrayConstraintsFromSetCustomsDeclaration($customsDeclaration))) {
            throw new \InvalidArgumentException($customsDeclarationArrayErrorMessage, __LINE__);
        }
        $this->CustomsDeclaration = $customsDeclaration;
        return $this;
    }
    /**
     * Add item to CustomsDeclaration value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\CustomsDeclarationType $item
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType
     */
    public function addToCustomsDeclaration(\Gek\UyumBahce\StructType\CustomsDeclarationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\CustomsDeclarationType) {
            throw new \InvalidArgumentException(sprintf('The CustomsDeclaration property can only contain items of type \Gek\UyumBahce\StructType\CustomsDeclarationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomsDeclaration[] = $item;
        return $this;
    }
}
