<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureType StructType
 * @subpackage Structs
 */
class TemperatureType extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:AttributeID
     * @var \Gek\UyumBahce\StructType\AttributeIDType
     */
    public $AttributeID;
    /**
     * The Measure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Measure
     * @var \Gek\UyumBahce\StructType\MeasureType
     */
    public $Measure;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Description
     * @var \Gek\UyumBahce\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * Constructor method for TemperatureType
     * @uses TemperatureType::setAttributeID()
     * @uses TemperatureType::setMeasure()
     * @uses TemperatureType::setDescription()
     * @param \Gek\UyumBahce\StructType\AttributeIDType $attributeID
     * @param \Gek\UyumBahce\StructType\MeasureType $measure
     * @param \Gek\UyumBahce\StructType\DescriptionType[] $description
     */
    public function __construct(\Gek\UyumBahce\StructType\AttributeIDType $attributeID = null, \Gek\UyumBahce\StructType\MeasureType $measure = null, array $description = array())
    {
        $this
            ->setAttributeID($attributeID)
            ->setMeasure($measure)
            ->setDescription($description);
    }
    /**
     * Get AttributeID value
     * @return \Gek\UyumBahce\StructType\AttributeIDType|null
     */
    public function getAttributeID()
    {
        return $this->AttributeID;
    }
    /**
     * Set AttributeID value
     * @param \Gek\UyumBahce\StructType\AttributeIDType $attributeID
     * @return \Gek\UyumBahce\StructType\TemperatureType
     */
    public function setAttributeID(\Gek\UyumBahce\StructType\AttributeIDType $attributeID = null)
    {
        $this->AttributeID = $attributeID;
        return $this;
    }
    /**
     * Get Measure value
     * @return \Gek\UyumBahce\StructType\MeasureType|null
     */
    public function getMeasure()
    {
        return $this->Measure;
    }
    /**
     * Set Measure value
     * @param \Gek\UyumBahce\StructType\MeasureType $measure
     * @return \Gek\UyumBahce\StructType\TemperatureType
     */
    public function setMeasure(\Gek\UyumBahce\StructType\MeasureType $measure = null)
    {
        $this->Measure = $measure;
        return $this;
    }
    /**
     * Get Description value
     * @return \Gek\UyumBahce\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $temperatureTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$temperatureTypeDescriptionItem instanceof \Gek\UyumBahce\StructType\DescriptionType) {
                $invalidValues[] = is_object($temperatureTypeDescriptionItem) ? get_class($temperatureTypeDescriptionItem) : sprintf('%s(%s)', gettype($temperatureTypeDescriptionItem), var_export($temperatureTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \Gek\UyumBahce\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DescriptionType[] $description
     * @return \Gek\UyumBahce\StructType\TemperatureType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DescriptionType $item
     * @return \Gek\UyumBahce\StructType\TemperatureType
     */
    public function addToDescription(\Gek\UyumBahce\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \Gek\UyumBahce\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
}
