<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StowageType StructType
 * @subpackage Structs
 */
class StowageType extends AbstractStructBase
{
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LocationID
     * @var \Gek\UyumBahce\StructType\LocationIDType
     */
    public $LocationID;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Location
     * @var \Gek\UyumBahce\StructType\LocationType[]
     */
    public $Location;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for StowageType
     * @uses StowageType::setLocationID()
     * @uses StowageType::setLocation()
     * @uses StowageType::setMeasurementDimension()
     * @param \Gek\UyumBahce\StructType\LocationIDType $locationID
     * @param \Gek\UyumBahce\StructType\LocationType[] $location
     * @param \Gek\UyumBahce\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\Gek\UyumBahce\StructType\LocationIDType $locationID = null, array $location = array(), array $measurementDimension = array())
    {
        $this
            ->setLocationID($locationID)
            ->setLocation($location)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get LocationID value
     * @return \Gek\UyumBahce\StructType\LocationIDType|null
     */
    public function getLocationID()
    {
        return $this->LocationID;
    }
    /**
     * Set LocationID value
     * @param \Gek\UyumBahce\StructType\LocationIDType $locationID
     * @return \Gek\UyumBahce\StructType\StowageType
     */
    public function setLocationID(\Gek\UyumBahce\StructType\LocationIDType $locationID = null)
    {
        $this->LocationID = $locationID;
        return $this;
    }
    /**
     * Get Location value
     * @return \Gek\UyumBahce\StructType\LocationType[]|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stowageTypeLocationItem) {
            // validation for constraint: itemType
            if (!$stowageTypeLocationItem instanceof \Gek\UyumBahce\StructType\LocationType) {
                $invalidValues[] = is_object($stowageTypeLocationItem) ? get_class($stowageTypeLocationItem) : sprintf('%s(%s)', gettype($stowageTypeLocationItem), var_export($stowageTypeLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location property can only contain items of type \Gek\UyumBahce\StructType\LocationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\LocationType[] $location
     * @return \Gek\UyumBahce\StructType\StowageType
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Add item to Location value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\LocationType $item
     * @return \Gek\UyumBahce\StructType\StowageType
     */
    public function addToLocation(\Gek\UyumBahce\StructType\LocationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\LocationType) {
            throw new \InvalidArgumentException(sprintf('The Location property can only contain items of type \Gek\UyumBahce\StructType\LocationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Gek\UyumBahce\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stowageTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$stowageTypeMeasurementDimensionItem instanceof \Gek\UyumBahce\StructType\DimensionType) {
                $invalidValues[] = is_object($stowageTypeMeasurementDimensionItem) ? get_class($stowageTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($stowageTypeMeasurementDimensionItem), var_export($stowageTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DimensionType[] $measurementDimension
     * @return \Gek\UyumBahce\StructType\StowageType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DimensionType $item
     * @return \Gek\UyumBahce\StructType\StowageType
     */
    public function addToMeasurementDimension(\Gek\UyumBahce\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
