<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SmsMessageInformation StructType
 * @subpackage Structs
 */
class SmsMessageInformation extends AbstractStructBase
{
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The SmsAccountIdentifier
     * @var string
     */
    public $SmsAccountIdentifier;
    /**
     * The BodyXsltIdentifier
     * @var string
     */
    public $BodyXsltIdentifier;
    /**
     * The To
     * @var string
     */
    public $To;
    /**
     * Constructor method for SmsMessageInformation
     * @uses SmsMessageInformation::setSubject()
     * @uses SmsMessageInformation::setSmsAccountIdentifier()
     * @uses SmsMessageInformation::setBodyXsltIdentifier()
     * @uses SmsMessageInformation::setTo()
     * @param string $subject
     * @param string $smsAccountIdentifier
     * @param string $bodyXsltIdentifier
     * @param string $to
     */
    public function __construct($subject = null, $smsAccountIdentifier = null, $bodyXsltIdentifier = null, $to = null)
    {
        $this
            ->setSubject($subject)
            ->setSmsAccountIdentifier($smsAccountIdentifier)
            ->setBodyXsltIdentifier($bodyXsltIdentifier)
            ->setTo($to);
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \Gek\UyumBahce\StructType\SmsMessageInformation
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get SmsAccountIdentifier value
     * @return string|null
     */
    public function getSmsAccountIdentifier()
    {
        return $this->SmsAccountIdentifier;
    }
    /**
     * Set SmsAccountIdentifier value
     * @param string $smsAccountIdentifier
     * @return \Gek\UyumBahce\StructType\SmsMessageInformation
     */
    public function setSmsAccountIdentifier($smsAccountIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($smsAccountIdentifier) && !is_string($smsAccountIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smsAccountIdentifier, true), gettype($smsAccountIdentifier)), __LINE__);
        }
        $this->SmsAccountIdentifier = $smsAccountIdentifier;
        return $this;
    }
    /**
     * Get BodyXsltIdentifier value
     * @return string|null
     */
    public function getBodyXsltIdentifier()
    {
        return $this->BodyXsltIdentifier;
    }
    /**
     * Set BodyXsltIdentifier value
     * @param string $bodyXsltIdentifier
     * @return \Gek\UyumBahce\StructType\SmsMessageInformation
     */
    public function setBodyXsltIdentifier($bodyXsltIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($bodyXsltIdentifier) && !is_string($bodyXsltIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bodyXsltIdentifier, true), gettype($bodyXsltIdentifier)), __LINE__);
        }
        $this->BodyXsltIdentifier = $bodyXsltIdentifier;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \Gek\UyumBahce\StructType\SmsMessageInformation
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
}
