<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureType StructType
 * @subpackage Structs
 */
class SignatureType extends AbstractStructBase
{
    /**
     * The SignedInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\SignedInfoType
     */
    public $SignedInfo;
    /**
     * The SignatureValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\SignatureValueType
     */
    public $SignatureValue;
    /**
     * The KeyInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\KeyInfoType
     */
    public $KeyInfo;
    /**
     * The Object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ObjectType[]
     */
    public $Object;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var \Gek\UyumBahce\StructType\IDType
     */
    public $ID;
    /**
     * The SignatoryParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PartyType
     */
    public $SignatoryParty;
    /**
     * The DigitalSignatureAttachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\AttachmentType
     */
    public $DigitalSignatureAttachment;
    /**
     * Constructor method for SignatureType
     * @uses SignatureType::setSignedInfo()
     * @uses SignatureType::setSignatureValue()
     * @uses SignatureType::setKeyInfo()
     * @uses SignatureType::setObject()
     * @uses SignatureType::setId()
     * @uses SignatureType::setID_1()
     * @uses SignatureType::setSignatoryParty()
     * @uses SignatureType::setDigitalSignatureAttachment()
     * @param \Gek\UyumBahce\StructType\SignedInfoType $signedInfo
     * @param \Gek\UyumBahce\StructType\SignatureValueType $signatureValue
     * @param \Gek\UyumBahce\StructType\KeyInfoType $keyInfo
     * @param \Gek\UyumBahce\StructType\ObjectType[] $object
     * @param string $id
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @param \Gek\UyumBahce\StructType\PartyType $signatoryParty
     * @param \Gek\UyumBahce\StructType\AttachmentType $digitalSignatureAttachment
     */
    public function __construct(\Gek\UyumBahce\StructType\SignedInfoType $signedInfo = null, \Gek\UyumBahce\StructType\SignatureValueType $signatureValue = null, \Gek\UyumBahce\StructType\KeyInfoType $keyInfo = null, array $object = array(), $id = null, \Gek\UyumBahce\StructType\IDType $iD_1 = null, \Gek\UyumBahce\StructType\PartyType $signatoryParty = null, \Gek\UyumBahce\StructType\AttachmentType $digitalSignatureAttachment = null)
    {
        $this
            ->setSignedInfo($signedInfo)
            ->setSignatureValue($signatureValue)
            ->setKeyInfo($keyInfo)
            ->setObject($object)
            ->setId($id)
            ->setID_1($iD_1)
            ->setSignatoryParty($signatoryParty)
            ->setDigitalSignatureAttachment($digitalSignatureAttachment);
    }
    /**
     * Get SignedInfo value
     * @return \Gek\UyumBahce\StructType\SignedInfoType|null
     */
    public function getSignedInfo()
    {
        return $this->SignedInfo;
    }
    /**
     * Set SignedInfo value
     * @param \Gek\UyumBahce\StructType\SignedInfoType $signedInfo
     * @return \Gek\UyumBahce\StructType\SignatureType
     */
    public function setSignedInfo(\Gek\UyumBahce\StructType\SignedInfoType $signedInfo = null)
    {
        $this->SignedInfo = $signedInfo;
        return $this;
    }
    /**
     * Get SignatureValue value
     * @return \Gek\UyumBahce\StructType\SignatureValueType|null
     */
    public function getSignatureValue()
    {
        return $this->SignatureValue;
    }
    /**
     * Set SignatureValue value
     * @param \Gek\UyumBahce\StructType\SignatureValueType $signatureValue
     * @return \Gek\UyumBahce\StructType\SignatureType
     */
    public function setSignatureValue(\Gek\UyumBahce\StructType\SignatureValueType $signatureValue = null)
    {
        $this->SignatureValue = $signatureValue;
        return $this;
    }
    /**
     * Get KeyInfo value
     * @return \Gek\UyumBahce\StructType\KeyInfoType|null
     */
    public function getKeyInfo()
    {
        return $this->KeyInfo;
    }
    /**
     * Set KeyInfo value
     * @param \Gek\UyumBahce\StructType\KeyInfoType $keyInfo
     * @return \Gek\UyumBahce\StructType\SignatureType
     */
    public function setKeyInfo(\Gek\UyumBahce\StructType\KeyInfoType $keyInfo = null)
    {
        $this->KeyInfo = $keyInfo;
        return $this;
    }
    /**
     * Get Object value
     * @return \Gek\UyumBahce\StructType\ObjectType[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * This method is responsible for validating the values passed to the setObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectForArrayConstraintsFromSetObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $signatureTypeObjectItem) {
            // validation for constraint: itemType
            if (!$signatureTypeObjectItem instanceof \Gek\UyumBahce\StructType\ObjectType) {
                $invalidValues[] = is_object($signatureTypeObjectItem) ? get_class($signatureTypeObjectItem) : sprintf('%s(%s)', gettype($signatureTypeObjectItem), var_export($signatureTypeObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Object property can only contain items of type \Gek\UyumBahce\StructType\ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Object value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ObjectType[] $object
     * @return \Gek\UyumBahce\StructType\SignatureType
     */
    public function setObject(array $object = array())
    {
        // validation for constraint: array
        if ('' !== ($objectArrayErrorMessage = self::validateObjectForArrayConstraintsFromSetObject($object))) {
            throw new \InvalidArgumentException($objectArrayErrorMessage, __LINE__);
        }
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ObjectType $item
     * @return \Gek\UyumBahce\StructType\SignatureType
     */
    public function addToObject(\Gek\UyumBahce\StructType\ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\ObjectType) {
            throw new \InvalidArgumentException(sprintf('The Object property can only contain items of type \Gek\UyumBahce\StructType\ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Gek\UyumBahce\StructType\SignatureType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ID value
     * @return \Gek\UyumBahce\StructType\IDType|null
     */
    public function getID_1()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @return \Gek\UyumBahce\StructType\SignatureType
     */
    public function setID_1(\Gek\UyumBahce\StructType\IDType $iD_1 = null)
    {
        $this->ID = $iD_1;
        return $this;
    }
    /**
     * Get SignatoryParty value
     * @return \Gek\UyumBahce\StructType\PartyType|null
     */
    public function getSignatoryParty()
    {
        return $this->SignatoryParty;
    }
    /**
     * Set SignatoryParty value
     * @param \Gek\UyumBahce\StructType\PartyType $signatoryParty
     * @return \Gek\UyumBahce\StructType\SignatureType
     */
    public function setSignatoryParty(\Gek\UyumBahce\StructType\PartyType $signatoryParty = null)
    {
        $this->SignatoryParty = $signatoryParty;
        return $this;
    }
    /**
     * Get DigitalSignatureAttachment value
     * @return \Gek\UyumBahce\StructType\AttachmentType|null
     */
    public function getDigitalSignatureAttachment()
    {
        return $this->DigitalSignatureAttachment;
    }
    /**
     * Set DigitalSignatureAttachment value
     * @param \Gek\UyumBahce\StructType\AttachmentType $digitalSignatureAttachment
     * @return \Gek\UyumBahce\StructType\SignatureType
     */
    public function setDigitalSignatureAttachment(\Gek\UyumBahce\StructType\AttachmentType $digitalSignatureAttachment = null)
    {
        $this->DigitalSignatureAttachment = $digitalSignatureAttachment;
        return $this;
    }
}
