<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType StructType
 * @subpackage Structs
 */
class ShipmentType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var \Gek\UyumBahce\StructType\IDType
     */
    public $ID;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HandlingCode
     * @var \Gek\UyumBahce\StructType\HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HandlingInstructions
     * @var \Gek\UyumBahce\StructType\HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:GrossWeightMeasure
     * @var \Gek\UyumBahce\StructType\GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NetWeightMeasure
     * @var \Gek\UyumBahce\StructType\NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:GrossVolumeMeasure
     * @var \Gek\UyumBahce\StructType\GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NetVolumeMeasure
     * @var \Gek\UyumBahce\StructType\NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TotalGoodsItemQuantity
     * @var \Gek\UyumBahce\StructType\TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalTransportHandlingUnitQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TotalTransportHandlingUnitQuantity
     * @var \Gek\UyumBahce\StructType\TotalTransportHandlingUnitQuantityType
     */
    public $TotalTransportHandlingUnitQuantity;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:InsuranceValueAmount
     * @var \Gek\UyumBahce\StructType\InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredCustomsValueAmount
     * @var \Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredForCarriageValueAmount
     * @var \Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredStatisticsValueAmount
     * @var \Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:FreeOnBoardValueAmount
     * @var \Gek\UyumBahce\StructType\FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The SpecialInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:SpecialInstructions
     * @var \Gek\UyumBahce\StructType\SpecialInstructionsType[]
     */
    public $SpecialInstructions;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The ShipmentStage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ShipmentStageType[]
     */
    public $ShipmentStage;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DeliveryType
     */
    public $Delivery;
    /**
     * The TransportHandlingUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\TransportHandlingUnitType[]
     */
    public $TransportHandlingUnit;
    /**
     * The ReturnAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\AddressType
     */
    public $ReturnAddress;
    /**
     * The FirstArrivalPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\LocationType
     */
    public $FirstArrivalPortLocation;
    /**
     * The LastExitPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\LocationType
     */
    public $LastExitPortLocation;
    /**
     * Constructor method for ShipmentType
     * @uses ShipmentType::setID()
     * @uses ShipmentType::setHandlingCode()
     * @uses ShipmentType::setHandlingInstructions()
     * @uses ShipmentType::setGrossWeightMeasure()
     * @uses ShipmentType::setNetWeightMeasure()
     * @uses ShipmentType::setGrossVolumeMeasure()
     * @uses ShipmentType::setNetVolumeMeasure()
     * @uses ShipmentType::setTotalGoodsItemQuantity()
     * @uses ShipmentType::setTotalTransportHandlingUnitQuantity()
     * @uses ShipmentType::setInsuranceValueAmount()
     * @uses ShipmentType::setDeclaredCustomsValueAmount()
     * @uses ShipmentType::setDeclaredForCarriageValueAmount()
     * @uses ShipmentType::setDeclaredStatisticsValueAmount()
     * @uses ShipmentType::setFreeOnBoardValueAmount()
     * @uses ShipmentType::setSpecialInstructions()
     * @uses ShipmentType::setGoodsItem()
     * @uses ShipmentType::setShipmentStage()
     * @uses ShipmentType::setDelivery()
     * @uses ShipmentType::setTransportHandlingUnit()
     * @uses ShipmentType::setReturnAddress()
     * @uses ShipmentType::setFirstArrivalPortLocation()
     * @uses ShipmentType::setLastExitPortLocation()
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @param \Gek\UyumBahce\StructType\HandlingCodeType $handlingCode
     * @param \Gek\UyumBahce\StructType\HandlingInstructionsType $handlingInstructions
     * @param \Gek\UyumBahce\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @param \Gek\UyumBahce\StructType\NetWeightMeasureType $netWeightMeasure
     * @param \Gek\UyumBahce\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @param \Gek\UyumBahce\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @param \Gek\UyumBahce\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param \Gek\UyumBahce\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @param \Gek\UyumBahce\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @param \Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param \Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param \Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param \Gek\UyumBahce\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param \Gek\UyumBahce\StructType\SpecialInstructionsType[] $specialInstructions
     * @param \Gek\UyumBahce\StructType\GoodsItemType[] $goodsItem
     * @param \Gek\UyumBahce\StructType\ShipmentStageType[] $shipmentStage
     * @param \Gek\UyumBahce\StructType\DeliveryType $delivery
     * @param \Gek\UyumBahce\StructType\TransportHandlingUnitType[] $transportHandlingUnit
     * @param \Gek\UyumBahce\StructType\AddressType $returnAddress
     * @param \Gek\UyumBahce\StructType\LocationType $firstArrivalPortLocation
     * @param \Gek\UyumBahce\StructType\LocationType $lastExitPortLocation
     */
    public function __construct(\Gek\UyumBahce\StructType\IDType $iD = null, \Gek\UyumBahce\StructType\HandlingCodeType $handlingCode = null, \Gek\UyumBahce\StructType\HandlingInstructionsType $handlingInstructions = null, \Gek\UyumBahce\StructType\GrossWeightMeasureType $grossWeightMeasure = null, \Gek\UyumBahce\StructType\NetWeightMeasureType $netWeightMeasure = null, \Gek\UyumBahce\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null, \Gek\UyumBahce\StructType\NetVolumeMeasureType $netVolumeMeasure = null, \Gek\UyumBahce\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, \Gek\UyumBahce\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null, \Gek\UyumBahce\StructType\InsuranceValueAmountType $insuranceValueAmount = null, \Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, \Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, \Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, \Gek\UyumBahce\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, array $specialInstructions = array(), array $goodsItem = array(), array $shipmentStage = array(), \Gek\UyumBahce\StructType\DeliveryType $delivery = null, array $transportHandlingUnit = array(), \Gek\UyumBahce\StructType\AddressType $returnAddress = null, \Gek\UyumBahce\StructType\LocationType $firstArrivalPortLocation = null, \Gek\UyumBahce\StructType\LocationType $lastExitPortLocation = null)
    {
        $this
            ->setID($iD)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalTransportHandlingUnitQuantity($totalTransportHandlingUnitQuantity)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setSpecialInstructions($specialInstructions)
            ->setGoodsItem($goodsItem)
            ->setShipmentStage($shipmentStage)
            ->setDelivery($delivery)
            ->setTransportHandlingUnit($transportHandlingUnit)
            ->setReturnAddress($returnAddress)
            ->setFirstArrivalPortLocation($firstArrivalPortLocation)
            ->setLastExitPortLocation($lastExitPortLocation);
    }
    /**
     * Get ID value
     * @return \Gek\UyumBahce\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setID(\Gek\UyumBahce\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get HandlingCode value
     * @return \Gek\UyumBahce\StructType\HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }
    /**
     * Set HandlingCode value
     * @param \Gek\UyumBahce\StructType\HandlingCodeType $handlingCode
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setHandlingCode(\Gek\UyumBahce\StructType\HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * @return \Gek\UyumBahce\StructType\HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }
    /**
     * Set HandlingInstructions value
     * @param \Gek\UyumBahce\StructType\HandlingInstructionsType $handlingInstructions
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setHandlingInstructions(\Gek\UyumBahce\StructType\HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * @return \Gek\UyumBahce\StructType\GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }
    /**
     * Set GrossWeightMeasure value
     * @param \Gek\UyumBahce\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setGrossWeightMeasure(\Gek\UyumBahce\StructType\GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * @return \Gek\UyumBahce\StructType\NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }
    /**
     * Set NetWeightMeasure value
     * @param \Gek\UyumBahce\StructType\NetWeightMeasureType $netWeightMeasure
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setNetWeightMeasure(\Gek\UyumBahce\StructType\NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * @return \Gek\UyumBahce\StructType\GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }
    /**
     * Set GrossVolumeMeasure value
     * @param \Gek\UyumBahce\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setGrossVolumeMeasure(\Gek\UyumBahce\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * @return \Gek\UyumBahce\StructType\NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }
    /**
     * Set NetVolumeMeasure value
     * @param \Gek\UyumBahce\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setNetVolumeMeasure(\Gek\UyumBahce\StructType\NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return \Gek\UyumBahce\StructType\TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param \Gek\UyumBahce\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setTotalGoodsItemQuantity(\Gek\UyumBahce\StructType\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalTransportHandlingUnitQuantity value
     * @return \Gek\UyumBahce\StructType\TotalTransportHandlingUnitQuantityType|null
     */
    public function getTotalTransportHandlingUnitQuantity()
    {
        return $this->TotalTransportHandlingUnitQuantity;
    }
    /**
     * Set TotalTransportHandlingUnitQuantity value
     * @param \Gek\UyumBahce\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setTotalTransportHandlingUnitQuantity(\Gek\UyumBahce\StructType\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null)
    {
        $this->TotalTransportHandlingUnitQuantity = $totalTransportHandlingUnitQuantity;
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * @return \Gek\UyumBahce\StructType\InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }
    /**
     * Set InsuranceValueAmount value
     * @param \Gek\UyumBahce\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setInsuranceValueAmount(\Gek\UyumBahce\StructType\InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * @return \Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * @param \Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setDeclaredCustomsValueAmount(\Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * @return \Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * @param \Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setDeclaredForCarriageValueAmount(\Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * @return \Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * @param \Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setDeclaredStatisticsValueAmount(\Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * @return \Gek\UyumBahce\StructType\FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * @param \Gek\UyumBahce\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setFreeOnBoardValueAmount(\Gek\UyumBahce\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }
    /**
     * Get SpecialInstructions value
     * @return \Gek\UyumBahce\StructType\SpecialInstructionsType[]|null
     */
    public function getSpecialInstructions()
    {
        return $this->SpecialInstructions;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialInstructions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialInstructions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialInstructionsForArrayConstraintsFromSetSpecialInstructions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeSpecialInstructionsItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeSpecialInstructionsItem instanceof \Gek\UyumBahce\StructType\SpecialInstructionsType) {
                $invalidValues[] = is_object($shipmentTypeSpecialInstructionsItem) ? get_class($shipmentTypeSpecialInstructionsItem) : sprintf('%s(%s)', gettype($shipmentTypeSpecialInstructionsItem), var_export($shipmentTypeSpecialInstructionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialInstructions property can only contain items of type \Gek\UyumBahce\StructType\SpecialInstructionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\SpecialInstructionsType[] $specialInstructions
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setSpecialInstructions(array $specialInstructions = array())
    {
        // validation for constraint: array
        if ('' !== ($specialInstructionsArrayErrorMessage = self::validateSpecialInstructionsForArrayConstraintsFromSetSpecialInstructions($specialInstructions))) {
            throw new \InvalidArgumentException($specialInstructionsArrayErrorMessage, __LINE__);
        }
        $this->SpecialInstructions = $specialInstructions;
        return $this;
    }
    /**
     * Add item to SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\SpecialInstructionsType $item
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function addToSpecialInstructions(\Gek\UyumBahce\StructType\SpecialInstructionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\SpecialInstructionsType) {
            throw new \InvalidArgumentException(sprintf('The SpecialInstructions property can only contain items of type \Gek\UyumBahce\StructType\SpecialInstructionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialInstructions[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \Gek\UyumBahce\StructType\GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsItemForArrayConstraintsFromSetGoodsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeGoodsItemItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeGoodsItemItem instanceof \Gek\UyumBahce\StructType\GoodsItemType) {
                $invalidValues[] = is_object($shipmentTypeGoodsItemItem) ? get_class($shipmentTypeGoodsItemItem) : sprintf('%s(%s)', gettype($shipmentTypeGoodsItemItem), var_export($shipmentTypeGoodsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsItem property can only contain items of type \Gek\UyumBahce\StructType\GoodsItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\GoodsItemType[] $goodsItem
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsItemArrayErrorMessage = self::validateGoodsItemForArrayConstraintsFromSetGoodsItem($goodsItem))) {
            throw new \InvalidArgumentException($goodsItemArrayErrorMessage, __LINE__);
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\GoodsItemType $item
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function addToGoodsItem(\Gek\UyumBahce\StructType\GoodsItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\GoodsItemType) {
            throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of type \Gek\UyumBahce\StructType\GoodsItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get ShipmentStage value
     * @return \Gek\UyumBahce\StructType\ShipmentStageType[]|null
     */
    public function getShipmentStage()
    {
        return $this->ShipmentStage;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentStage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentStage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentStageForArrayConstraintsFromSetShipmentStage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeShipmentStageItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeShipmentStageItem instanceof \Gek\UyumBahce\StructType\ShipmentStageType) {
                $invalidValues[] = is_object($shipmentTypeShipmentStageItem) ? get_class($shipmentTypeShipmentStageItem) : sprintf('%s(%s)', gettype($shipmentTypeShipmentStageItem), var_export($shipmentTypeShipmentStageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentStage property can only contain items of type \Gek\UyumBahce\StructType\ShipmentStageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentStage value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ShipmentStageType[] $shipmentStage
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setShipmentStage(array $shipmentStage = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentStageArrayErrorMessage = self::validateShipmentStageForArrayConstraintsFromSetShipmentStage($shipmentStage))) {
            throw new \InvalidArgumentException($shipmentStageArrayErrorMessage, __LINE__);
        }
        $this->ShipmentStage = $shipmentStage;
        return $this;
    }
    /**
     * Add item to ShipmentStage value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ShipmentStageType $item
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function addToShipmentStage(\Gek\UyumBahce\StructType\ShipmentStageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\ShipmentStageType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentStage property can only contain items of type \Gek\UyumBahce\StructType\ShipmentStageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentStage[] = $item;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \Gek\UyumBahce\StructType\DeliveryType|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \Gek\UyumBahce\StructType\DeliveryType $delivery
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setDelivery(\Gek\UyumBahce\StructType\DeliveryType $delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get TransportHandlingUnit value
     * @return \Gek\UyumBahce\StructType\TransportHandlingUnitType[]|null
     */
    public function getTransportHandlingUnit()
    {
        return $this->TransportHandlingUnit;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportHandlingUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportHandlingUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportHandlingUnitForArrayConstraintsFromSetTransportHandlingUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeTransportHandlingUnitItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeTransportHandlingUnitItem instanceof \Gek\UyumBahce\StructType\TransportHandlingUnitType) {
                $invalidValues[] = is_object($shipmentTypeTransportHandlingUnitItem) ? get_class($shipmentTypeTransportHandlingUnitItem) : sprintf('%s(%s)', gettype($shipmentTypeTransportHandlingUnitItem), var_export($shipmentTypeTransportHandlingUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportHandlingUnit property can only contain items of type \Gek\UyumBahce\StructType\TransportHandlingUnitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportHandlingUnit value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TransportHandlingUnitType[] $transportHandlingUnit
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setTransportHandlingUnit(array $transportHandlingUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($transportHandlingUnitArrayErrorMessage = self::validateTransportHandlingUnitForArrayConstraintsFromSetTransportHandlingUnit($transportHandlingUnit))) {
            throw new \InvalidArgumentException($transportHandlingUnitArrayErrorMessage, __LINE__);
        }
        $this->TransportHandlingUnit = $transportHandlingUnit;
        return $this;
    }
    /**
     * Add item to TransportHandlingUnit value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TransportHandlingUnitType $item
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function addToTransportHandlingUnit(\Gek\UyumBahce\StructType\TransportHandlingUnitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\TransportHandlingUnitType) {
            throw new \InvalidArgumentException(sprintf('The TransportHandlingUnit property can only contain items of type \Gek\UyumBahce\StructType\TransportHandlingUnitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportHandlingUnit[] = $item;
        return $this;
    }
    /**
     * Get ReturnAddress value
     * @return \Gek\UyumBahce\StructType\AddressType|null
     */
    public function getReturnAddress()
    {
        return $this->ReturnAddress;
    }
    /**
     * Set ReturnAddress value
     * @param \Gek\UyumBahce\StructType\AddressType $returnAddress
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setReturnAddress(\Gek\UyumBahce\StructType\AddressType $returnAddress = null)
    {
        $this->ReturnAddress = $returnAddress;
        return $this;
    }
    /**
     * Get FirstArrivalPortLocation value
     * @return \Gek\UyumBahce\StructType\LocationType|null
     */
    public function getFirstArrivalPortLocation()
    {
        return $this->FirstArrivalPortLocation;
    }
    /**
     * Set FirstArrivalPortLocation value
     * @param \Gek\UyumBahce\StructType\LocationType $firstArrivalPortLocation
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setFirstArrivalPortLocation(\Gek\UyumBahce\StructType\LocationType $firstArrivalPortLocation = null)
    {
        $this->FirstArrivalPortLocation = $firstArrivalPortLocation;
        return $this;
    }
    /**
     * Get LastExitPortLocation value
     * @return \Gek\UyumBahce\StructType\LocationType|null
     */
    public function getLastExitPortLocation()
    {
        return $this->LastExitPortLocation;
    }
    /**
     * Set LastExitPortLocation value
     * @param \Gek\UyumBahce\StructType\LocationType $lastExitPortLocation
     * @return \Gek\UyumBahce\StructType\ShipmentType
     */
    public function setLastExitPortLocation(\Gek\UyumBahce\StructType\LocationType $lastExitPortLocation = null)
    {
        $this->LastExitPortLocation = $lastExitPortLocation;
        return $this;
    }
}
