<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentStageType StructType
 * @subpackage Structs
 */
class ShipmentStageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var \Gek\UyumBahce\StructType\IDType
     */
    public $ID;
    /**
     * The TransportModeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransportModeCode
     * @var \Gek\UyumBahce\StructType\TransportModeCodeType
     */
    public $TransportModeCode;
    /**
     * The TransportMeansTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransportMeansTypeCode
     * @var \Gek\UyumBahce\StructType\TransportMeansTypeCodeType
     */
    public $TransportMeansTypeCode;
    /**
     * The TransitDirectionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransitDirectionCode
     * @var \Gek\UyumBahce\StructType\TransitDirectionCodeType
     */
    public $TransitDirectionCode;
    /**
     * The Instructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Instructions
     * @var \Gek\UyumBahce\StructType\InstructionsType[]
     */
    public $Instructions;
    /**
     * The TransitPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PeriodType
     */
    public $TransitPeriod;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\TransportMeansType
     */
    public $TransportMeans;
    /**
     * The DriverPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PersonType[]
     */
    public $DriverPerson;
    /**
     * Constructor method for ShipmentStageType
     * @uses ShipmentStageType::setID()
     * @uses ShipmentStageType::setTransportModeCode()
     * @uses ShipmentStageType::setTransportMeansTypeCode()
     * @uses ShipmentStageType::setTransitDirectionCode()
     * @uses ShipmentStageType::setInstructions()
     * @uses ShipmentStageType::setTransitPeriod()
     * @uses ShipmentStageType::setTransportMeans()
     * @uses ShipmentStageType::setDriverPerson()
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @param \Gek\UyumBahce\StructType\TransportModeCodeType $transportModeCode
     * @param \Gek\UyumBahce\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @param \Gek\UyumBahce\StructType\TransitDirectionCodeType $transitDirectionCode
     * @param \Gek\UyumBahce\StructType\InstructionsType[] $instructions
     * @param \Gek\UyumBahce\StructType\PeriodType $transitPeriod
     * @param \Gek\UyumBahce\StructType\TransportMeansType $transportMeans
     * @param \Gek\UyumBahce\StructType\PersonType[] $driverPerson
     */
    public function __construct(\Gek\UyumBahce\StructType\IDType $iD = null, \Gek\UyumBahce\StructType\TransportModeCodeType $transportModeCode = null, \Gek\UyumBahce\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null, \Gek\UyumBahce\StructType\TransitDirectionCodeType $transitDirectionCode = null, array $instructions = array(), \Gek\UyumBahce\StructType\PeriodType $transitPeriod = null, \Gek\UyumBahce\StructType\TransportMeansType $transportMeans = null, array $driverPerson = array())
    {
        $this
            ->setID($iD)
            ->setTransportModeCode($transportModeCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode)
            ->setTransitDirectionCode($transitDirectionCode)
            ->setInstructions($instructions)
            ->setTransitPeriod($transitPeriod)
            ->setTransportMeans($transportMeans)
            ->setDriverPerson($driverPerson);
    }
    /**
     * Get ID value
     * @return \Gek\UyumBahce\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @return \Gek\UyumBahce\StructType\ShipmentStageType
     */
    public function setID(\Gek\UyumBahce\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TransportModeCode value
     * @return \Gek\UyumBahce\StructType\TransportModeCodeType|null
     */
    public function getTransportModeCode()
    {
        return $this->TransportModeCode;
    }
    /**
     * Set TransportModeCode value
     * @param \Gek\UyumBahce\StructType\TransportModeCodeType $transportModeCode
     * @return \Gek\UyumBahce\StructType\ShipmentStageType
     */
    public function setTransportModeCode(\Gek\UyumBahce\StructType\TransportModeCodeType $transportModeCode = null)
    {
        $this->TransportModeCode = $transportModeCode;
        return $this;
    }
    /**
     * Get TransportMeansTypeCode value
     * @return \Gek\UyumBahce\StructType\TransportMeansTypeCodeType|null
     */
    public function getTransportMeansTypeCode()
    {
        return $this->TransportMeansTypeCode;
    }
    /**
     * Set TransportMeansTypeCode value
     * @param \Gek\UyumBahce\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @return \Gek\UyumBahce\StructType\ShipmentStageType
     */
    public function setTransportMeansTypeCode(\Gek\UyumBahce\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null)
    {
        $this->TransportMeansTypeCode = $transportMeansTypeCode;
        return $this;
    }
    /**
     * Get TransitDirectionCode value
     * @return \Gek\UyumBahce\StructType\TransitDirectionCodeType|null
     */
    public function getTransitDirectionCode()
    {
        return $this->TransitDirectionCode;
    }
    /**
     * Set TransitDirectionCode value
     * @param \Gek\UyumBahce\StructType\TransitDirectionCodeType $transitDirectionCode
     * @return \Gek\UyumBahce\StructType\ShipmentStageType
     */
    public function setTransitDirectionCode(\Gek\UyumBahce\StructType\TransitDirectionCodeType $transitDirectionCode = null)
    {
        $this->TransitDirectionCode = $transitDirectionCode;
        return $this;
    }
    /**
     * Get Instructions value
     * @return \Gek\UyumBahce\StructType\InstructionsType[]|null
     */
    public function getInstructions()
    {
        return $this->Instructions;
    }
    /**
     * This method is responsible for validating the values passed to the setInstructions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstructions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstructionsForArrayConstraintsFromSetInstructions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentStageTypeInstructionsItem) {
            // validation for constraint: itemType
            if (!$shipmentStageTypeInstructionsItem instanceof \Gek\UyumBahce\StructType\InstructionsType) {
                $invalidValues[] = is_object($shipmentStageTypeInstructionsItem) ? get_class($shipmentStageTypeInstructionsItem) : sprintf('%s(%s)', gettype($shipmentStageTypeInstructionsItem), var_export($shipmentStageTypeInstructionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Instructions property can only contain items of type \Gek\UyumBahce\StructType\InstructionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Instructions value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\InstructionsType[] $instructions
     * @return \Gek\UyumBahce\StructType\ShipmentStageType
     */
    public function setInstructions(array $instructions = array())
    {
        // validation for constraint: array
        if ('' !== ($instructionsArrayErrorMessage = self::validateInstructionsForArrayConstraintsFromSetInstructions($instructions))) {
            throw new \InvalidArgumentException($instructionsArrayErrorMessage, __LINE__);
        }
        $this->Instructions = $instructions;
        return $this;
    }
    /**
     * Add item to Instructions value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\InstructionsType $item
     * @return \Gek\UyumBahce\StructType\ShipmentStageType
     */
    public function addToInstructions(\Gek\UyumBahce\StructType\InstructionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\InstructionsType) {
            throw new \InvalidArgumentException(sprintf('The Instructions property can only contain items of type \Gek\UyumBahce\StructType\InstructionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Instructions[] = $item;
        return $this;
    }
    /**
     * Get TransitPeriod value
     * @return \Gek\UyumBahce\StructType\PeriodType|null
     */
    public function getTransitPeriod()
    {
        return $this->TransitPeriod;
    }
    /**
     * Set TransitPeriod value
     * @param \Gek\UyumBahce\StructType\PeriodType $transitPeriod
     * @return \Gek\UyumBahce\StructType\ShipmentStageType
     */
    public function setTransitPeriod(\Gek\UyumBahce\StructType\PeriodType $transitPeriod = null)
    {
        $this->TransitPeriod = $transitPeriod;
        return $this;
    }
    /**
     * Get TransportMeans value
     * @return \Gek\UyumBahce\StructType\TransportMeansType|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }
    /**
     * Set TransportMeans value
     * @param \Gek\UyumBahce\StructType\TransportMeansType $transportMeans
     * @return \Gek\UyumBahce\StructType\ShipmentStageType
     */
    public function setTransportMeans(\Gek\UyumBahce\StructType\TransportMeansType $transportMeans = null)
    {
        $this->TransportMeans = $transportMeans;
        return $this;
    }
    /**
     * Get DriverPerson value
     * @return \Gek\UyumBahce\StructType\PersonType[]|null
     */
    public function getDriverPerson()
    {
        return $this->DriverPerson;
    }
    /**
     * This method is responsible for validating the values passed to the setDriverPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDriverPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDriverPersonForArrayConstraintsFromSetDriverPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentStageTypeDriverPersonItem) {
            // validation for constraint: itemType
            if (!$shipmentStageTypeDriverPersonItem instanceof \Gek\UyumBahce\StructType\PersonType) {
                $invalidValues[] = is_object($shipmentStageTypeDriverPersonItem) ? get_class($shipmentStageTypeDriverPersonItem) : sprintf('%s(%s)', gettype($shipmentStageTypeDriverPersonItem), var_export($shipmentStageTypeDriverPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DriverPerson property can only contain items of type \Gek\UyumBahce\StructType\PersonType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DriverPerson value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PersonType[] $driverPerson
     * @return \Gek\UyumBahce\StructType\ShipmentStageType
     */
    public function setDriverPerson(array $driverPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($driverPersonArrayErrorMessage = self::validateDriverPersonForArrayConstraintsFromSetDriverPerson($driverPerson))) {
            throw new \InvalidArgumentException($driverPersonArrayErrorMessage, __LINE__);
        }
        $this->DriverPerson = $driverPerson;
        return $this;
    }
    /**
     * Add item to DriverPerson value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PersonType $item
     * @return \Gek\UyumBahce\StructType\ShipmentStageType
     */
    public function addToDriverPerson(\Gek\UyumBahce\StructType\PersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\PersonType) {
            throw new \InvalidArgumentException(sprintf('The DriverPerson property can only contain items of type \Gek\UyumBahce\StructType\PersonType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DriverPerson[] = $item;
        return $this;
    }
}
