<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentInformation StructType
 * @subpackage Structs
 */
class ShipmentInformation extends AbstractStructBase
{
    /**
     * The SendDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SendDate;
    /**
     * The Carier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ShipmentCarier
     */
    public $Carier;
    /**
     * Constructor method for ShipmentInformation
     * @uses ShipmentInformation::setSendDate()
     * @uses ShipmentInformation::setCarier()
     * @param string $sendDate
     * @param \Gek\UyumBahce\StructType\ShipmentCarier $carier
     */
    public function __construct($sendDate = null, \Gek\UyumBahce\StructType\ShipmentCarier $carier = null)
    {
        $this
            ->setSendDate($sendDate)
            ->setCarier($carier);
    }
    /**
     * Get SendDate value
     * @return string
     */
    public function getSendDate()
    {
        return $this->SendDate;
    }
    /**
     * Set SendDate value
     * @param string $sendDate
     * @return \Gek\UyumBahce\StructType\ShipmentInformation
     */
    public function setSendDate($sendDate = null)
    {
        // validation for constraint: string
        if (!is_null($sendDate) && !is_string($sendDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendDate, true), gettype($sendDate)), __LINE__);
        }
        $this->SendDate = $sendDate;
        return $this;
    }
    /**
     * Get Carier value
     * @return \Gek\UyumBahce\StructType\ShipmentCarier|null
     */
    public function getCarier()
    {
        return $this->Carier;
    }
    /**
     * Set Carier value
     * @param \Gek\UyumBahce\StructType\ShipmentCarier $carier
     * @return \Gek\UyumBahce\StructType\ShipmentInformation
     */
    public function setCarier(\Gek\UyumBahce\StructType\ShipmentCarier $carier = null)
    {
        $this->Carier = $carier;
        return $this;
    }
}
