<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRequestOfRequestDef StructType
 * @subpackage Structs
 */
class ServiceRequestOfRequestDef extends AbstractStructBase
{
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageSize;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\Token
     */
    public $Token;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\RequestDef
     */
    public $Value;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Attachment;
    /**
     * Constructor method for ServiceRequestOfRequestDef
     * @uses ServiceRequestOfRequestDef::setPageIndex()
     * @uses ServiceRequestOfRequestDef::setPageSize()
     * @uses ServiceRequestOfRequestDef::setToken()
     * @uses ServiceRequestOfRequestDef::setValue()
     * @uses ServiceRequestOfRequestDef::setAttachment()
     * @param int $pageIndex
     * @param int $pageSize
     * @param \Gek\UyumBahce\StructType\Token $token
     * @param \Gek\UyumBahce\StructType\RequestDef $value
     * @param string $attachment
     */
    public function __construct($pageIndex = null, $pageSize = null, \Gek\UyumBahce\StructType\Token $token = null, \Gek\UyumBahce\StructType\RequestDef $value = null, $attachment = null)
    {
        $this
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize)
            ->setToken($token)
            ->setValue($value)
            ->setAttachment($attachment);
    }
    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }
    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return \Gek\UyumBahce\StructType\ServiceRequestOfRequestDef
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \Gek\UyumBahce\StructType\ServiceRequestOfRequestDef
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get Token value
     * @return \Gek\UyumBahce\StructType\Token|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param \Gek\UyumBahce\StructType\Token $token
     * @return \Gek\UyumBahce\StructType\ServiceRequestOfRequestDef
     */
    public function setToken(\Gek\UyumBahce\StructType\Token $token = null)
    {
        $this->Token = $token;
        return $this;
    }
    /**
     * Get Value value
     * @return \Gek\UyumBahce\StructType\RequestDef|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \Gek\UyumBahce\StructType\RequestDef $value
     * @return \Gek\UyumBahce\StructType\ServiceRequestOfRequestDef
     */
    public function setValue(\Gek\UyumBahce\StructType\RequestDef $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Attachment value
     * @return string|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @param string $attachment
     * @return \Gek\UyumBahce\StructType\ServiceRequestOfRequestDef
     */
    public function setAttachment($attachment = null)
    {
        // validation for constraint: string
        if (!is_null($attachment) && !is_string($attachment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachment, true), gettype($attachment)), __LINE__);
        }
        $this->Attachment = $attachment;
        return $this;
    }
}
